/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.service.SessionService;
import com.becon.opencelium.backend.database.mysql.service.TotpService;
import com.becon.opencelium.backend.database.mysql.service.UserService;
import com.becon.opencelium.backend.resource.user.TotpResource;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TotpServiceImpl
implements TotpService {
    @Autowired
    private UserService userService;
    @Autowired
    private SessionService sessionService;
    private final GoogleAuthenticator provider = new GoogleAuthenticator();

    @Transactional(readOnly=true)
    public TotpResource getTotpResource(User user) {
        String sessionId = user.getSession().getId();
        String secretKey = user.getTotpSecretKey();
        String issuer = "opencelium";
        String account = user.getPrincipal();
        String data = String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", issuer, account, secretKey, issuer);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        int width = 300;
        int height = 300;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode(data, BarcodeFormat.QR_CODE, width, height);
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    image.setRGB(x, y, bitMatrix.get(x, y) ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                }
            }
            ImageIO.write((RenderedImage)image, "PNG", baos);
            byte[] qrCodeImage = baos.toByteArray();
            String base64Image = Base64.getEncoder().encodeToString(qrCodeImage);
            return new TotpResource(sessionId, secretKey, "data:image/png;base64," + base64Image);
        }
        catch (WriterException | IOException e) {
            throw new RuntimeException("Failed to generate QR code for TOTP");
        }
    }

    @Transactional
    public void totpAction(int userId, String action) {
        User user = this.userService.getById(Integer.valueOf(userId));
        if ("enable".equals(action)) {
            if (user.getTotpSecretKey() != null) {
                return;
            }
            String secretKey = this.provider.createCredentials().getKey();
            user.setTotpSecretKey(secretKey);
            this.sessionService.deleteByUserId(userId);
        } else if ("disable".equals(action)) {
            user.setTotpProcessCompleted(false);
            user.setTotpSecretKey(null);
        } else {
            throw new RuntimeException("Wrong TOTP action is supplied, available options: [enable, disable]");
        }
    }

    public boolean isValidTotp(String secret, String code) {
        return this.provider.authorize(secret, Integer.parseInt(code));
    }
}

