/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.database.mysql.entity.SecretKey;
import com.becon.opencelium.backend.database.mysql.repository.RequestDataRepository;
import com.becon.opencelium.backend.database.mysql.repository.SecretKeyRepository;
import com.becon.opencelium.backend.database.mysql.service.RequestDataService;
import com.becon.opencelium.backend.utility.crypto.Encoder;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class RequestDataServiceImp
implements RequestDataService {
    private final RequestDataRepository requestDataRepository;
    private final SecretKeyRepository secretKeyRepository;
    private final Encoder encoder;

    public RequestDataServiceImp(RequestDataRepository requestDataRepository, SecretKeyRepository secretKeyRepository, Encoder encoder) {
        this.requestDataRepository = requestDataRepository;
        this.secretKeyRepository = secretKeyRepository;
        this.encoder = encoder;
    }

    public Optional<RequestData> findByConnectorIdAndField(int connectorId, String field) {
        return this.requestDataRepository.findByConnectorIdAndField(connectorId, field);
    }

    public List<RequestData> saveAll(List<RequestData> requestData) {
        return this.requestDataRepository.saveAll(requestData);
    }

    private void encrypt(RequestData requestData) {
        if (requestData != null) {
            requestData.setValue(this.encoder.encrypt(requestData.getValue()));
        }
    }

    private void decrypt(RequestData requestData) {
        if (requestData != null) {
            requestData.setValue(this.encoder.decrypt(requestData.getValue()));
        }
    }

    public void prepare() {
        List all = this.requestDataRepository.findAll();
        Optional curr = this.secretKeyRepository.getSecretKey();
        boolean changed = false;
        if (curr.isPresent()) {
            String newSK;
            String oldSK = ((SecretKey)curr.get()).getSecretKey();
            if (!oldSK.equals(newSK = this.encoder.getSecretKey())) {
                changed = true;
                Encoder customEncoder = new Encoder(oldSK);
                for (RequestData requestData : all) {
                    try {
                        requestData.setValue(customEncoder.decrypt(requestData.getValue()));
                        this.requestDataRepository.save((Object)requestData);
                    }
                    catch (Exception exception) {}
                }
                this.secretKeyRepository.deleteAll();
                this.secretKeyRepository.save((Object)new SecretKey(newSK));
            }
        } else {
            this.secretKeyRepository.save((Object)new SecretKey(this.encoder.getSecretKey()));
        }
        for (RequestData requestData : all) {
            if (changed) {
                this.encrypt(requestData);
                this.requestDataRepository.save((Object)requestData);
                continue;
            }
            try {
                this.decrypt(requestData);
            }
            catch (Exception e) {
                this.encrypt(requestData);
                this.requestDataRepository.save((Object)requestData);
            }
        }
    }

    public void deleteById(int id) {
        this.requestDataRepository.deleteById((Object)id);
    }
}

