/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.EventContent;
import com.becon.opencelium.backend.database.mysql.entity.EventMessage;
import com.becon.opencelium.backend.database.mysql.repository.MessageRepository;
import com.becon.opencelium.backend.database.mysql.service.ContentServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.MessageService;
import com.becon.opencelium.backend.resource.notification.MessageResource;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements MessageService {
    @Autowired
    private MessageRepository messageRepository;
    @Autowired
    private ContentServiceImpl contentService;

    public void save(EventMessage eventMessage) {
        this.messageRepository.save((Object)eventMessage);
        eventMessage.getEventContents().forEach(content -> this.contentService.save(content));
    }

    public void deleteById(int id) {
        this.findById(id).orElseThrow(() -> new RuntimeException("TEMPLATE_NOT_FOUND"));
        this.messageRepository.deleteById((Object)id);
    }

    public List<EventMessage> findAll() {
        return this.messageRepository.findAll();
    }

    public Optional<EventMessage> findById(int id) {
        return this.messageRepository.findById((Object)id);
    }

    public List<EventMessage> findAllByType(String type) {
        return this.messageRepository.findAllByType(type);
    }

    public EventMessage toEntity(MessageResource messageResource) {
        EventMessage eventMessage = new EventMessage();
        eventMessage.setId(messageResource.getTemplateId());
        eventMessage.setName(messageResource.getName());
        eventMessage.setType(messageResource.getType());
        List<EventContent> eventContents = messageResource.getContent().stream().map(EventContent::new).collect(Collectors.toList());
        eventContents.forEach(content -> content.setEventMessage(eventMessage));
        eventMessage.setEventContents(eventContents);
        return eventMessage;
    }

    public MessageResource toResource(EventMessage eventMessage) {
        return new MessageResource(eventMessage);
    }
}

