/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Execution;
import com.becon.opencelium.backend.database.mysql.repository.ExecutionRepository;
import com.becon.opencelium.backend.database.mysql.service.ExecutionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutionServiceImp
implements ExecutionService {
    @Autowired
    private ExecutionRepository executionRepository;

    public Execution save(Execution execution) {
        return (Execution)this.executionRepository.save((Object)execution);
    }

    public void deleteAllBySchedulerId(int schedulerId) {
        this.executionRepository.deleteBySchedulerId(schedulerId);
    }

    public List<Execution> getExecutionsBySchedulerId(int schedulerId) {
        return this.executionRepository.findBySchedulerId(schedulerId);
    }

    public Optional<Execution> findById(long id) {
        return this.executionRepository.findById((Object)id);
    }

    public Execution getById(long id) {
        return (Execution)this.executionRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("EXECUTION_NOT_FOUND"));
    }

    public double getAvgDurationOfExecution(int schedulerId) {
        List executions = this.getExecutionsBySchedulerId(schedulerId);
        ArrayList<Long> diffArray = new ArrayList<Long>();
        for (Execution e : executions) {
            if (e.getEndTime() == null || !e.getStatus().equals("S")) continue;
            long endTime = e.getEndTime().getTime();
            long startTime = e.getStartTime().getTime();
            diffArray.add(endTime - startTime);
        }
        return diffArray.stream().mapToDouble(x -> x.longValue()).average().orElse(0.0);
    }
}

