/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mongodb.entity.EnhancementMng;
import com.becon.opencelium.backend.database.mongodb.entity.FieldBindingMng;
import com.becon.opencelium.backend.database.mongodb.entity.LinkedFieldMng;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.database.mysql.repository.EnhancementRepository;
import com.becon.opencelium.backend.database.mysql.service.EnhancementService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.connection.binding.EnhancementDTO;
import com.becon.opencelium.backend.utility.PathUtility;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class EnhancementServiceImp
implements EnhancementService {
    private final EnhancementRepository enhancementRepository;
    private final Mapper<Enhancement, EnhancementDTO> enhancementMapper;
    private final Mapper<EnhancementMng, EnhancementDTO> enhancementMngMapper;

    public EnhancementServiceImp(EnhancementRepository enhancementRepository, Mapper<Enhancement, EnhancementDTO> enhancementMapper, Mapper<EnhancementMng, EnhancementDTO> enhancementMngMapper) {
        this.enhancementRepository = enhancementRepository;
        this.enhancementMapper = enhancementMapper;
        this.enhancementMngMapper = enhancementMngMapper;
    }

    public Enhancement save(Enhancement enhancement) {
        return (Enhancement)this.enhancementRepository.save((Object)enhancement);
    }

    public List<Enhancement> saveAll(List<Enhancement> enhancement) {
        return this.enhancementRepository.saveAll(enhancement);
    }

    public List<Enhancement> findAllByConnectionId(Long connectionId) {
        return this.enhancementRepository.findAllByConnectionId(connectionId);
    }

    public void deleteAllByConnectionId(Long connectionId) {
        this.enhancementRepository.deleteByConnectionId(connectionId);
    }

    public Enhancement getById(Integer id) {
        return (Enhancement)this.enhancementRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("ENHANCEMENT_NOT_FOUND"));
    }

    public Optional<Enhancement> findById(Integer enhId) {
        if (enhId == null) {
            return Optional.empty();
        }
        return this.enhancementRepository.findById((Object)enhId);
    }

    public void deleteAll(List<Integer> ids) {
        this.enhancementRepository.deleteAllById(ids);
    }

    public boolean existById(Integer id) {
        return this.enhancementRepository.existsById((Object)id);
    }

    public void deleteById(Integer id) {
        this.enhancementRepository.deleteById((Object)id);
    }

    public void deleteAll() {
        this.enhancementRepository.deleteAll();
    }

    public FieldBindingMng toFieldBinding(Enhancement enhancement) {
        FieldBindingMng fieldBindingMng = new FieldBindingMng();
        EnhancementMng enhancementMng = (EnhancementMng)this.enhancementMngMapper.toEntity((Object)((EnhancementDTO)this.enhancementMapper.toDTO((Object)enhancement)));
        fieldBindingMng.setEnhancementId(enhancement.getId());
        List toField = Arrays.stream(enhancement.getArgs().split(";")).filter(f -> f.contains("RESULT_VAR")).map(f -> f.split("=")[1].trim()).map(arg_0 -> this.toLinkedFieldResource(arg_0)).collect(Collectors.toList());
        List fromField = Arrays.stream(enhancement.getArgs().split(";")).filter(f -> !f.contains("RESULT_VAR")).map(f -> f.split("=")[1].trim()).map(arg_0 -> this.toLinkedFieldResource(arg_0)).collect(Collectors.toList());
        fieldBindingMng.setEnhancement(enhancementMng);
        fieldBindingMng.setFrom(fromField);
        fieldBindingMng.setTo(toField);
        return fieldBindingMng;
    }

    private LinkedFieldMng toLinkedFieldResource(String value) {
        value = value.trim();
        String exchange = PathUtility.getExchange((String)value);
        String status = value.split("\\.")[1];
        status = status.substring(1, status.length() - 1);
        String fields = PathUtility.getFields((String)value);
        LinkedFieldMng lf = new LinkedFieldMng();
        lf.setColor("#" + exchange);
        lf.setType(status);
        lf.setField(fields);
        return lf;
    }
}

