/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.EditorSettings;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.repository.EditorSettingsRepository;
import com.becon.opencelium.backend.database.mysql.service.EditorSettingsService;
import com.becon.opencelium.backend.database.mysql.service.UserService;
import com.becon.opencelium.backend.resource.EditorSettingsDTO;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EditorSettingsServiceImp
implements EditorSettingsService {
    private final UserService userService;
    private final EditorSettingsRepository repository;

    public EditorSettingsServiceImp(@Qualifier(value="userServiceImpl") UserService userService, EditorSettingsRepository repository) {
        this.userService = userService;
        this.repository = repository;
    }

    public EditorSettings save(EditorSettingsDTO settingsDto) {
        if (settingsDto == null) {
            throw new IllegalArgumentException("settings is null");
        }
        Integer userId = settingsDto.getUserId();
        if (userId == null || !this.userService.existsById(userId.intValue())) {
            throw new IllegalArgumentException("user not found with given userId");
        }
        User user = this.userService.getById(userId);
        EditorSettings settings = this.repository.findEditorSettingsByUser(user).orElse(new EditorSettings());
        settings.setUser(user);
        settings.setColorMode(settingsDto.getColorMode());
        settings.setProcessTextSize(settingsDto.getProcessTextSize().intValue());
        this.repository.save((Object)settings);
        return settings;
    }

    public EditorSettings getByUserId(Integer userId) {
        if (userId == null || !this.userService.existsById(userId.intValue())) {
            throw new IllegalArgumentException("user not found with given userId");
        }
        User user = new User();
        user.setId(userId.intValue());
        return (EditorSettings)this.repository.findEditorSettingsByUser(user).orElseThrow(() -> new IllegalArgumentException("settings not found with given userId"));
    }
}

