/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.Argument;
import com.becon.opencelium.backend.database.mysql.entity.DataAggregator;
import com.becon.opencelium.backend.database.mysql.repository.DataAggregatorRepository;
import com.becon.opencelium.backend.database.mysql.service.ArgumentService;
import com.becon.opencelium.backend.database.mysql.service.DataAggregatorService;
import com.becon.opencelium.backend.resource.connection.aggregator.ArgumentDTO;
import com.becon.opencelium.backend.resource.connection.aggregator.DataAggregatorDTO;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DataAggregatorServiceImp
implements DataAggregatorService {
    private final ArgumentService argumentService;
    private final DataAggregatorRepository dataAggregatorRepository;

    @Autowired
    public DataAggregatorServiceImp(@Qualifier(value="ArgumentServiceImp") ArgumentService argumentService, DataAggregatorRepository dataAggregatorRepository) {
        this.argumentService = argumentService;
        this.dataAggregatorRepository = dataAggregatorRepository;
    }

    public DataAggregatorDTO convertToDto(DataAggregator dataAggregator) {
        DataAggregatorDTO dataAggregatorDTO = new DataAggregatorDTO();
        dataAggregatorDTO.setId(dataAggregator.getId());
        dataAggregatorDTO.setName(dataAggregator.getName());
        dataAggregatorDTO.setScript(dataAggregator.getScript());
        dataAggregatorDTO.setActive(dataAggregator.isActive());
        List<ArgumentDTO> argumentDtos = dataAggregator.getArgs().stream().map(arg_0 -> ((ArgumentService)this.argumentService).convertToDto(arg_0)).toList();
        dataAggregatorDTO.setArgs(argumentDtos);
        return dataAggregatorDTO;
    }

    public DataAggregator convertToEntity(DataAggregatorDTO dataAggregatorDTO) {
        DataAggregator dataAggregator = new DataAggregator();
        dataAggregator.setId(dataAggregatorDTO.getId());
        dataAggregator.setName(dataAggregatorDTO.getName());
        dataAggregator.setActive(dataAggregatorDTO.isActive());
        dataAggregator.setScript(dataAggregatorDTO.getScript());
        dataAggregator.setActive(dataAggregatorDTO.isActive());
        Set<Argument> arguments = dataAggregatorDTO.getArgs().stream().map(arg_0 -> ((ArgumentService)this.argumentService).convertToEntity(arg_0)).collect(Collectors.toSet());
        arguments.forEach(arg -> arg.setDataAggregator(dataAggregator));
        dataAggregator.setArgs(arguments);
        return dataAggregator;
    }

    public void save(DataAggregator dataAggregator) {
        this.dataAggregatorRepository.save((Object)dataAggregator);
    }

    public DataAggregator getById(Integer id) {
        return (DataAggregator)this.dataAggregatorRepository.findById((Object)id).orElseThrow(() -> new RuntimeException("Aggregator with id=" + id + " not found"));
    }

    public void deleteById(Integer id) {
        this.dataAggregatorRepository.deleteById((Object)id);
    }

    public List<DataAggregator> findAll() {
        return this.dataAggregatorRepository.findAll();
    }

    public Boolean existsByName(String argName) {
        return this.dataAggregatorRepository.existsByName(argName);
    }
}

