/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.service;

import com.becon.opencelium.backend.database.mysql.entity.ActivationRequest;
import com.becon.opencelium.backend.database.mysql.repository.ActivationRequestRepository;
import com.becon.opencelium.backend.database.mysql.service.ActivationRequestService;
import com.becon.opencelium.backend.enums.ActivReqStatus;
import com.becon.opencelium.backend.utility.MachineUtility;
import com.becon.opencelium.backend.utility.crypto.HmacUtility;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class ActivationRequestServiceImp
implements ActivationRequestService {
    private final ActivationRequestRepository activationRequestRepository;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);

    public ActivationRequestServiceImp(ActivationRequestRepository activationRequestRepository) {
        this.activationRequestRepository = activationRequestRepository;
    }

    public ActivationRequest save(ActivationRequest activationRequest) {
        return (ActivationRequest)this.activationRequestRepository.save((Object)activationRequest);
    }

    public boolean verify(ActivationRequest activationRequest, String hmac) {
        return activationRequest.verify(hmac);
    }

    public ActivationRequest generateActivReq() {
        ActivationRequest ar = new ActivationRequest();
        ar.setId(UUID.randomUUID().toString());
        ar.setCreatedAt(LocalDateTime.now());
        ar.setStatus(ActivReqStatus.PENDING);
        ar.setTtl(3600);
        ar.setActive(false);
        ar.setHmac(HmacUtility.encode((String)(ar.getId() + MachineUtility.getStringForHmacEncode())));
        return ar;
    }

    public void activateTTL(ActivationRequest activationRequest) {
        this.scheduler.schedule(() -> this.activationRequestRepository.updateStatusIfNotProcessed(activationRequest.getId(), ActivReqStatus.EXPIRED, ActivReqStatus.PROCESSED), (long)activationRequest.getTtl(), TimeUnit.SECONDS);
    }

    public void deactivateAll() {
        this.activationRequestRepository.expireAllActivationRequests();
        this.activationRequestRepository.deactivateAll();
    }

    public ActivationRequest getActiveAR() {
        return this.activationRequestRepository.findActiveAR().orElse(null);
    }

    public File createFile(String ar, String fileName) {
        try {
            File tempFile = File.createTempFile(fileName, ".txt");
            FileWriter writer = new FileWriter(tempFile);
            writer.write(ar);
            writer.close();
            return tempFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ActivationRequest findByHmac(String hmac) {
        return (ActivationRequest)this.activationRequestRepository.findFirstByHmac(hmac).orElseThrow(() -> new RuntimeException("Activation Request not found by hmac: " + hmac));
    }

    public Optional<ActivationRequest> readFreeAR() {
        try {
            ActivationRequest ar = this.decodeBase64AR("eyJpZCI6ImVmZjA0MmExLWI5ZGItNDNiMy04NTVkLWI2MmQ3MTJjZTRjOSIsImhtYWMiOiJJMUkzbFk3SVE0akM2ajA3M0JIenNwOTJHNThJbWRzNFl3TTEvdEdiTHE4PSIsInR0bCI6MzYwMCwic3RhdHVzIjoiUEVORElORyIsIm1hY2hpbmVVdWlkIjoiTUFDSElORV9VVUlEIiwibWFjQWRkcmVzcyI6Ik1BQ19BRERSRVNTIiwic3lzdGVtVVVJRCI6IlNZU1RFTV9VVUlEIiwiY29tcHV0ZXJOYW1lIjoiQ09NUFVURVJfTkFNRSJ9");
            return Optional.of(ar);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<ActivationRequest> findById(String id) {
        return this.activationRequestRepository.findById((Object)id);
    }

    public ActivationRequest decodeBase64AR(String base64EncodedAR) throws IOException {
        byte[] decodedBytes = Base64.getDecoder().decode(base64EncodedAR);
        String jsonString = new String(decodedBytes);
        ObjectMapper objectMapper = new ObjectMapper();
        return (ActivationRequest)objectMapper.readValue(jsonString, ActivationRequest.class);
    }
}

