/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.EventNotification;
import com.becon.opencelium.backend.database.mysql.entity.Execution;
import com.becon.opencelium.backend.database.mysql.entity.LastExecution;
import com.becon.opencelium.backend.database.mysql.entity.Webhook;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.UpdateTimestamp;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="scheduler")
@EntityListeners(value={AuditingEntityListener.class})
public class Scheduler {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @Column(name="title")
    private String title;
    @Column(name="status")
    private boolean status;
    @Column(name="debug_mode")
    private boolean debugMode;
    @Column(name="cron_exp")
    private String cronExp;
    @CreatedBy
    @Column(name="created_by", updatable=false)
    private Integer createdBy;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_on", updatable=false)
    private Date createdOn;
    @LastModifiedBy
    @Column(name="modified_by")
    private Integer modifiedBy;
    @UpdateTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="modified_on")
    private Date modifiedOn;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="connection_id")
    private Connection connection;
    @OneToOne(mappedBy="scheduler", fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    private Webhook webhook;
    @JsonIgnore
    @OneToOne(mappedBy="scheduler", fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    private LastExecution lastExecution;
    @OneToMany(mappedBy="scheduler", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Execution> executions;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @OneToMany(mappedBy="scheduler", cascade={CascadeType.REMOVE})
    private List<EventNotification> eventNotifications;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getCronExp() {
        return this.cronExp;
    }

    public void setCronExp(String cronExp) {
        this.cronExp = cronExp;
    }

    public Integer getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Integer getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Integer modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isStatus() {
        return this.status;
    }

    public Webhook getWebhook() {
        return this.webhook;
    }

    public void setWebhook(Webhook webhook) {
        this.webhook = webhook;
    }

    public LastExecution getLastExecution() {
        return this.lastExecution;
    }

    public void setLastExecution(LastExecution lastExecution) {
        this.lastExecution = lastExecution;
    }

    public List<Execution> getExecutions() {
        return this.executions;
    }

    public void setExecutions(List<Execution> executions) {
        this.executions = executions;
    }

    public List<EventNotification> getEventNotifications() {
        return this.eventNotifications;
    }

    public void setEventNotifications(List<EventNotification> eventNotifications) {
        this.eventNotifications = eventNotifications;
    }
}

