/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.database.mysql.entity;

import com.becon.opencelium.backend.database.mysql.entity.BusinessLayout;
import com.becon.opencelium.backend.database.mysql.entity.Enhancement;
import com.becon.opencelium.backend.database.mysql.entity.Scheduler;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="connection")
@EntityListeners(value={AuditingEntityListener.class})
public class Connection {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="title")
    private String title;
    @Column(name="description")
    private String description;
    @Column(name="from_connector")
    private int fromConnector;
    @Column(name="to_connector")
    private int toConnector;
    @CreatedBy
    @Column(name="created_by", updatable=false)
    private Integer createdBy;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_on", updatable=false)
    private Date createdOn;
    @LastModifiedBy
    @Column(name="modified_by")
    private Integer modifiedBy;
    @UpdateTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="modified_on")
    private Date modifiedOn;
    @Column(name="icon")
    private String icon;
    @OneToMany(mappedBy="connection", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<Enhancement> enhancements;
    @OneToMany(mappedBy="connection", fetch=FetchType.LAZY)
    private List<Scheduler> schedulers;
    @JsonIgnore
    @OneToOne(mappedBy="connection", cascade={CascadeType.ALL}, orphanRemoval=true)
    private BusinessLayout businessLayout;
    @Column(name="category_id")
    private Integer categoryId;
    @Column(name="oc_version")
    private String ocVersion;

    public Connection() {
    }

    public Connection(long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getFromConnector() {
        return this.fromConnector;
    }

    public void setFromConnector(int fromConnector) {
        this.fromConnector = fromConnector;
    }

    public int getToConnector() {
        return this.toConnector;
    }

    public void setToConnector(int toConnector) {
        this.toConnector = toConnector;
    }

    public Integer getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(Integer createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Integer getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Integer modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<Enhancement> getEnhancements() {
        return this.enhancements;
    }

    public void setEnhancements(List<Enhancement> enhancements) {
        this.enhancements = enhancements;
    }

    public List<Scheduler> getSchedulers() {
        return this.schedulers;
    }

    public void setSchedulers(List<Scheduler> schedulers) {
        this.schedulers = schedulers;
    }

    public BusinessLayout getBusinessLayout() {
        return this.businessLayout;
    }

    public void setBusinessLayout(BusinessLayout businessLayout) {
        this.businessLayout = businessLayout;
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    public String getOcVersion() {
        return this.ocVersion;
    }

    public void setOcVersion(String version) {
        this.ocVersion = version;
    }

    public String toString() {
        return "Connection{id=" + this.id + ", title='" + this.title + "', description='" + this.description + "', fromConnector=" + this.fromConnector + ", toConnector=" + this.toConnector + ", createdBy=" + this.createdBy + ", createdOn=" + this.createdOn + ", modifiedBy=" + this.modifiedBy + ", modifiedOn=" + this.modifiedOn + ", enhancements=" + this.enhancements + ", schedulers=" + this.schedulers + ", businessLayout=" + this.businessLayout + ", icon=" + this.icon + "}";
    }
}

