/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.entity.WidgetSetting;
import com.becon.opencelium.backend.database.mysql.service.UserServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.WidgetSettingServiceImp;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.user.UserWidgetsResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@Controller
@Tag(name="Widget Settings", description="Manages operations related to WidgetSetting that contains coordinates of widget for frontend")
@RequestMapping(value={"/widget_setting"}, produces={"application/json"})
public class WidgetSettingController {
    @Autowired
    private WidgetSettingServiceImp widgetSettingServiceImp;
    @Autowired
    private UserServiceImpl userService;

    @Operation(summary="Creates a new widget setting related to user")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Widget Settings are successfully created.", content={@Content(schema=@Schema(implementation=UserWidgetsResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> create(@RequestBody UserWidgetsResource userWidgetsResource) {
        int userId = userWidgetsResource.getUserId();
        User user = (User)this.userService.findById(userId).orElseThrow(() -> new RuntimeException("User not found"));
        List initWidgetSettings = this.widgetSettingServiceImp.findAllByUserId(userId);
        List widgetSettings = userWidgetsResource.getWidgetSettings().stream().map(uwr -> this.widgetSettingServiceImp.toEntity(uwr, userId)).collect(Collectors.toList());
        if (widgetSettings.isEmpty()) {
            this.widgetSettingServiceImp.deleteAll();
        } else {
            initWidgetSettings.forEach(iws -> {
                boolean contains = false;
                for (WidgetSetting ws : widgetSettings) {
                    if (ws.getId() != iws.getId()) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    this.widgetSettingServiceImp.deleteById(iws.getId());
                }
            });
        }
        this.widgetSettingServiceImp.saveAll(widgetSettings);
        initWidgetSettings = this.widgetSettingServiceImp.findAllByUserId(userId);
        List widgetSettingResources = initWidgetSettings.stream().map(ws -> this.widgetSettingServiceImp.toResource(ws)).collect(Collectors.toList());
        UserWidgetsResource resource = new UserWidgetsResource();
        resource.setUserId(user.getId());
        resource.setWidgetSettings(widgetSettingResources);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).path("/{id}").buildAndExpand(new Object[]{resource.getUserId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)resource);
    }

    @Operation(summary="Return widgets of user by provided userId")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Widget has been successfully retrieved.", content={@Content(schema=@Schema(implementation=UserWidgetsResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/user/{id}"})
    public ResponseEntity<?> getByUserId(@PathVariable(value="id") int id) {
        List widgetSetting = this.widgetSettingServiceImp.findByUserId(id);
        List resources = widgetSetting.stream().map(ws -> this.widgetSettingServiceImp.toResource(ws)).collect(Collectors.toList());
        UserWidgetsResource userWidgetsResource = new UserWidgetsResource();
        userWidgetsResource.setUserId(id);
        userWidgetsResource.setWidgetSettings(resources);
        return ResponseEntity.ok().body((Object)userWidgetsResource);
    }
}

