/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.api.ApiClient;
import com.becon.opencelium.backend.api.ApiType;
import com.becon.opencelium.backend.api.factory.ApiFactory;
import com.becon.opencelium.backend.api.module.SubscriptionModule;
import com.becon.opencelium.backend.api.serviceportal.ServicePortal;
import com.becon.opencelium.backend.database.mysql.entity.ActivationRequest;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.service.ActivationRequestService;
import com.becon.opencelium.backend.database.mysql.service.ExtraOpsService;
import com.becon.opencelium.backend.database.mysql.service.OperationUsageHistoryService;
import com.becon.opencelium.backend.database.mysql.service.SubscriptionService;
import com.becon.opencelium.backend.enums.ActivReqStatus;
import com.becon.opencelium.backend.mapper.mysql.ActivationRequestMapper;
import com.becon.opencelium.backend.resource.subs.PaginatedDto;
import com.becon.opencelium.backend.resource.subs.SubsDTO;
import com.becon.opencelium.backend.subscription.dto.ActivationRequestDTO;
import com.becon.opencelium.backend.subscription.dto.LicenseKey;
import com.becon.opencelium.backend.subscription.utility.LicenseKeyUtility;
import com.becon.opencelium.backend.utility.crypto.Base64Utility;
import com.becon.opencelium.backend.utility.crypto.HmacValidator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/subs"})
@Tag(name="Subscription")
public class SubscriptionController {
    private final ApiClient<ServicePortal> servicePortal;
    private final SubscriptionService subscriptionService;
    private final ActivationRequestService activationRequestService;
    private final ActivationRequestMapper activationRequestMapper;
    private final OperationUsageHistoryService operationUsageHistoryService;
    private final ExtraOpsService extraOpsService;

    public SubscriptionController(@Qualifier(value="subscriptionServiceImpl") SubscriptionService subscriptionService, @Qualifier(value="activationRequestServiceImp") ActivationRequestService activationRequestService, @Qualifier(value="operationUsageHistoryServiceImpl") OperationUsageHistoryService operationUsageHistoryService, @Qualifier(value="extraOpsServiceImp") ExtraOpsService extraOpsService, ActivationRequestMapper activationRequestMapper, ApiFactory apiFactory) {
        this.subscriptionService = subscriptionService;
        this.activationRequestService = activationRequestService;
        this.servicePortal = apiFactory.get(ApiType.SERVICE_PORTAL);
        this.activationRequestMapper = activationRequestMapper;
        this.operationUsageHistoryService = operationUsageHistoryService;
        this.extraOpsService = extraOpsService;
    }

    @GetMapping(path={"/all"})
    public ResponseEntity<String> getAllSubscriptions() {
        SubscriptionModule subsModule = ((ServicePortal)this.servicePortal.features()).subscription();
        return subsModule.getAllSubs();
    }

    @GetMapping(path={"/connection/check"})
    public ResponseEntity<?> checkConnection() {
        return this.servicePortal.checkConnection();
    }

    @GetMapping(path={"/{subId}"})
    public ResponseEntity<String> getSubById(@PathVariable String subId) {
        SubscriptionModule module = ((ServicePortal)this.servicePortal.features()).subscription();
        return module.getSubById(subId);
    }

    @PostMapping(path={"/{subId}"})
    public ResponseEntity<?> setSubscription(@PathVariable String subId) {
        ActivationRequest ar = this.activationRequestService.generateActivReq();
        String encodedAr = Base64Utility.encode((Object)ar);
        SubscriptionModule sModule = ((ServicePortal)this.servicePortal.features()).subscription();
        File arFile = this.activationRequestService.createFile(encodedAr, "activation-request");
        String response = (String)sModule.generateLicenseKey(arFile, subId).getBody();
        String licenseKey = this.extractLicenseKey(response);
        Subscription subscription = this.subscriptionService.setSubscription(licenseKey, ar);
        SubsDTO subsDTO = this.subscriptionService.toDto(LicenseKeyUtility.decrypt((String)licenseKey), subscription);
        return ResponseEntity.ok().body((Object)subsDTO);
    }

    @GetMapping(value={"/activation/request/generate"})
    public ResponseEntity<Resource> generateActivationRequest() {
        ActivationRequest ar = this.activationRequestService.generateActivReq();
        ActivationRequestDTO dto = this.activationRequestMapper.toDTO(ar);
        String encrypted = Base64Utility.encode((Object)dto);
        ByteArrayResource resource = new ByteArrayResource(encrypted.getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=activation-request.txt");
        headers.add("Content-Type", "text/plain");
        this.activationRequestService.save(ar);
        this.activationRequestService.activateTTL(ar);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).body((Object)resource);
    }

    @GetMapping(value={"/free/activate"})
    public ResponseEntity<Resource> activateFreeSub() {
        this.subscriptionService.createFreeLicenseFileIfNotExists();
        ActivationRequest ar = (ActivationRequest)this.activationRequestService.readFreeAR().orElseThrow(() -> new RuntimeException("Free Activation Request is not found or not valid"));
        String initLicense = LicenseKeyUtility.readFreeLicense();
        Subscription subscription = this.subscriptionService.convertToSub(initLicense, ar);
        if (!this.subscriptionService.exists(subscription.getSubId())) {
            this.activationRequestService.deactivateAll();
            ar.setActive(true);
            ar.setStatus(ActivReqStatus.PROCESSED);
            this.activationRequestService.save(ar);
            this.subscriptionService.save(subscription);
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/activate/license"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> activateLicense(@RequestParam(value="file") MultipartFile licenseKey) {
        String content;
        try {
            content = new String(licenseKey.getBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read license file");
        }
        LicenseKey lk = LicenseKeyUtility.decrypt((String)content);
        if (lk == null) {
            throw new RuntimeException("License is not valid");
        }
        String hmac = lk.getHmac();
        ActivationRequest ar = this.activationRequestService.findByHmac(hmac);
        if (!LicenseKeyUtility.verify((LicenseKey)lk, (HmacValidator)ar)) {
            throw new RuntimeException("License file is not valid");
        }
        this.activationRequestService.deactivateAll();
        ar.setStatus(ActivReqStatus.PROCESSED);
        ar.setActive(true);
        this.activationRequestService.save(ar);
        Subscription subscription = this.subscriptionService.convertToSub(content, ar);
        this.subscriptionService.save(subscription);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/active"})
    public ResponseEntity<SubsDTO> getActiveSubscription() {
        Subscription subscription = this.subscriptionService.getActiveSubs();
        if (subscription == null) {
            return ResponseEntity.noContent().build();
        }
        String licenseKeyRaw = subscription.getLicenseKey();
        LicenseKey licenseKey = LicenseKeyUtility.decrypt((String)licenseKeyRaw);
        SubsDTO subsDTO = this.subscriptionService.toDto(licenseKey, subscription);
        return ResponseEntity.ok().body((Object)subsDTO);
    }

    @GetMapping(value={"/valid/activation-request"})
    public ResponseEntity<ActivationRequestDTO> getActivationRequest() {
        ActivationRequest ar = this.activationRequestService.getActiveAR();
        if (ar == null) {
            return ResponseEntity.noContent().build();
        }
        ActivationRequestDTO dto = this.activationRequestMapper.toDTO(ar);
        return ResponseEntity.ok().body((Object)dto);
    }

    @GetMapping(value={"/operation/usage"})
    public ResponseEntity<PaginatedDto> getOperationUsage(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @RequestParam(defaultValue="id,asc") String[] sort, @RequestParam(required=false) Long startDate, @RequestParam(required=false) Long endDate) {
        Pageable pageable = this.operationUsageHistoryService.createPageable(page, size, sort);
        Page usageHistories = this.operationUsageHistoryService.findAllByDetailsStartDateBetween(pageable, startDate, endDate);
        PaginatedDto dto = this.operationUsageHistoryService.toPaginatedDto(usageHistories);
        return ResponseEntity.ok((Object)dto);
    }

    @GetMapping(value={"/operation/usage/{usageId}/details"})
    public ResponseEntity<PaginatedDto> getOperationUsageDetails(@RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size, @PathVariable Long usageId, @RequestParam(defaultValue="id,asc") String[] sort, @RequestParam(required=false) Long startDate, @RequestParam(required=false) Long endDate) {
        LocalDateTime start = startDate != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(startDate), ZoneId.of("UTC")) : null;
        LocalDateTime end = endDate != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(endDate), ZoneId.of("UTC")) : null;
        Pageable pageable = this.operationUsageHistoryService.createPageable(page, size, sort);
        Page usageDetails = this.operationUsageHistoryService.getAllUsageDetailsByUsageId(usageId, pageable, start, end);
        PaginatedDto dto = this.operationUsageHistoryService.toUsageDetailsDto(usageDetails);
        return ResponseEntity.ok((Object)dto);
    }

    @DeleteMapping(path={"/{subId}"})
    public ResponseEntity<String> deleteBySubId(@PathVariable String subId) {
        this.subscriptionService.deleteBySubId(subId);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(path={"/license/{licenseId}"})
    public ResponseEntity<String> deleteBylicenseId(@PathVariable String licenseId) {
        this.subscriptionService.deleteByLicenseId(licenseId);
        return ResponseEntity.noContent().build();
    }

    private String extractLicenseKey(String body) {
        JsonNode node;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            node = objectMapper.readTree(body);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Can't read License Key");
        }
        String licenseKeyRaw = node.get("activationResponse").asText(null);
        if (licenseKeyRaw == null) {
            throw new RuntimeException("License key is null");
        }
        return licenseKeyRaw;
    }
}

