/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.EventNotification;
import com.becon.opencelium.backend.database.mysql.entity.Scheduler;
import com.becon.opencelium.backend.database.mysql.service.SchedulerServiceImp;
import com.becon.opencelium.backend.database.mysql.service.WebhookServiceImp;
import com.becon.opencelium.backend.execution.socket.WebSocketNotificationService;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.notification.NotificationResource;
import com.becon.opencelium.backend.resource.request.SchedulerRequestResource;
import com.becon.opencelium.backend.resource.schedule.RunningJobsResource;
import com.becon.opencelium.backend.resource.schedule.SchedulerResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@Tag(name="Scheduler", description="Manages operations related to Scheduler management")
@RequestMapping(value={"/scheduler"}, produces={"application/json"})
public class SchedulerController {
    @Autowired
    private SchedulerServiceImp schedulerService;
    @Autowired
    private WebhookServiceImp webhookServiceImp;
    @Autowired
    private WebSocketNotificationService notificationService;

    @Operation(summary="Retrieves a list of schedulers from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SchedulerResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<List<SchedulerResource>> getAll() throws Exception {
        List schedulers = this.schedulerService.findAll();
        List scheduleList = schedulers.stream().map(s -> this.schedulerService.toResource(s)).collect(Collectors.toList());
        List allRunningJobs = this.schedulerService.getAllRunningJobs();
        this.notificationService.send("/scheduler/running/all", (Object)allRunningJobs);
        return ResponseEntity.ok(scheduleList);
    }

    @Operation(summary="Retrieves a list of schedulers by IDs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SchedulerResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all/by-ids"})
    public ResponseEntity<List<SchedulerResource>> getAllByIds(IdentifiersDTO<Integer> ids) {
        List schedulers = this.schedulerService.findAllById(ids.getIdentifiers());
        List scheduleList = schedulers.stream().map(s -> this.schedulerService.toResource(s)).collect(Collectors.toList());
        List allRunningJobs = this.schedulerService.getAllRunningJobs();
        this.notificationService.send("/scheduler/running/all", (Object)allRunningJobs);
        return ResponseEntity.ok(scheduleList);
    }

    @Operation(summary="Retrieves a scheduler from database by provided id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(schema=@Schema(implementation=SchedulerResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<?> get(@PathVariable int id) throws Exception {
        Scheduler scheduler = (Scheduler)this.schedulerService.findById(id).orElseThrow(() -> new RuntimeException("SCHEDULER_NOT_FOUND"));
        SchedulerResource schedulerResource = this.schedulerService.toResource(scheduler);
        EntityModel resource = EntityModel.of((Object)schedulerResource);
        return ResponseEntity.ok((Object)resource);
    }

    @Operation(summary="Creates a new scheduler in the system by accepting scheduler data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Scheduler is successfully created. The 'id' property will include newly created scheduler's 'id'", content={@Content(schema=@Schema(implementation=SchedulerResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> scheduleJob(@RequestBody SchedulerRequestResource resource) throws Exception {
        Scheduler scheduler = this.schedulerService.toEntity(resource);
        this.schedulerService.save(scheduler);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).path("/{id}").buildAndExpand(new Object[]{scheduler.getId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)this.schedulerService.toResource(scheduler));
    }

    @Operation(summary="Changes or Reschedules Scheduler")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Scheduler is successfully modified.", content={@Content(schema=@Schema(implementation=SchedulerResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    public ResponseEntity<?> reschedule(@PathVariable(value="id") int id, @RequestBody SchedulerRequestResource resource) {
        if (id != resource.getSchedulerId()) {
            throw new RuntimeException("SCHEDULER_NOT_FOUND");
        }
        Scheduler scheduler = this.schedulerService.toEntity(resource);
        Scheduler updated = this.schedulerService.update(scheduler);
        SchedulerResource schedulerResource = this.schedulerService.toResource(updated);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).path("/{id}").buildAndExpand(new Object[]{scheduler.getId()}).toUri();
        return ResponseEntity.created((URI)uri).body((Object)schedulerResource);
    }

    @Operation(summary="Changes only title of scheduler by provided scheduler id")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Scheduler title is successfully modified.", content={@Content(schema=@Schema(implementation=SchedulerResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}/title"}, consumes={"application/json"})
    public ResponseEntity<?> changeTitle(@PathVariable(value="id") int id, @RequestBody SchedulerRequestResource schedulerRequestResource) throws Exception {
        schedulerRequestResource.setSchedulerId(id);
        Scheduler scheduler = (Scheduler)this.schedulerService.findById(id).orElseThrow(() -> new RuntimeException("SCHEDULER_NOT_FOUND"));
        scheduler.setTitle(schedulerRequestResource.getTitle());
        this.schedulerService.saveEntity(scheduler);
        SchedulerResource schedulerResource = this.schedulerService.toResource(scheduler);
        EntityModel resource = EntityModel.of((Object)schedulerResource);
        return ResponseEntity.ok((Object)resource);
    }

    @Operation(summary="Delete a scheduler by provided id")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Scheduler is successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> deleteSchedule(@PathVariable int id) {
        this.schedulerService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Runs all schedulers provided in request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Schedulers have been successfully started", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/startAll"}, consumes={"application/json"})
    public ResponseEntity<?> startAll(@RequestBody IdentifiersDTO<Integer> ids) throws Exception {
        List schedulers = this.schedulerService.findAllById(ids.getIdentifiers());
        schedulers.parallelStream().forEach(scheduler -> {
            try {
                this.schedulerService.startNow(scheduler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Changes status(ON/OFF) of a scheduler by provided scheduler id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Scheduler status has been successfully changed", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{schedulerId}/status"}, consumes={"application/json"})
    public ResponseEntity<?> changeStatus(@PathVariable int schedulerId, @RequestBody Scheduler scheduler) throws Exception {
        boolean activate = scheduler.getStatus();
        scheduler = this.schedulerService.findById(schedulerId).orElse(null);
        if (scheduler == null) {
            throw new RuntimeException("SCHEDULER_NOT_FOUND");
        }
        scheduler.setStatus(activate);
        this.schedulerService.saveEntity(scheduler);
        if (activate) {
            this.schedulerService.enable(scheduler);
        } else {
            this.schedulerService.disable(scheduler);
        }
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Sets the status of the provided schedulers to (ON) in the list of schedulers.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Schedulers have been successfully enabled", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/enableAll"}, consumes={"application/json"})
    public ResponseEntity<?> enableAll(@RequestBody IdentifiersDTO<Integer> payload) throws Exception {
        ArrayList schedulerIds = payload.getIdentifiers();
        List schedulers = this.schedulerService.findAllById(schedulerIds);
        schedulers.forEach(scheduler -> {
            if (scheduler.getStatus()) {
                return;
            }
            try {
                if (scheduler.getStatus()) {
                    throw new RuntimeException("ALREADY_ENABLED");
                }
                this.schedulerService.enable(scheduler);
                scheduler.setStatus(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            scheduler.setStatus(true);
        });
        this.schedulerService.saveAll(schedulers);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Sets the status of the provided schedulers to (OFF) in the list of schedulers.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Schedulers have been successfully disabled", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/disableAll"})
    public ResponseEntity<?> disableAll(@RequestBody IdentifiersDTO<Integer> payload) throws Exception {
        ArrayList schedulerIds = payload.getIdentifiers();
        List schedulers = this.schedulerService.findAllById(schedulerIds);
        schedulers.forEach(scheduler -> {
            if (!scheduler.getStatus()) {
                return;
            }
            scheduler.setStatus(false);
            try {
                this.schedulerService.disable(scheduler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.schedulerService.saveAll(schedulers);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Deletes a collection of schedulers based on the provided list of their corresponding IDs.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Schedulers have been successfully deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/list/delete"}, consumes={"application/json"})
    public ResponseEntity<?> deleteSchedulerByIdIn(@RequestBody IdentifiersDTO<Integer> payload) throws Exception {
        this.schedulerService.deleteAllById((List)payload.getIdentifiers());
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Executes a scheduler by provided scheduler ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Scheduler has been started", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/execute/{schedulerId}"})
    public ResponseEntity<?> execute(@PathVariable int schedulerId) {
        try {
            Scheduler scheduler = this.schedulerService.findById(schedulerId).orElse(null);
            if (scheduler == null) {
                throw new RuntimeException("SCHEDULER_NOT_FOUND");
            }
            this.schedulerService.startNow(scheduler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Terminates a scheduler by provided scheduler ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Scheduler has been terminated", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/terminate/{schedulerId}"})
    public ResponseEntity<?> terminate(@PathVariable Integer schedulerId) {
        this.schedulerService.terminate(schedulerId);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Retrieves list of running schedulers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Scheduler has been started", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RunningJobsResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/running/all"})
    public ResponseEntity<List<RunningJobsResource>> getRunningAll() {
        List runningJobResources;
        try {
            runningJobResources = this.schedulerService.getAllRunningJobs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (runningJobResources == null) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)runningJobResources);
    }

    @Operation(summary="Retrieves a collection of schedulers based on the provided list of their corresponding IDs.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Schedulers have been retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SchedulerResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/list/get"}, consumes={"application/json"})
    public ResponseEntity<List<SchedulerResource>> getSchedulersByIds(@RequestBody IdentifiersDTO<Integer> payload) {
        ArrayList schedulerIds = payload.getIdentifiers();
        List schedulers = this.schedulerService.findAllById(schedulerIds);
        List scheduleList = schedulers.stream().map(sch -> this.schedulerService.toResource(sch)).collect(Collectors.toList());
        return ResponseEntity.ok(scheduleList);
    }

    @Operation(summary="Retrieves all notifications associated with a scheduler by provided scheduler ID.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notifications have been retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NotificationResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{schedulerId}/notification/all"})
    public ResponseEntity<List<NotificationResource>> getAllNotifications(@PathVariable int schedulerId) throws Exception {
        List notificationResource = this.schedulerService.getAllNotifications(schedulerId).stream().map(e -> this.schedulerService.toNotificationResource(e)).collect(Collectors.toList());
        return ResponseEntity.ok(notificationResource);
    }

    @Operation(summary="Retrieves a notification associated with a scheduler by provided scheduler ID and notification ID.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notification has been retrieved successfully", content={@Content(schema=@Schema(implementation=NotificationResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/notification/{notificationId}"})
    public ResponseEntity<?> getNotification(@PathVariable int notificationId) throws Exception {
        EventNotification en = (EventNotification)this.schedulerService.getNotification(notificationId).orElseThrow(() -> new RuntimeException("Notification not found"));
        NotificationResource notificationResource = this.schedulerService.toNotificationResource(en);
        EntityModel resource = EntityModel.of((Object)notificationResource);
        return ResponseEntity.ok((Object)resource);
    }

    @Operation(summary="Creates a notification for a scheduler by provided scheduler ID.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notification has been created successfully for scheduler", content={@Content(schema=@Schema(implementation=NotificationResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(value={"/{schedulerId}/notification"}, consumes={"application/json"})
    public ResponseEntity<?> createNotification(@PathVariable int schedulerId, @RequestBody NotificationResource notificationResource) throws Exception {
        notificationResource.setSchedulerId(schedulerId);
        EventNotification eventNotification = this.schedulerService.toNotificationEntity(notificationResource);
        this.schedulerService.saveNotification(eventNotification);
        return ResponseEntity.ok((Object)this.schedulerService.toNotificationResource(eventNotification));
    }

    @Operation(summary="Deletes a notification for a scheduler by provided scheduler ID and notification ID.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Notification has been deleted successfully from scheduler", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/notification/{notificationId}"}, consumes={"application/json"})
    public ResponseEntity<?> deleteNotification(@PathVariable int notificationId) {
        this.schedulerService.deleteNotificationById(notificationId);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes a list of notifications associated with a scheduler by provided scheduler ID and a list of notification IDs.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Notifications have been deleted successfully from scheduler", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/notification/delete"}, consumes={"application/json"})
    public ResponseEntity<?> deleteNotification(@RequestBody IdentifiersDTO<Integer> payload) {
        payload.getIdentifiers().forEach(nId -> this.schedulerService.deleteNotificationById(nId.intValue()));
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Modifies a notification associated with a scheduler by provided scheduler ID and notification ID.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Notification has been created successfully for scheduler", content={@Content(schema=@Schema(implementation=NotificationResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/notification/{notificationId}"}, consumes={"application/json"})
    public ResponseEntity<?> updateNotification(@PathVariable int notificationId, @RequestBody NotificationResource notificationResource) throws Exception {
        notificationResource.setNotificationId(notificationId);
        EventNotification eventNotification = this.schedulerService.toNotificationEntity(notificationResource);
        this.schedulerService.saveNotification(eventNotification);
        return ResponseEntity.ok((Object)this.schedulerService.toNotificationResource(eventNotification));
    }
}

