/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.ExtraOps;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.service.ExtraOpsService;
import com.becon.opencelium.backend.database.mysql.service.SubscriptionService;
import com.becon.opencelium.backend.subscription.dto.EncryptedExtraOpsFile;
import com.becon.opencelium.backend.subscription.utility.LicenseKeyUtility;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/extra-ops"})
@Tag(name="Extra Operations", description="Extra Operations are temporary allowances that extend a user\u2019s monthly quota, consumed in FIFO order, and expiring at the end of the month without rollover. ")
public class ExtraOpsController {
    private final SubscriptionService subscriptionService;
    private final ExtraOpsService extraOpsService;
    private final Logger logger = LoggerFactory.getLogger(ExtraOpsController.class);

    public ExtraOpsController(@Qualifier(value="subscriptionServiceImpl") SubscriptionService subscriptionService, @Qualifier(value="extraOpsServiceImp") ExtraOpsService extraOpsService) {
        this.subscriptionService = subscriptionService;
        this.extraOpsService = extraOpsService;
    }

    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<?> uploadExtraOps(@RequestParam(value="file") MultipartFile extraOpsFile) {
        String content;
        try {
            content = new String(extraOpsFile.getBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read Extra Ops file");
        }
        EncryptedExtraOpsFile encryptedExtraOpsFile = this.extraOpsService.decrypt(content);
        if (encryptedExtraOpsFile == null) {
            throw new RuntimeException("Extra Ops is not valid");
        }
        if (this.extraOpsService.existsByGeneratedAt(encryptedExtraOpsFile.getGeneratedAt())) {
            this.logger.error("ExtraOps record already exists in the system for license id: {}", (Object)encryptedExtraOpsFile.getLicenseId());
            throw new RuntimeException("EXTRA_OPS_ALREADY_EXISTS");
        }
        Subscription sub = this.subscriptionService.findByLicenseId(encryptedExtraOpsFile.getLicenseId());
        ExtraOps extraOps = this.extraOpsService.toEntityFromEncryption(encryptedExtraOpsFile, LicenseKeyUtility.decrypt((String)sub.getLicenseKey()));
        extraOps.setSubscription(sub);
        this.extraOpsService.save(extraOps);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable(value="id") Long id) {
        this.extraOpsService.delete(id);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/delete/list"})
    public ResponseEntity<?> deleteList(@RequestBody List<Long> ids) {
        this.extraOpsService.deleteList(ids);
        return ResponseEntity.noContent().build();
    }
}

