/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.EditorSettings;
import com.becon.opencelium.backend.database.mysql.service.EditorSettingsService;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.EditorSettingsDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/editor/settings"})
@Tag(name="Category", description="Manages operations related to Editor Settings management")
public class EditorSettingsController {
    private final EditorSettingsService editorSettingsService;
    private final Mapper<EditorSettings, EditorSettingsDTO> mapper;

    public EditorSettingsController(@Qualifier(value="editorSettingsServiceImp") EditorSettingsService editorSettingsService, Mapper<EditorSettings, EditorSettingsDTO> mapper) {
        this.editorSettingsService = editorSettingsService;
        this.mapper = mapper;
    }

    @Operation(summary="Creates or Updates an editor settings")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Editor Settings has been successfully created(updated)", content={@Content(schema=@Schema(implementation=EditorSettingsDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping
    public ResponseEntity<EditorSettingsDTO> save(@RequestBody EditorSettingsDTO settingsDto) {
        EditorSettings saved = this.editorSettingsService.save(settingsDto);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).buildAndExpand(new Object[0]).toUri();
        return ResponseEntity.created((URI)uri).body((Object)((EditorSettingsDTO)this.mapper.toDTO((Object)saved)));
    }

    @Operation(summary="Retrieves editor settings from database by provided user ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Editor Settings has been successfully retrieved", content={@Content(schema=@Schema(implementation=EditorSettingsDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/user/{userId}"})
    public ResponseEntity<EditorSettingsDTO> getSettings(@PathVariable(value="userId") Integer userId) {
        EditorSettings settings = this.editorSettingsService.getByUserId(userId);
        return ResponseEntity.ok((Object)((EditorSettingsDTO)this.mapper.toDTO((Object)settings)));
    }
}

