/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.configuration.cutomizer.RestCustomizer;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.FieldBindingMng;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngService;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.MaskingRule;
import com.becon.opencelium.backend.database.mysql.entity.Scheduler;
import com.becon.opencelium.backend.database.mysql.service.ConnectionService;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.database.mysql.service.SchedulerService;
import com.becon.opencelium.backend.exception.ConcurrentTestIsForbidden;
import com.becon.opencelium.backend.exception.ConnectorNotFoundException;
import com.becon.opencelium.backend.execution.socket.Connection2WebSocketChannelMapping;
import com.becon.opencelium.backend.mapper.base.Mapper;
import com.becon.opencelium.backend.resource.ApiDataResource;
import com.becon.opencelium.backend.resource.IdentifiersDTO;
import com.becon.opencelium.backend.resource.PatchConnectionDetails;
import com.becon.opencelium.backend.resource.application.ResultDTO;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.connection.ConnectionResource;
import com.becon.opencelium.backend.resource.connection.MethodDTO;
import com.becon.opencelium.backend.resource.connection.OperatorDTO;
import com.becon.opencelium.backend.resource.connection.binding.FieldBindingDTO;
import com.becon.opencelium.backend.resource.connection.masking.RuleDTO;
import com.becon.opencelium.backend.resource.connection.old.ConnectionOldDTO;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.request.SchedulerRequestResource;
import com.becon.opencelium.backend.resource.schedule.SchedulerResource;
import com.becon.opencelium.backend.utility.patch.PatchHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minidev.json.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/connection"}, produces={"application/json"})
@Tag(name="Connection", description="Manages operations related to Connection management")
public class ConnectionController {
    private final Environment environment;
    private final ConnectionService connectionService;
    private final ConnectorService connectorService;
    private final ConnectionMngService connectionMngService;
    private final SchedulerService schedulerService;
    private final Connection2WebSocketChannelMapping connection2ChannelMapping;
    private final Mapper<ConnectionMng, ConnectionDTO> connectionMngMapper;
    private final Mapper<Connection, ConnectionDTO> connectionMapper;
    private final Mapper<Connection, ConnectionResource> connectionResourceMapper;
    private final Mapper<ConnectionDTO, ConnectionOldDTO> connectionOldDTOMapper;
    private final PatchHelper patchHelper;

    public ConnectionController(Environment environment, SchedulerService schedulerService, ConnectorService connectorService, Connection2WebSocketChannelMapping connection2ChannelMapping, Mapper<ConnectionMng, ConnectionDTO> connectionMngMapper, Mapper<Connection, ConnectionDTO> connectionMapper, Mapper<Connection, ConnectionResource> connectionResourceMapper, Mapper<ConnectionDTO, ConnectionOldDTO> connectionOldDTOMapper, @Qualifier(value="connectionServiceImp") ConnectionService connectionService, @Qualifier(value="connectionMngServiceImp") ConnectionMngService connectionMngService, PatchHelper patchHelper) {
        this.environment = environment;
        this.schedulerService = schedulerService;
        this.connection2ChannelMapping = connection2ChannelMapping;
        this.connectionService = connectionService;
        this.connectorService = connectorService;
        this.connectionMngMapper = connectionMngMapper;
        this.connectionMapper = connectionMapper;
        this.connectionMngService = connectionMngService;
        this.connectionResourceMapper = connectionResourceMapper;
        this.connectionOldDTOMapper = connectionOldDTOMapper;
        this.patchHelper = patchHelper;
    }

    @Operation(summary="Retrieves all connections from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connections have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectionOldDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/all"})
    public ResponseEntity<?> getAll() {
        List all = this.connectionService.getAllFullConnection();
        return ResponseEntity.ok((Object)this.connectionOldDTOMapper.toDTOAll(all));
    }

    @Operation(summary="Retrieves all connections from database by invokerName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connections have been successfully retrieved by invokerName", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectionOldDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/dependency/{invokerName}"})
    public ResponseEntity<?> getByInvokerName(@PathVariable String invokerName) {
        List<Integer> connectorIds = this.connectorService.findAllByInvoker(invokerName).stream().map(Connector::getId).toList();
        ArrayList<ConnectionDTO> connections = new ArrayList<ConnectionDTO>();
        HashSet<Long> connectionIds = new HashSet<Long>();
        for (Integer connectorId : connectorIds) {
            List connectionsByConnectorId = this.connectionService.findAllByConnectorId(connectorId.intValue());
            for (Connection connection : connectionsByConnectorId) {
                if (!connectionIds.add(connection.getId())) continue;
                connections.add(this.connectionService.getFullConnection(connection.getId()));
            }
        }
        List<ConnectionOldDTO> result = connections.stream().map(arg_0 -> ((Mapper)this.connectionOldDTOMapper).toDTO(arg_0)).toList();
        return ResponseEntity.ok(result);
    }

    @Operation(summary="Retrieves all Metadata of connections from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Metadata of connections have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectionResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/all/meta"})
    public ResponseEntity<?> getAllMeta() {
        List connections = this.connectionService.findAll();
        List connectionResources = this.connectionResourceMapper.toDTOAll(connections);
        connectionResources.forEach(c -> {
            c.getFromConnector().setRequestData(null);
            c.getFromConnector().getInvoker().setOperations(null);
            c.getFromConnector().getInvoker().setRequiredData(null);
            c.getToConnector().setRequestData(null);
            c.getToConnector().getInvoker().setOperations(null);
            c.getToConnector().getInvoker().setRequiredData(null);
        });
        return ResponseEntity.ok((Object)connectionResources);
    }

    @Operation(summary="Retrieves all connections by IDs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connections have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectionResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/all/by-ids"})
    public ResponseEntity<?> getAllMeta(@RequestBody IdentifiersDTO<Long> ids) {
        List connections = this.connectionService.findAllByIds(ids);
        List connectionResources = this.connectionResourceMapper.toDTOAll(connections);
        connectionResources.forEach(c -> {
            c.getFromConnector().setRequestData(null);
            c.getFromConnector().getInvoker().setOperations(null);
            c.getFromConnector().getInvoker().setRequiredData(null);
            c.getToConnector().setRequestData(null);
            c.getToConnector().getInvoker().setOperations(null);
            c.getToConnector().getInvoker().setRequiredData(null);
        });
        return ResponseEntity.ok((Object)connectionResources);
    }

    @Operation(summary="Retrieves a connection from database by provided connection ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully retrieved", content={@Content(schema=@Schema(implementation=ConnectionOldDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/{connectionId}"})
    public ResponseEntity<?> get(@PathVariable Long connectionId) {
        ConnectionDTO connectionDTO = this.connectionService.getFullConnection(connectionId);
        return ResponseEntity.ok((Object)((ConnectionOldDTO)this.connectionOldDTOMapper.toDTO((Object)connectionDTO)));
    }

    @Operation(summary="Creates a connection from database by accepting connection data in request body.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully created", content={@Content(schema=@Schema(implementation=ConnectionOldDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> save(@RequestBody ConnectionOldDTO connectionOldDTO) throws Exception {
        ConnectionDTO connectionDTO = (ConnectionDTO)this.connectionOldDTOMapper.toEntity((Object)connectionOldDTO);
        Connection connection = (Connection)this.connectionMapper.toEntity((Object)connectionDTO);
        ConnectionMng connectionMng = (ConnectionMng)this.connectionMngMapper.toEntity((Object)connectionDTO);
        ConnectionMng savedConnection = this.connectionService.save(connection, connectionMng);
        ConnectionDTO dto = this.connectionService.getFullConnection(savedConnection.getConnectionId());
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).buildAndExpand(new Object[0]).toUri();
        return ResponseEntity.created((URI)uri).body((Object)((ConnectionOldDTO)this.connectionOldDTOMapper.toDTO((Object)dto)));
    }

    @Operation(summary="Modifies a connection by provided connection ID and accepting connection data in request body.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully modified", content={@Content(schema=@Schema(implementation=ConnectionOldDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/{connectionId}"}, consumes={"application/json"})
    public ResponseEntity<?> update(@PathVariable Long connectionId, @RequestBody ConnectionOldDTO connectionOldDTO) throws Exception {
        ConnectionDTO connectionDTO = (ConnectionDTO)this.connectionOldDTOMapper.toEntity((Object)connectionOldDTO);
        Connection connection = (Connection)this.connectionMapper.toEntity((Object)connectionDTO);
        ConnectionMng connectionMng = (ConnectionMng)this.connectionMngMapper.toEntity((Object)connectionDTO);
        connection.setId(connectionId);
        this.connectionService.update(connection, connectionMng);
        return ResponseEntity.ok((Object)((ConnectionOldDTO)this.connectionOldDTOMapper.toDTO((Object)this.connectionService.getFullConnection(connectionId))));
    }

    @Operation(summary="Tests connection execution by temporarily creating new connection and scheduler.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection execution has been successfully tested", content={@Content(schema=@Schema(implementation=ConnectionOldDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/execution/test"}, consumes={"application/json"})
    public ResponseEntity<?> test(@RequestBody ConnectionOldDTO connectionOldDTO, @RequestParam String channelId) throws Exception {
        this.schedulerService.getAllRunningJobs().forEach(job -> {
            String schedulerTitle = job.getTitle();
            if (schedulerTitle.startsWith("!*test_schedule_") && schedulerTitle.endsWith(connectionOldDTO.getTitle())) {
                throw new ConcurrentTestIsForbidden(Long.valueOf(0L));
            }
        });
        String postfix = System.currentTimeMillis() + "_" + connectionOldDTO.getTitle();
        connectionOldDTO.setTitle("!*test_connection_" + postfix);
        ConnectionDTO connectionDTO = (ConnectionDTO)this.connectionOldDTOMapper.toEntity((Object)connectionOldDTO);
        Connection connection = (Connection)this.connectionMapper.toEntity((Object)connectionDTO);
        ConnectionMng connectionMng = (ConnectionMng)this.connectionMngMapper.toEntity((Object)connectionDTO);
        ConnectionMng savedConnection = this.connectionService.save(connection, connectionMng);
        Long connectionId = savedConnection.getConnectionId();
        SchedulerRequestResource resource = new SchedulerRequestResource();
        resource.setConnectionId(connectionId);
        resource.setTitle("!*test_schedule_" + postfix);
        resource.setStatus(true);
        resource.setCronExp("59 59 23 31 12 ? 2123");
        resource.setDebugMode(true);
        Scheduler scheduler = this.schedulerService.toEntity(resource);
        this.schedulerService.save(scheduler);
        this.connection2ChannelMapping.add(connectionId, channelId);
        this.schedulerService.startNow(scheduler, channelId);
        SchedulerResource schedulerResource = new SchedulerResource();
        schedulerResource.setSchedulerId(scheduler.getId());
        return ResponseEntity.ok((Object)schedulerResource);
    }

    @Operation(summary="Deletes a connection by provided connection ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Connection has been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(path={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable(value="id") Long id) {
        this.connectionService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Creates an empty connection and returns it's id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully created", content={@Content(schema=@Schema(implementation=ConnectionDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/id"})
    public ResponseEntity<?> getNewConnectionId() {
        Long id = this.connectionService.createEmptyConnection();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", (Object)id);
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).buildAndExpand(new Object[0]).toUri();
        return ResponseEntity.created((URI)uri).body((Object)jsonObject);
    }

    @Operation(summary="Updates connection with a patch request")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully updated"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PatchMapping(path={"/{connectionId}"}, consumes={"application/json-patch+json"})
    public ResponseEntity<?> patchUpdate(@PathVariable Long connectionId, @RequestBody JsonPatch patch) {
        PatchConnectionDetails details = this.patchHelper.describe(patch);
        this.connectionService.patchUpdate(connectionId, patch, details);
        ConnectionDTO connectionDTO = this.connectionService.getFullConnection(connectionId);
        JSONObject jsonObject = new JSONObject();
        for (PatchConnectionDetails.PatchOperationDetail opDetail : details.getOpDetails()) {
            if (opDetail.isMethodAdded()) {
                List methods = opDetail.isFrom() ? connectionDTO.getFromConnector().getMethods() : connectionDTO.getToConnector().getMethods();
                String id = ((MethodDTO)methods.get(this.patchHelper.getIndexOfList(opDetail.getIndexOfMethod().intValue(), methods.size()))).getId();
                jsonObject.put((Object)"id", (Object)id);
                return ResponseEntity.ok((Object)jsonObject);
            }
            if (opDetail.isOperatorAdded()) {
                List operators = opDetail.isFrom() ? connectionDTO.getFromConnector().getOperators() : connectionDTO.getToConnector().getOperators();
                String id = ((OperatorDTO)operators.get(this.patchHelper.getIndexOfList(opDetail.getIndexOfOperator().intValue(), operators.size()))).getId();
                jsonObject.put((Object)"id", (Object)id);
                return ResponseEntity.ok((Object)jsonObject);
            }
            if (!opDetail.isEnhancementAdded()) continue;
            List fieldBindings = connectionDTO.getFieldBinding();
            String id = ((FieldBindingDTO)fieldBindings.get(this.patchHelper.getIndexOfList(opDetail.getIndexOfEnhancement().intValue(), fieldBindings.size()))).getId();
            jsonObject.put((Object)"id", (Object)id);
            return ResponseEntity.ok((Object)jsonObject);
        }
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Add|delete|updates a method and|or an operator of connection with a patch request and returns current its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Method and|or Operator has been successfully updated"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PatchMapping(path={"/{connectionId}/connector/{connectorId}"}, consumes={"application/json-patch+json"})
    public ResponseEntity<?> patchMethodOrOperator(@PathVariable Long connectionId, @PathVariable Integer connectorId, @RequestBody JsonPatch patch) {
        if (connectorId == null || connectorId == 0) {
            throw new ConnectorNotFoundException(0);
        }
        Connection connection = this.connectionService.getById(connectionId);
        JsonPatch changed = connection.getFromConnector() == connectorId.intValue() ? this.patchHelper.changeEachPath(patch, p -> "/fromConnector" + p) : this.patchHelper.changeEachPath(patch, p -> "/toConnector" + p);
        return this.patchUpdate(connectionId, changed);
    }

    @Operation(summary="Updates a fieldBinding of connection with a patch request")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="FieldBinding has been successfully updated"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PatchMapping(path={"/{connectionId}/fieldBinding/{id}"}, consumes={"application/json-patch+json"})
    public ResponseEntity<?> patchEnhancement(@PathVariable Long connectionId, @PathVariable String id, @RequestBody JsonPatch patch) {
        if (id == null) {
            throw new RuntimeException("ENHANCEMENT_NOT_FOUND");
        }
        ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(connectionId);
        if (connectionMng.getFieldBindings() == null) {
            throw new RuntimeException("ENHANCEMENT_NOT_FOUND");
        }
        int index = -1;
        for (int i = 0; i < connectionMng.getFieldBindings().size(); ++i) {
            if (!((FieldBindingMng)connectionMng.getFieldBindings().get(i)).getId().equals(id)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new RuntimeException("ENHANCEMENT_NOT_FOUND");
        }
        String pre = "/fieldBinding/" + index;
        JsonPatch changed = this.patchHelper.changeEachPath(patch, p -> pre + p);
        return this.patchUpdate(connectionId, changed);
    }

    @Operation(summary="Undoes the last update and returns undid connection")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully undid", content={@Content(schema=@Schema(implementation=ConnectionDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/{connectionId}/undo"})
    public ResponseEntity<?> undo(@PathVariable Long connectionId) {
        this.connectionService.undo(connectionId);
        ConnectionDTO connectionDTO = this.connectionService.getFullConnection(connectionId);
        return ResponseEntity.ok((Object)connectionDTO);
    }

    @Operation(summary="Validates a connection for correctly constructed structure")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection has been successfully validated"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/validate"}, consumes={"application/json"})
    public ResponseEntity<?> validate(@RequestBody ConnectionDTO connectionDTO) throws Exception {
        return ResponseEntity.badRequest().build();
    }

    @Operation(summary="Validates name of connection for uniqueness")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connection Name has been successfully validate. Return EXISTS or NOT_EXISTS values in 'message' property.", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/check/{name}"})
    public ResponseEntity<?> existsByName(@PathVariable(value="name") String name) throws IOException {
        RuntimeException ex = this.connectionService.existsByName(name) ? new RuntimeException("EXISTS") : new RuntimeException("NOT_EXISTS");
        String uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri().toString();
        ErrorResource errorResource = new ErrorResource((Exception)ex, HttpStatus.OK, uri);
        return ResponseEntity.ok().body((Object)errorResource);
    }

    @Operation(summary="Sends request to remote api by accepting api data in request body.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns json string. Structure of json could be different depending on api.", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/remoteapi"}, consumes={"application/json"})
    public ResponseEntity<?> sendRequestToApi(@RequestBody ApiDataResource apiDataResource) {
        HttpHeaders headers = new HttpHeaders();
        if (apiDataResource.getHeader() != null) {
            headers.setAll(apiDataResource.getHeader());
        }
        HttpEntity requestEntity = new HttpEntity((Object)apiDataResource.getBody(), (MultiValueMap)headers);
        String proxyHost = this.environment.getProperty("opencelium.rest_template.proxy.host", "");
        String proxyPort = this.environment.getProperty("opencelium.rest_template.proxy.port", "");
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[]{new RestCustomizer(proxyHost, proxyPort, apiDataResource.isSslOn())});
        RestTemplate restTemplate = restTemplateBuilder.build();
        ResponseEntity responseEntity = restTemplate.exchange(apiDataResource.getUrl(), HttpMethod.valueOf((String)apiDataResource.getMethod()), requestEntity, String.class, new Object[0]);
        return ResponseEntity.status((HttpStatusCode)responseEntity.getStatusCode()).body((Object)((String)responseEntity.getBody()));
    }

    @Operation(summary="Deletes a list of connections based on the provided list of their corresponding IDs")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="List of connections have been deleted from database", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/list/delete"})
    public ResponseEntity<?> deleteCtionByIdIn(@RequestBody IdentifiersDTO<Long> ids) {
        ids.getIdentifiers().forEach(arg_0 -> ((ConnectionService)this.connectionService).deleteById(arg_0));
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Removes webhook")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Webhook has been successfully deleted", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{connectionId}/webhook/vars"})
    public ResponseEntity<?> getVariablesFromConnection(@PathVariable long connectionId) {
        ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(Long.valueOf(connectionId));
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String json = objectMapper.writeValueAsString((Object)connectionMng);
            List webhookParams = this.connectionService.extractVarsFromJson(json);
            return ResponseEntity.ok((Object)webhookParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Operation(summary="Retrieves all masking rules of connection from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All rules of a connection have been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectionOldDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/{connectionId}/rule/all"})
    public ResponseEntity<List<RuleDTO>> getAllRules(@PathVariable long connectionId) {
        List rules = this.connectionService.getAllRules(connectionId).stream().map(RuleDTO::fromEntity).collect(Collectors.toList());
        return ResponseEntity.ok(rules);
    }

    @Operation(summary="Retrieves specified masking rule of connection from database")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Specified rule of a connection has been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectionResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/{connectionId}/rule/{ruleId}"})
    public ResponseEntity<RuleDTO> getOneRule(@PathVariable long connectionId, @PathVariable long ruleId) {
        return ResponseEntity.ok((Object)this.connectionService.getOneRule(connectionId, ruleId));
    }

    @Operation(summary="Creates set of masking rules for a connection")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Masking rules for a connection have been created successfully", content={@Content(schema=@Schema(implementation=ConnectionOldDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/{connectionId}/rule/list"}, consumes={"application/json"})
    public ResponseEntity<List<RuleDTO>> saveRuleList(@PathVariable long connectionId, @RequestBody List<RuleDTO> dtos) {
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).buildAndExpand(new Object[0]).toUri();
        return ResponseEntity.created((URI)uri).body((Object)this.connectionService.saveRuleList(connectionId, dtos));
    }

    @Operation(summary="Creates a masking rule for a connection")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Masking rule for a connection has been created successfully", content={@Content(schema=@Schema(implementation=ConnectionOldDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/{connectionId}/rule"}, consumes={"application/json"})
    public ResponseEntity<RuleDTO> saveRule(@PathVariable long connectionId, @RequestBody RuleDTO dto) {
        URI uri = MvcUriComponentsBuilder.fromController(this.getClass()).buildAndExpand(new Object[0]).toUri();
        return ResponseEntity.created((URI)uri).body((Object)this.connectionService.saveRule(connectionId, dto));
    }

    @Operation(summary="Updates masking rule for a connection")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Masking rule for a connection has been updated successfully", content={@Content(schema=@Schema(implementation=ConnectionOldDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(path={"/{connectionId}/rule/{ruleId}"}, consumes={"application/json"})
    public ResponseEntity<?> updateRule(@PathVariable long connectionId, @PathVariable long ruleId, @RequestBody RuleDTO dto) {
        return ResponseEntity.ok((Object)this.connectionService.updateRule(connectionId, ruleId, dto));
    }

    @Operation(summary="Deletes masking rules of a connection by provided connection ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Masking rules of a connection have been deleted successfully.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(path={"/{connectionId}/rule/all"})
    public ResponseEntity<?> deleteRuleList(@PathVariable long connectionId) {
        this.connectionService.deleteRuleList(connectionId);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Deletes a masking rule of a connection by provided connection ID and rule ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Masking rule of a connection has been deleted successfully.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(path={"/{connectionId}/rule/{ruleId}"})
    public ResponseEntity<?> deleteRule(@PathVariable long connectionId, @PathVariable long ruleId) {
        this.connectionService.deleteRule(connectionId, ruleId);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Create support file with given masking for connection execution")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Process started successfully.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping(path={"/execute/{connectionId}/support-file"})
    public ResponseEntity<?> executeWithSupportFile(@PathVariable long connectionId, @RequestBody List<RuleDTO> ruleDTOs) {
        this.schedulerService.throwIfConnectionIsBeingExecuted(connectionId);
        SchedulerRequestResource resource = new SchedulerRequestResource();
        resource.setConnectionId(Long.valueOf(connectionId));
        resource.setTitle(connectionId + "_" + UUID.randomUUID());
        resource.setStatus(true);
        resource.setCronExp("59 59 23 31 12 ? 2123");
        resource.setDebugMode(true);
        Scheduler scheduler = this.schedulerService.toEntity(resource);
        this.schedulerService.save(scheduler);
        List<MaskingRule> rules = ruleDTOs.stream().map(dto -> {
            MaskingRule rule = new MaskingRule();
            rule.setType(dto.getType());
            rule.setExpression(dto.getExpression());
            return rule;
        }).toList();
        this.schedulerService.startNow(scheduler, rules);
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Retrieves list of log names for connection")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Log names for a connection has been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectionResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(path={"/{connectionId}/log-files"})
    public ResponseEntity<ResultDTO<List<String>>> getLogFileNameList(@PathVariable long connectionId) {
        ResultDTO logFileNames = new ResultDTO((Object)this.connectionService.getLogFileNameListById(connectionId));
        return ResponseEntity.ok((Object)logFileNames);
    }
}

