/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.controller;

import com.becon.opencelium.backend.database.mysql.entity.DataAggregator;
import com.becon.opencelium.backend.database.mysql.service.ArgumentService;
import com.becon.opencelium.backend.database.mysql.service.DataAggregatorService;
import com.becon.opencelium.backend.resource.application.ResultDTO;
import com.becon.opencelium.backend.resource.connection.aggregator.DataAggregatorDTO;
import com.becon.opencelium.backend.resource.connector.ConnectorResource;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/aggregator"}, produces={"application/json"})
@Tag(name="Aggregator", description="Manages operation for collecting data from responses of executed methods")
public class AggregatorController {
    private final DataAggregatorService dataAggregatorService;
    private final ArgumentService argumentService;

    @Autowired
    public AggregatorController(@Qualifier(value="dataAggregatorServiceImp") DataAggregatorService dataAggregatorService, @Qualifier(value="ArgumentServiceImp") ArgumentService argumentService) {
        this.dataAggregatorService = dataAggregatorService;
        this.argumentService = argumentService;
    }

    @Operation(summary="Retrieves a Data Aggregator by provided ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data Aggregator has been successfully retrieved", content={@Content(schema=@Schema(implementation=DataAggregatorDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<DataAggregatorDTO> get(@PathVariable Integer id) {
        DataAggregator dataAggregator = this.dataAggregatorService.getById(id);
        DataAggregatorDTO dataAggregatorDTO = this.dataAggregatorService.convertToDto(dataAggregator);
        return ResponseEntity.ok((Object)dataAggregatorDTO);
    }

    @Operation(summary="Retrieves all Data Aggregator and related arguments")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data Aggregator has been successfully retrieved", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConnectorResource.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/all"})
    public ResponseEntity<List<DataAggregatorDTO>> getAll() {
        List daList = this.dataAggregatorService.findAll();
        List<DataAggregatorDTO> collection = daList.stream().map(arg_0 -> ((DataAggregatorService)this.dataAggregatorService).convertToDto(arg_0)).toList();
        return ResponseEntity.ok(collection);
    }

    @Operation(summary="Creates new Data Aggregator in the system by accepting data in the request body")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data Aggregator has been successfully retrieved", content={@Content(schema=@Schema(implementation=DataAggregatorDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PostMapping
    public ResponseEntity<DataAggregatorDTO> save(@RequestBody DataAggregatorDTO dataAggregatorDTO) {
        DataAggregator dataAggregator = this.dataAggregatorService.convertToEntity(dataAggregatorDTO);
        this.dataAggregatorService.save(dataAggregator);
        dataAggregator = this.dataAggregatorService.getById(Integer.valueOf(dataAggregator.getId()));
        DataAggregatorDTO response = this.dataAggregatorService.convertToDto(dataAggregator);
        return ResponseEntity.ok((Object)response);
    }

    @Operation(summary="Modifies Data Aggregator in the system by accepting data in the request body with ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data Aggregator has been successfully updated", content={@Content(schema=@Schema(implementation=DataAggregatorDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping
    public ResponseEntity<DataAggregatorDTO> update(@RequestBody DataAggregatorDTO dataAggregatorDTO) {
        DataAggregator dataAggregator = this.dataAggregatorService.getById(Integer.valueOf(dataAggregatorDTO.getId()));
        dataAggregator.setActive(dataAggregatorDTO.isActive());
        this.dataAggregatorService.save(dataAggregator);
        DataAggregatorDTO response = this.dataAggregatorService.convertToDto(dataAggregator);
        return ResponseEntity.ok((Object)response);
    }

    @Operation(summary="Deletes a data aggregator by provided aggregator ID")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Data Aggregator has been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable Integer id) {
        this.dataAggregatorService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Checks whether a name of aggregator is unique or not.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns true if a name of aggregator is unique.", content={@Content(schema=@Schema(implementation=ResultDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @GetMapping(value={"/unique/{name}"})
    public ResponseEntity<?> isNameUnique(@PathVariable String name) {
        Boolean isUnique = this.dataAggregatorService.existsByName(name) == false;
        ResultDTO resultDTO = new ResultDTO((Object)isUnique);
        return ResponseEntity.ok((Object)resultDTO);
    }

    @Operation(summary="Checks whether an aggregator is active or not.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns true if a name of aggregator is unique.", content={@Content(schema=@Schema(implementation=ResultDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @PutMapping(value={"/{id}/status"})
    public ResponseEntity<?> put(@PathVariable Integer id, @RequestBody DataAggregatorDTO dataAggregatorDTO) {
        DataAggregator dataAggregator = this.dataAggregatorService.getById(id);
        dataAggregator.setActive(dataAggregatorDTO.isActive());
        this.dataAggregatorService.save(dataAggregator);
        ResultDTO resultDTO = new ResultDTO((Object)"success");
        return ResponseEntity.ok((Object)resultDTO);
    }

    @Operation(summary="Deletes an argument by provided argument ID and breaks relation with execution")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Argument has been successfully deleted.", content={@Content}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorResource.class))}), @ApiResponse(responseCode="500", description="Internal Error", content={@Content(schema=@Schema(implementation=ErrorResource.class))})})
    @DeleteMapping(value={"/argument/{argId}"})
    public ResponseEntity<?> deleteArgument(@PathVariable Integer argId) {
        this.argumentService.deleteById(argId);
        return ResponseEntity.noContent().build();
    }
}

