/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.configuration.cutomizer;

import java.security.SecureRandom;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestCustomizer
implements RestTemplateCustomizer {
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPass;
    private boolean sslCert = false;
    private int timeout = 0;

    public RestCustomizer() {
    }

    public RestCustomizer(String host, String port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public RestCustomizer(String host, String port, boolean sslCert) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.sslCert = sslCert;
    }

    public RestCustomizer(String host, String port, String proxyUser, String proxyPass, boolean sslCert, int timeout) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.sslCert = sslCert;
        this.timeout = timeout;
        this.proxyUser = proxyUser;
        this.proxyPass = proxyPass;
    }

    public void customize(RestTemplate restTemplate) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        if (this.sslCert) {
            requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.getDisabledHttpsClient());
        }
        requestFactory.setConnectionRequestTimeout(5000);
        this.timeout = this.timeout > 0 ? this.timeout : 5000;
        requestFactory.setConnectTimeout(this.timeout);
        if (!(this.proxyHost == null || this.proxyPort == null || this.proxyHost.isEmpty() || this.proxyPort.isEmpty() || this.sslCert)) {
            requestFactory = new HttpComponentsClientHttpRequestFactory(this.getHttpClientWithProxy());
        }
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Collections.singletonList(MediaType.ALL));
        restTemplate.getMessageConverters().add(converter);
    }

    private HttpClient getHttpClientWithProxy() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.proxyPass != null && !this.proxyPass.isEmpty() && this.proxyUser != null && !this.proxyUser.isEmpty()) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.proxyHost, Integer.parseInt(this.proxyPort)), (Credentials)new UsernamePasswordCredentials(this.proxyUser, this.proxyPass.toCharArray()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        HttpHost proxy = new HttpHost(this.proxyHost, Integer.parseInt(this.proxyPort));
        return httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy)).build();
    }

    private CloseableHttpClient getDisabledHttpsClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLConnectionSocketFactory ssl = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)ssl).build();
            if (this.proxyHost != null && this.proxyPort != null && !this.proxyHost.isEmpty() && !this.proxyPort.isEmpty()) {
                HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
                HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
                if (this.proxyPass != null && !this.proxyPass.isEmpty() && this.proxyUser != null && !this.proxyUser.isEmpty()) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(this.proxyHost, Integer.parseInt(this.proxyPort)), (Credentials)new UsernamePasswordCredentials("bocffjov", "tgjzz8pvelfc".toCharArray()));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
                return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy)).build();
            }
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

