/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.configuration;

import com.becon.opencelium.backend.execution.socket.WebSocketEventHandler;
import com.becon.opencelium.backend.execution.socket.WebSocketHandshakeHandler;
import com.becon.opencelium.backend.execution.socket.WebSocketHandshakeInterceptor;
import com.becon.opencelium.backend.security.JwtTokenUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    private final WebSocketEventHandler eventHandler;
    private final JwtTokenUtil jwtTokenUtil;
    @Value(value="${websocket.endpoint}")
    private String websocketEndpoint;

    public WebSocketConfig(WebSocketEventHandler eventHandler, JwtTokenUtil jwtTokenUtil) {
        this.eventHandler = eventHandler;
        this.jwtTokenUtil = jwtTokenUtil;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.enableSimpleBroker(new String[]{"/execution", "/subscription", "/scheduler/running/all", "/session"});
        registry.setApplicationDestinationPrefixes(new String[]{"/oc"});
        registry.setUserDestinationPrefix("/user");
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.websocketEndpoint}).setAllowedOriginPatterns(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)new WebSocketHandshakeHandler()).addInterceptors(new HandshakeInterceptor[]{new WebSocketHandshakeInterceptor(this.jwtTokenUtil)}).withSockJS();
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registry) {
        super.configureWebSocketTransport(registry);
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new /* Unavailable Anonymous Inner Class!! */});
    }
}

