/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.configuration;

import com.becon.opencelium.backend.configuration.LdapProperties;
import com.becon.opencelium.backend.database.mysql.service.LdapVerificationService;
import com.becon.opencelium.backend.security.AuthExceptionHandler;
import com.becon.opencelium.backend.security.AuthenticationFilter;
import com.becon.opencelium.backend.security.AuthorizationFilter;
import com.becon.opencelium.backend.security.DaoUserDetailsService;
import com.becon.opencelium.backend.security.TotpAuthenticationFilter;
import jakarta.servlet.Filter;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration {
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Lazy
    @Autowired
    private AuthenticationFilter authenticationFilter;
    @Lazy
    @Autowired
    private AuthorizationFilter authorizationFilter;
    @Lazy
    @Autowired
    private TotpAuthenticationFilter totpAuthenticationFilter;
    @Autowired
    private AuthExceptionHandler authExceptionHandler;
    @Autowired
    private DaoUserDetailsService daoUserDetailsService;
    @Autowired
    private LdapProperties ldapProperties;
    @Autowired
    private LdapVerificationService ldapVerificationService;

    @Bean
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).addFilter((Filter)this.authenticationFilter).addFilterBefore((Filter)this.totpAuthenticationFilter, UsernamePasswordAuthenticationFilter.class).addFilterAfter((Filter)this.authorizationFilter, UsernamePasswordAuthenticationFilter.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authExceptionHandler).and()).build();
    }

    @Bean
    public AuthenticationManager authenticationManager(HttpSecurity http) throws Exception {
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)this.ldapAuthenticationProvider()).authenticationProvider((AuthenticationProvider)this.daoAuthenticationProvider());
        return (AuthenticationManager)authenticationManagerBuilder.build();
    }

    @Bean
    public DaoAuthenticationProvider daoAuthenticationProvider() {
        DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
        authenticationProvider.setPasswordEncoder((PasswordEncoder)this.bCryptPasswordEncoder);
        authenticationProvider.setUserDetailsService((UserDetailsService)this.daoUserDetailsService);
        return authenticationProvider;
    }

    @Bean
    public LdapAuthenticationProvider ldapAuthenticationProvider() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public LdapAuthenticator ldapAuthenticator() {
        String userSearchBase = this.ldapProperties.getUserSearchBase();
        String searchFilter = this.ldapProperties.getUserSearchFilter();
        BindAuthenticator authenticator = new BindAuthenticator((BaseLdapPathContextSource)this.ldapContextSource());
        authenticator.setUserSearch((LdapUserSearch)new FilterBasedLdapUserSearch(userSearchBase, searchFilter, (BaseLdapPathContextSource)this.ldapContextSource()));
        return authenticator;
    }

    @Bean
    public LdapAuthoritiesPopulator ldapAuthoritiesPopulator() {
        String groupSearchBase = this.ldapProperties.getGroupSearchBase();
        String searchFilter = this.ldapProperties.getGroupSearchFilter();
        DefaultLdapAuthoritiesPopulator authoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)this.ldapContextSource(), groupSearchBase);
        authoritiesPopulator.setGroupSearchFilter(searchFilter);
        authoritiesPopulator.setSearchSubtree(true);
        authoritiesPopulator.setAuthorityMapper(arg_0 -> this.ldapAuthorityMapper(arg_0));
        return authoritiesPopulator;
    }

    @Bean
    public LdapContextSource ldapContextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapProperties.getUrls());
        contextSource.setUserDn(this.ldapProperties.getUsername());
        contextSource.setPassword(this.ldapProperties.getPassword());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("com.sun.jndi.ldap.connect.timeout", this.ldapProperties.getTimeout());
        env.put("com.sun.jndi.ldap.read.timeout", this.ldapProperties.getTimeout());
        contextSource.setBaseEnvironmentProperties(env);
        return contextSource;
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addExposedHeader("GroupPermissionOperations, Authorization");
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setAllowedOriginPatterns(Collections.singletonList("*"));
        corsConfiguration.applyPermitDefaultValues();
        source.registerCorsConfiguration("/**", corsConfiguration);
        return source;
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        String[] enpoints = new String[]{"/storage/files/**", "/webhook/execute/**", "/webhook/health", "/v3/api-docs", "/swagger-ui.html", "/swagger-ui/**", "/v3/api-docs/**", "/docs", "/assistant/oc/test"};
        return web -> web.ignoring().requestMatchers(enpoints);
    }

    private GrantedAuthority ldapAuthorityMapper(Map<String, List<String>> userGroups) {
        List<String> groups = userGroups.get("spring.security.ldap.dn");
        return new SimpleGrantedAuthority(groups.get(0));
    }
}

