/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.configuration;

import com.becon.opencelium.backend.api.TemplateSyncService;
import com.becon.opencelium.backend.database.mysql.service.InvokerSyncService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
public class OnlineServicesSchedulerConfiguration
implements SchedulingConfigurer {
    @Value(value="${opencelium.online-services.active:false}")
    private boolean active;
    @Value(value="${opencelium.online-services.invoker-sync.active:false}")
    private boolean invokerSyncActive;
    @Value(value="${opencelium.online-services.invoker-sync.time:-}")
    private String invokerSyncTime;
    @Value(value="${opencelium.online-services.template-sync.active:false}")
    private boolean templateSyncActive;
    @Value(value="${opencelium.online-services.template-sync.time:-}")
    private String templateSyncTime;
    private final InvokerSyncService invokerSyncService;
    private final TemplateSyncService templateSyncService;

    public OnlineServicesSchedulerConfiguration(InvokerSyncService invokerSyncService, TemplateSyncService templateSyncService) {
        this.invokerSyncService = invokerSyncService;
        this.templateSyncService = templateSyncService;
    }

    public void configureTasks(ScheduledTaskRegistrar registrar) {
        if (this.active) {
            this.scheduleIfEnabled(registrar, this.invokerSyncActive, this.invokerSyncTime, () -> ((InvokerSyncService)this.invokerSyncService).syncInvokers());
            this.scheduleIfEnabled(registrar, this.templateSyncActive, this.templateSyncTime, () -> ((TemplateSyncService)this.templateSyncService).syncTemplates());
        }
    }

    private void scheduleIfEnabled(ScheduledTaskRegistrar registrar, boolean enabled, String cron, Runnable task) {
        if (enabled && cron != null && !"-".equals(cron)) {
            registrar.addCronTask(task, cron);
        }
    }
}

