/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.aspect;

import com.becon.opencelium.backend.constant.LogConstant;
import com.becon.opencelium.backend.database.mysql.entity.Argument;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.DataAggregator;
import com.becon.opencelium.backend.database.mysql.entity.EventContent;
import com.becon.opencelium.backend.database.mysql.entity.EventNotification;
import com.becon.opencelium.backend.database.mysql.entity.EventRecipient;
import com.becon.opencelium.backend.database.mysql.entity.Execution;
import com.becon.opencelium.backend.database.mysql.entity.ExecutionArgument;
import com.becon.opencelium.backend.database.mysql.entity.LastExecution;
import com.becon.opencelium.backend.database.mysql.entity.Scheduler;
import com.becon.opencelium.backend.database.mysql.entity.Subscription;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.service.ConnectionServiceImp;
import com.becon.opencelium.backend.database.mysql.service.DataAggregatorService;
import com.becon.opencelium.backend.database.mysql.service.ExecutionService;
import com.becon.opencelium.backend.database.mysql.service.LastExecutionService;
import com.becon.opencelium.backend.database.mysql.service.SchedulerService;
import com.becon.opencelium.backend.database.mysql.service.SubscriptionService;
import com.becon.opencelium.backend.database.mysql.service.UserService;
import com.becon.opencelium.backend.enums.LangEnum;
import com.becon.opencelium.backend.execution.JSHttpObject;
import com.becon.opencelium.backend.execution.logger.service.LogDataService;
import com.becon.opencelium.backend.execution.notification.EmailServiceImpl;
import com.becon.opencelium.backend.execution.notification.IncomingWebhookService;
import com.becon.opencelium.backend.execution.oc721.Operation;
import com.becon.opencelium.backend.execution.socket.Connection2WebSocketChannelMapping;
import com.becon.opencelium.backend.execution.socket.WebSocketNotificationService;
import com.becon.opencelium.backend.execution.supportfile.SupportFileService;
import com.becon.opencelium.backend.quartz.JobExecutor;
import com.becon.opencelium.backend.quartz.QuartzJobScheduler;
import com.becon.opencelium.backend.utility.LogFileUtility;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.openjdk.nashorn.api.scripting.JSObject;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExecutionAspect {
    private static final Logger logger = LoggerFactory.getLogger(JobExecutor.class);
    private final SchedulerService schedulerService;
    private final UserService userService;
    private final IncomingWebhookService incomingWebhookService;
    private final ExecutionService executionService;
    private final EmailServiceImpl emailService;
    private final Environment env;
    private final LastExecutionService lastExecutionService;
    private final DataAggregatorService dataAggregatorService;
    private final SupportFileService supportFileService;
    private final Connection2WebSocketChannelMapping connection2ChannelMapping;
    private final SubscriptionService subscriptionService;
    private final WebSocketNotificationService notificationService;
    private final LogDataService logDataService;
    @Autowired
    private ConnectionServiceImp connectionServiceImp;

    public ExecutionAspect(@Qualifier(value="schedulerServiceImp") SchedulerService schedulerService, @Qualifier(value="userServiceImpl") UserService userService, @Qualifier(value="executionServiceImp") ExecutionService executionService, @Qualifier(value="lastExecutionServiceImp") LastExecutionService lastExecutionService, @Qualifier(value="subscriptionServiceImpl") SubscriptionService subscriptionService, @Qualifier(value="dataAggregatorServiceImp") DataAggregatorService dataAggregatorService, @Qualifier(value="logDataServiceImp") LogDataService logDataService, IncomingWebhookService incomingWebhookService, EmailServiceImpl emailService, Environment env, SupportFileService supportFileService, Connection2WebSocketChannelMapping connection2ChannelMapping, WebSocketNotificationService notificationService) {
        this.schedulerService = schedulerService;
        this.userService = userService;
        this.incomingWebhookService = incomingWebhookService;
        this.executionService = executionService;
        this.emailService = emailService;
        this.env = env;
        this.lastExecutionService = lastExecutionService;
        this.dataAggregatorService = dataAggregatorService;
        this.supportFileService = supportFileService;
        this.subscriptionService = subscriptionService;
        this.connection2ChannelMapping = connection2ChannelMapping;
        this.notificationService = notificationService;
        this.logDataService = logDataService;
    }

    @Before(value="execution(* com.becon.opencelium.backend.quartz.JobExecutor.executeInternal(..)) && args(context)")
    public void sendBefore(JobExecutionContext context) {
        Subscription activSub = this.subscriptionService.getActiveSubs();
        if (!this.subscriptionService.isValid(activSub)) {
            logger.warn("Subscription is not valid");
            return;
        }
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        QuartzJobScheduler.ScheduleData data = (QuartzJobScheduler.ScheduleData)jobDataMap.get((Object)"data");
        int schedulerId = data != null ? data.getScheduleId() : jobDataMap.getIntValue("schedulerId");
        long execId = this.initExecutionObj(schedulerId);
        jobDataMap.put("execId", execId);
        Scheduler scheduler = this.schedulerService.getById(schedulerId);
        jobDataMap.put("connectionId", (Object)scheduler.getConnection().getId());
        jobDataMap.put("debugMode", scheduler.getDebugMode());
        List eventNotifications = this.schedulerService.getAllNotifications(schedulerId);
        this.triggerNotifications(eventNotifications, "pre", null);
        this.sendRunningJobsNotification();
        String timestamp = LocalDateTime.now().format(LogConstant.DATE_TIME_FORMATTER);
        jobDataMap.put("timestamp", timestamp);
    }

    @AfterReturning(value="execution(* com.becon.opencelium.backend.quartz.JobExecutor.executeInternal(..)) && args(context)")
    public void sendAfter(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        boolean licenseIsValid = jobDataMap.getBoolean("licenseIsValid");
        if (!licenseIsValid) {
            return;
        }
        long execId = jobDataMap.getLong("execId");
        long connectionId = jobDataMap.getLong("connectionId");
        boolean debugMode = jobDataMap.getBoolean("debugMode");
        String timestamp = jobDataMap.getString("timestamp");
        QuartzJobScheduler.ScheduleData data = (QuartzJobScheduler.ScheduleData)jobDataMap.get((Object)"data");
        int schedulerId = data.getScheduleId();
        this.updateExecutionObj(execId, true, debugMode);
        List operations = (List)context.get((Object)"operationsEx");
        this.executeAggregator(operations, execId);
        if (data.getExecType() == QuartzJobScheduler.TriggerType.EXECUTION_TEST) {
            this.schedulerService.deleteById(schedulerId);
            this.connectionServiceImp.deleteById(Long.valueOf(connectionId));
            this.connection2ChannelMapping.remove(Long.valueOf(connectionId));
            this.move(Long.valueOf(connectionId), execId, timestamp, "s", debugMode);
        } else if (data.getExecType() == QuartzJobScheduler.TriggerType.SUPPORT_FILE) {
            this.supportFileService.collectFiles(Long.valueOf(connectionId), execId, timestamp, "s");
            this.schedulerService.deleteById(schedulerId);
        } else {
            this.move(Long.valueOf(connectionId), execId, timestamp, "s", debugMode);
        }
        List en = this.schedulerService.getAllNotifications(schedulerId);
        this.triggerNotifications(en, "post", null);
        this.sendRunningJobsNotification(schedulerId);
    }

    @AfterThrowing(pointcut="execution(* com.becon.opencelium.backend.quartz.JobExecutor.executeInternal(..)) && args(context)", throwing="ex")
    public void sendAlert(JobExecutionContext context, Exception ex) {
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        boolean licenseIsValid = jobDataMap.getBoolean("licenseIsValid");
        if (!licenseIsValid) {
            return;
        }
        long execId = jobDataMap.getLong("execId");
        long connectionId = jobDataMap.getLong("connectionId");
        boolean debugMode = jobDataMap.getBoolean("debugMode");
        String timestamp = jobDataMap.getString("timestamp");
        QuartzJobScheduler.ScheduleData data = (QuartzJobScheduler.ScheduleData)jobDataMap.get((Object)"data");
        int schedulerId = data.getScheduleId();
        this.updateExecutionObj(execId, false, debugMode);
        List operations = (List)context.get((Object)"operationsEx");
        this.executeAggregator(operations, execId);
        if (data.getExecType() == QuartzJobScheduler.TriggerType.EXECUTION_TEST) {
            this.schedulerService.deleteById(schedulerId);
            this.connectionServiceImp.deleteById(Long.valueOf(connectionId));
            this.connection2ChannelMapping.remove(Long.valueOf(connectionId));
            this.move(Long.valueOf(connectionId), execId, timestamp, "f", debugMode);
        } else if (data.getExecType() == QuartzJobScheduler.TriggerType.SUPPORT_FILE) {
            this.supportFileService.collectFiles(Long.valueOf(connectionId), execId, timestamp, "f");
            this.schedulerService.deleteById(schedulerId);
        } else {
            this.move(Long.valueOf(connectionId), execId, timestamp, "f", debugMode);
        }
        List en = this.schedulerService.getAllNotifications(schedulerId);
        this.triggerNotifications(en, "alert", ex);
        this.sendRunningJobsNotification(schedulerId);
    }

    private long initExecutionObj(int schedulerId) {
        Execution execution = new Execution();
        Scheduler scheduler = new Scheduler();
        scheduler.setId(schedulerId);
        execution.setScheduler(scheduler);
        execution.setStartTime(new Date());
        return this.executionService.save(execution).getId();
    }

    private void updateExecutionObj(long execId, boolean success, boolean hasLog) {
        Execution execution = this.executionService.getById(execId);
        execution.setEndTime(new Date());
        execution.setStatus(success ? "S" : "F");
        this.executionService.save(execution);
        hasLog = LogFileUtility.logFileExistForExecId((Long)execId) && this.logDataService.findRootByExecutionId(Long.valueOf(execId)).isPresent();
        LastExecution le = this.lastExecutionService.existsBySchedulerId(execution.getScheduler().getId()) ? this.lastExecutionService.findBySchedulerId(execution.getScheduler().getId()) : new LastExecution();
        if (success) {
            le.setSuccessDuration(execution.getEndTime().getTime() - execution.getStartTime().getTime());
            le.setSuccessStartTime(execution.getStartTime());
            le.setSuccessEndTime(execution.getEndTime());
            le.setSuccessHasLog(hasLog);
            le.setSuccessExecutionId(execution.getId());
        } else {
            le.setFailDuration(execution.getEndTime().getTime() - execution.getStartTime().getTime());
            le.setFailStartTime(execution.getStartTime());
            le.setFailEndTime(execution.getEndTime());
            le.setFailHasLog(hasLog);
            le.setFailExecutionId(execution.getId());
        }
        if (le.getScheduler() == null) {
            le.setScheduler(execution.getScheduler());
        }
        this.lastExecutionService.save(le);
    }

    private void triggerNotifications(List<EventNotification> eventNotifications, String eventType, Exception ex) {
        for (EventNotification en : eventNotifications) {
            if (!en.getEventType().equals(eventType)) continue;
            if (en.getEventRecipients().isEmpty()) {
                this.fillDefaultRecipients(en.getEventRecipients(), en.getEventMessage().getType());
            }
            for (EventRecipient er : en.getEventRecipients()) {
                User user = this.userService.findByEmail(er.getDestination()).orElse(null);
                String lang = user == null ? "en" : user.getUserDetail().getLang();
                EventContent content = en.getEventMessage().getEventContents().stream().filter(c -> c.getLanguage().equalsIgnoreCase(lang)).findFirst().orElse(null);
                if (content == null) {
                    String defaultLang = LangEnum.EN.getCode();
                    content = en.getEventMessage().getEventContents().stream().filter(c -> c.getLanguage().equals(defaultLang)).findFirst().orElseThrow(() -> new RuntimeException("Default language(" + defaultLang + ") of content not found"));
                }
                String message = this.replaceConstants(content.getBody(), user, ex, en);
                String subject = this.replaceConstants(content.getSubject(), user, ex, en);
                String to = er.getDestination();
                String type = en.getEventMessage().getType();
                try {
                    switch (type) {
                        case "incoming_webhook": {
                            this.incomingWebhookService.sendMessage(to, subject, message);
                            break;
                        }
                        case "email": {
                            this.emailService.sendMessage(to, subject, message);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void fillDefaultRecipients(Set<EventRecipient> recipients, String type) {
        switch (type) {
            case "email": {
                String destination = SecurityContextHolder.getContext().getAuthentication().getName();
                recipients.add(new EventRecipient(destination));
                break;
            }
            case "incoming_webhook": {
                String[] webhooks = (String[])this.env.getProperty("opencelium.notification.tools.incoming-webhook.url", String[].class);
                if (webhooks == null) {
                    return;
                }
                for (String url : webhooks) {
                    recipients.add(new EventRecipient(url));
                }
                break;
            }
            default: {
                throw new RuntimeException("Couldn't find tool type: " + type + ". Check application.yaml file;");
            }
        }
    }

    private String replaceArgs(String text, EventNotification en) {
        String result = text;
        List<Long> indexes = this.getConstants(text, "\\{\\{([^{}]+)\\}\\}").stream().map(Long::getLong).toList();
        Map argsValues = this.getArgsValues(indexes, en);
        for (Map.Entry entry : argsValues.entrySet()) {
            String arg = (String)entry.getKey();
            String value = (String)entry.getValue();
            String s = "{{" + arg + "}}";
            result = result.replace(s, value);
        }
        return result;
    }

    private String replaceConstants(String text, User user, Exception ex, EventNotification en) {
        String result = text;
        List constants = this.getConstants(text, "\\{([^{}]+)\\}(?![}])");
        Map cValues = this.getConstantValues(constants, user, ex, en);
        if (cValues != null) {
            for (Map.Entry entry : cValues.entrySet()) {
                String constant = (String)entry.getKey();
                String value = (String)entry.getValue();
                String s = "{" + constant + "}";
                result = result.replace(s, value);
            }
        }
        List args = this.getConstants(text, "\\{\\{([^{}]+)\\}\\}");
        List<Long> indexes = args.stream().filter(str -> str.matches("-?\\d+(\\.\\d+)?")).map(Long::parseLong).toList();
        Map argsValues = this.getArgsValues(indexes, en);
        String et = en.getEventType();
        if (argsValues != null && (et.equalsIgnoreCase("post") || et.equalsIgnoreCase("alert"))) {
            for (Map.Entry entry : argsValues.entrySet()) {
                String arg = (String)entry.getKey();
                String value = (String)entry.getValue();
                String s = "{{" + arg + "}}";
                result = result.replace(s, value);
            }
        }
        return result;
    }

    private Map<String, String> getArgsValues(List<Long> indexes, EventNotification en) {
        LastExecution le = ((Scheduler)this.schedulerService.findById(en.getScheduler().getId()).get()).getLastExecution();
        long exId = Math.max(le.getFailExecutionId(), le.getSuccessExecutionId());
        Execution execution = this.executionService.findById(exId).orElse(null);
        Objects.requireNonNull(execution);
        Map<String, String> resultMap = execution.getExecutionArguments().stream().filter(ea -> indexes.contains(ea.getArgument().getId())).collect(Collectors.toMap(ea -> Long.toString(ea.getArgument().getId()), ExecutionArgument::getValue));
        indexes.stream().filter(id -> !resultMap.containsKey(Long.toString(id))).forEach(id -> resultMap.put(Long.toString(id), "n/a"));
        return resultMap;
    }

    private List<String> getConstants(String text, String regex) {
        ArrayList<String> constants = new ArrayList<String>();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            constants.add(m.group(1));
        }
        return constants;
    }

    private Map<String, String> getConstantValues(List<String> constants, User user, Exception ex, EventNotification en) {
        if (constants == null || constants.isEmpty()) {
            return null;
        }
        Scheduler scheduler = (Scheduler)this.schedulerService.findById(en.getScheduler().getId()).orElseThrow(() -> new RuntimeException("SCHEDULER_NOT_FOUND"));
        Connection connection = this.connectionServiceImp.getById(scheduler.getConnection().getId());
        HashMap<String, String> cValues = new HashMap<String, String>();
        constants.forEach(c -> {
            switch (c) {
                case "USER_NAME": {
                    String userName = user.getUserDetail().getName();
                    cValues.put((String)c, userName);
                    break;
                }
                case "USER_SURNAME": {
                    String surName = user.getUserDetail().getSurname();
                    cValues.put((String)c, surName);
                    break;
                }
                case "USER_TITLE": {
                    String userTitle = user.getUserDetail().getTitle();
                    cValues.put((String)c, userTitle);
                    break;
                }
                case "USER_DEPARTMENT": {
                    String department = user.getUserDetail().getDepartment();
                    cValues.put((String)c, department);
                    break;
                }
                case "CONNECTION_ID": {
                    cValues.put((String)c, Long.toString(connection.getId()));
                    break;
                }
                case "CONNECTION_NAME": {
                    cValues.put((String)c, connection.getTitle());
                    break;
                }
                case "SCHEDULER_ID": {
                    cValues.put((String)c, Integer.toString(scheduler.getId()));
                    break;
                }
                case "SCHEDULER_TITLE": {
                    cValues.put((String)c, scheduler.getTitle());
                    break;
                }
            }
        });
        return cValues;
    }

    private void executeAggregator(List<Operation> operations, long execId) {
        Execution execution = this.executionService.getById(execId);
        if (operations == null) {
            return;
        }
        operations.stream().filter(op -> op.getAggregatorId() != null && op.getAggregatorId() != 0).forEach(op -> {
            DataAggregator da = this.dataAggregatorService.getById(op.getAggregatorId());
            if (!da.isActive()) {
                return;
            }
            List<JSHttpObject> responseObjects = op.getResponses().values().stream().map(JSHttpObject::new).toList();
            List<JSHttpObject> requestObjects = op.getRequests().values().stream().map(JSHttpObject::new).toList();
            List exarg = this.getExecutionArgs(da.getScript(), responseObjects, requestObjects, da.getArgs(), execution);
            execution.setExecutionArguments(exarg);
            if (execution.getExecutionArguments() != null && !execution.getExecutionArguments().isEmpty()) {
                this.executionService.save(execution);
            }
        });
    }

    private List<ExecutionArgument> getExecutionArgs(String script, List<JSHttpObject> responses, List<JSHttpObject> requests, Set<Argument> args, Execution execution) {
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
            String stringifiedResponses = new ObjectMapper().writeValueAsString(responses);
            engine.put("dataModel", stringifiedResponses);
            JSObject objRes = (JSObject)engine.eval("JSON.parse(dataModel)");
            engine.put("Responses", objRes);
            String stringifiedRequests = new ObjectMapper().writeValueAsString(responses);
            engine.put("dataModel", stringifiedRequests);
            JSObject objReq = (JSObject)engine.eval("JSON.parse(dataModel)");
            engine.put("Requests", objReq);
            engine.eval(script);
            ArrayList<ExecutionArgument> executionArguments = new ArrayList<ExecutionArgument>();
            args.forEach(arg -> {
                Object value = engine.get(arg.getName());
                if (value == null) {
                    return;
                }
                ExecutionArgument executionArgument = new ExecutionArgument();
                executionArgument.setExecution(execution);
                executionArgument.setArgument(arg);
                executionArgument.setValue(value.toString());
                executionArguments.add(executionArgument);
            });
            return executionArguments;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void sendRunningJobsNotification() {
        try {
            List allRunningJobs = this.schedulerService.getAllRunningJobs();
            this.notificationService.send("/scheduler/running/all", (Object)allRunningJobs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendRunningJobsNotification(int schedulerId) {
        List allRunningJobs = this.schedulerService.getAllRunningJobsExcludingOne(schedulerId);
        this.notificationService.send("/scheduler/running/all", (Object)allRunningJobs);
    }

    private void move(Long connectionId, long execId, String timestamp, String type, boolean debugMode) {
        if (debugMode) {
            int fileLimit = "s".equals(type) ? ((Integer)this.env.getProperty("opencelium.log.retention.per-connection.success", Integer.class, (Object)2)).intValue() : ((Integer)this.env.getProperty("opencelium.log.retention.per-connection.fail", Integer.class, (Object)3)).intValue();
            LogFileUtility.move((Long)connectionId, (long)execId, (String)timestamp, (String)type, (int)fileLimit);
        }
    }
}

