/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.application.assistant;

import com.becon.opencelium.backend.application.assistant.AssistantServiceImp;
import com.becon.opencelium.backend.application.assistant.UpdatePackageService;
import com.becon.opencelium.backend.application.entity.AvailableUpdate;
import com.becon.opencelium.backend.database.mysql.service.UserServiceImpl;
import com.becon.opencelium.backend.resource.application.AvailableUpdateResource;
import com.becon.opencelium.backend.utility.PackageVersionManager;
import com.becon.opencelium.backend.utility.ZipUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UpdatePackageServiceImp
implements UpdatePackageService {
    @Autowired
    private ObjectMapper jsonOm;
    @Autowired
    private Environment env;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AssistantServiceImp assistantServiceImp;
    @Autowired
    private UserServiceImpl userService;
    private Logger logger = LoggerFactory.getLogger(UpdatePackageServiceImp.class);
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public List<AvailableUpdate> getOffVersions() {
        String[] directories = this.getDirectories();
        if (directories == null) {
            return null;
        }
        return this.getAllAvailableUpdates(directories);
    }

    public List<AvailableUpdate> getOnVersions() {
        if (!this.userService.getCurrentUser().getUserDetail().isThemeSync()) {
            return Collections.emptyList();
        }
        try {
            return this.getVersions();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
            return Collections.emptyList();
        }
    }

    public AvailableUpdate getAvailableUpdate(String version) {
        String status = this.getVersionStatus(version);
        AvailableUpdate availableUpdate = new AvailableUpdate();
        availableUpdate.setStatus(status);
        availableUpdate.setChangelogLink(this.getChangelogLink(version));
        availableUpdate.setVersion(version);
        availableUpdate.setInstruction(this.extractInstruction(version));
        return availableUpdate;
    }

    public String[] getDirectories() {
        File file = new File("assistant/versions/");
        return file.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void downloadPackage(String version) throws Exception {
        String name = version.charAt(0) == 'v' ? version.substring(1) : version;
        String url = "https://packagecloud.io/becon/opencelium/packages/anyfile/oc_" + name + ".zip/download?distro_version_id=230";
        InputStream inputStream = this.downloadFile(url);
        Path target = Paths.get("assistant/versions/" + version, new String[0]);
        ZipUtils.saveZip((InputStream)inputStream, (String)name, (Path)target);
    }

    public AvailableUpdateResource toResource(AvailableUpdate offVersions) {
        AvailableUpdateResource availableUpdateResource = new AvailableUpdateResource();
        availableUpdateResource.setStatus(offVersions.getStatus());
        availableUpdateResource.setName(offVersions.getVersion());
        availableUpdateResource.setChangelogLink(offVersions.getChangelogLink());
        availableUpdateResource.setInstruction(offVersions.getInstruction());
        return availableUpdateResource;
    }

    private InputStream downloadFile(String url) throws IOException, ParseException {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.getForEntity(URI.create(url), byte[].class);
        if (response.getStatusCode().is2xxSuccessful()) {
            byte[] responseBody = (byte[])response.getBody();
            if (responseBody != null) {
                return new ByteArrayInputStream(responseBody);
            }
            throw new IOException("Received empty response body");
        }
        throw new IOException("Failed to download file: " + response.getStatusCode());
    }

    private List<AvailableUpdate> getAllAvailableUpdates(String[] appDirectories) {
        LinkedList<AvailableUpdate> packages = new LinkedList<AvailableUpdate>();
        for (String appDir : appDirectories) {
            String version = appDir.replace("_", ".");
            AvailableUpdate availableUpdate = this.getAvailableUpdate(version);
            packages.add(availableUpdate);
        }
        return packages;
    }

    private String getChangelogLink(String ocPackage) {
        URI uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri();
        return "./assistant/changelog/file/" + ocPackage;
    }

    private String getVersionStatus(String version) {
        String currentVersion = this.assistantServiceImp.getCurrentVersion();
        if (PackageVersionManager.compareVersions((String)version, (String)currentVersion) < 0) {
            return "old";
        }
        if (PackageVersionManager.compareVersions((String)version, (String)currentVersion) == 0) {
            return "current";
        }
        return "available";
    }

    private List<AvailableUpdate> getVersions() throws Exception {
        String packageCloudUrl = "https://packagecloud.io/becon/opencelium";
        String htmlResponse = (String)this.restTemplate.getForObject(packageCloudUrl, String.class, new Object[0]);
        String currentVersion = this.env.getProperty("opencelium.version");
        HashSet<String> packVersion = new HashSet<String>();
        Document doc = Jsoup.parse((String)htmlResponse);
        Elements titles = doc.select("a[title*=.zip]");
        Pattern pattern = Pattern.compile("^oc_\\d+(\\.\\d+)*\\.zip$");
        for (Element title : titles) {
            String version = title.attr("title");
            if (!pattern.matcher(version).matches()) continue;
            packVersion.add(version);
        }
        return PackageVersionManager.getPackageVersions(packVersion, (String)currentVersion);
    }

    private String generateSignature(String key, String httpMethod, String url, String currentDate) {
        byte[] hmacSha256 = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            mac.init(secretKeySpec);
            String message = httpMethod.toUpperCase() + url + currentDate;
            mac.update(message.getBytes());
            hmacSha256 = mac.doFinal();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate hmac-sha256", e);
        }
        return UpdatePackageServiceImp.bytesToHex((byte[])hmacSha256);
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    private String extractInstruction(String version) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File findFirstZipFileFromVersionFolder(String directoryPath) throws IOException {
        File dir = new File(directoryPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Provided path is not a directory.");
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".zip"));
        if (files == null || files.length == 0) {
            throw new IOException("No zip files found in the directory.");
        }
        return files[0];
    }
}

