/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.application.assistant;

import com.becon.opencelium.backend.application.assistant.ApplicationService;
import com.becon.opencelium.backend.application.entity.SystemOverview;
import com.becon.opencelium.backend.application.repository.SystemOverviewRepository;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectorMng;
import com.becon.opencelium.backend.database.mongodb.entity.MethodMng;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngServiceImp;
import com.becon.opencelium.backend.database.mongodb.service.FieldBindingMngServiceImp;
import com.becon.opencelium.backend.database.mysql.entity.Connection;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.service.ConnectionServiceImp;
import com.becon.opencelium.backend.database.mysql.service.ConnectorServiceImp;
import com.becon.opencelium.backend.exception.StorageException;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.service.InvokerServiceImp;
import com.becon.opencelium.backend.resource.application.SystemOverviewResource;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.resource.updateassistant.InstallationDTO;
import com.becon.opencelium.backend.resource.updateassistant.Neo4jConfigResource;
import com.becon.opencelium.backend.utility.Neo4jDriverUtility;
import com.becon.opencelium.backend.utility.ZipUtils;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.mongodb.client.MongoClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AssistantServiceImp
implements ApplicationService {
    private static final Logger log = LoggerFactory.getLogger(AssistantServiceImp.class);
    @Autowired
    private SystemOverviewRepository systemOverviewRepository;
    @Autowired
    private Environment env;
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ConnectionServiceImp connectionService;
    @Autowired
    private ConnectorServiceImp connectorServiceImp;
    @Autowired
    private ConnectionMngServiceImp connectionMngServiceImp;
    @Autowired
    private FieldBindingMngServiceImp fieldBindingMngServiceImp;
    @Autowired
    private InvokerServiceImp invokerServiceImp;

    public SystemOverview getSystemOverview() {
        return this.systemOverviewRepository.getCurrentOverview();
    }

    public Path uploadZipFile(MultipartFile file, Path location) {
        String filename = file.getOriginalFilename();
        Path target = location.resolve(filename);
        try {
            if (file.isEmpty()) {
                throw new StorageException("Failed to store empty file " + filename);
            }
            if (filename.contains("..")) {
                throw new StorageException("Cannot store file with relative path outside current directory " + filename);
            }
            if (!Files.exists(location, new LinkOption[0])) {
                Files.createDirectory(location, new FileAttribute[0]);
            }
            try (InputStream inputStream = file.getInputStream();){
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new StorageException("Failed to store file " + filename, (Throwable)e);
        }
        return target;
    }

    public void deleteZipFile(Path path) {
        if (path.equals("")) {
            return;
        }
        try {
            File tempFile = new File(path.toString());
            if (!tempFile.exists()) {
                return;
            }
            Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new StorageException("Failed to delete stored file", (Throwable)e);
        }
    }

    public SystemOverviewResource toResource(SystemOverview systemOverview) {
        SystemOverviewResource systemOverviewResource = new SystemOverviewResource();
        systemOverviewResource.setJava(systemOverview.getJava());
        systemOverviewResource.setOs(systemOverview.getOs());
        systemOverviewResource.setMariadb(systemOverview.getMariadb());
        systemOverviewResource.setMongodb(systemOverview.getMongodb());
        return systemOverviewResource;
    }

    public void createTmpDir(String dir) {
        Path filePath = Paths.get("assistant/temporary/" + dir + "/", new String[0]);
        if (Files.notExists(filePath, new LinkOption[0])) {
            File directory = new File("assistant/temporary/" + dir + "/");
            directory.mkdir();
            System.out.println("Directory has been created: assistant/temporary/" + dir + "/");
        }
        List<String> folders = Arrays.asList("connection/", "template/", "invoker/");
        folders.forEach(f -> {
            Path path = Paths.get("assistant/temporary/" + dir + "/" + f, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                File directory = new File("assistant/temporary/" + dir + "/" + f);
                directory.mkdir();
                System.out.println("Directory has been created: assistant/temporary/" + dir + "/" + f);
            }
        });
    }

    public String getCurrentVersion() {
        return this.systemOverviewRepository.getCurrentVersion();
    }

    public InstallationDTO getInstallation() {
        String installType;
        if (!this.env.containsProperty("opencelium.installation") && !this.env.containsProperty("opencelium.installation.type")) {
            installType = "undefined";
            log.warn("Path opencelium.installation.type not found in application.yml");
        } else {
            installType = this.env.getProperty("opencelium.installation.type");
        }
        return new InstallationDTO(installType);
    }

    public void moveToTmpFolder(Path filePath, String folder, String fileExtension) throws IOException {
        List<File> templates = Files.list(filePath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(fileExtension)).map(Path::toFile).collect(Collectors.toList());
        templates.forEach(f -> this.moveFiles(f.getPath(), folder + f.getName()));
    }

    public String getVersion(InputStream inputStream) {
        return this.systemOverviewRepository.getVersionFromStream(inputStream);
    }

    public void saveTmpInvoker(String xmlInvoker, String dir) {
        Document doc = AssistantServiceImp.convertStringToXMLDocument((String)xmlInvoker);
        NodeList nodeList = doc.getChildNodes();
        Node node = nodeList.item(0);
        Node nameNode = node.getChildNodes().item(1);
        String filename = nameNode.getTextContent();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File("assistant/temporary/" + dir + "/" + filename + ".xml"));
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void saveTmpTemplate(String template, String dir) {
        try {
            String jsonPath = "$.templateId";
            String filename = JsonPath.read((String)template, (String)jsonPath, (Predicate[])new Predicate[0]) + ".json";
            FileWriter jsonTemplate = new FileWriter("assistant/temporary/" + dir + "/" + filename);
            jsonTemplate.write(template);
            jsonTemplate.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveTmpConnection(String template, String dir) {
        try {
            String jsonPath = "$.connection.connectionId";
            String filename = JsonPath.read((String)template, (String)jsonPath, (Predicate[])new Predicate[0]) + ".json";
            FileWriter jsonTemplate = new FileWriter("assistant/temporary/" + dir + "/" + filename);
            jsonTemplate.write(template);
            jsonTemplate.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateOn(String version) throws Exception {
    }

    public void updateOff(String dir) throws Exception {
        dir = "assistant/versions/" + (String)dir;
        File backendRoot = new File("");
        File file = new File((String)dir);
        File[] dirFiles = file.listFiles();
        if (dirFiles == null || dirFiles.length == 0) {
            throw new RuntimeException("Zip file in folder \"versions/" + (String)dir + "\" not found.");
        }
        File zipFile = dirFiles[0];
        InputStream inputStream = Files.newInputStream(zipFile.toPath(), new OpenOption[0]);
        Path appRoot = Paths.get(backendRoot.getAbsolutePath(), new String[0]).getParent().getParent();
        log.info(zipFile.toPath() + ", " + appRoot);
        ZipUtils.extractZip((InputStream)inputStream, (Path)appRoot);
    }

    public boolean checkRepoConnection() {
        try {
            String url = "https://api.bitbucket.org/2.0/repositories/becon_gmbh/opencelium/refs/tags";
            HttpMethod method = HttpMethod.GET;
            HttpHeaders header = new HttpHeaders();
            header.set("Content-Type", "application/json");
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)header);
            ResponseEntity response = this.restTemplate.exchange(url, method, httpEntity, String.class, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void moveFiles(String fromDir, String toDir) {
        Path result = null;
        try {
            result = Files.move(Paths.get(fromDir, new String[0]), Paths.get(toDir, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            System.out.println("Exception while moving file: " + e.getMessage());
        }
        if (result != null) {
            System.out.println("File moved successfully.");
        } else {
            System.out.println("File movement failed.");
        }
    }

    public void updateConnection(ConnectionDTO connectionDTO) {
    }

    public void restore() {
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Path unzipFolder(InputStream inputStream, Path target) throws IOException {
        File f = new File("../frontend");
        FileUtils.deleteDirectory((File)f);
        String os = System.getProperty("os.name");
        if (os.contains("Windows")) {
            File destDir = new File(target.toString());
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zis.getNextEntry();
            String rootName = zipEntry.getName();
            String vFolder = this.zipSlipProtect(zipEntry, target).toString().replace(rootName, "");
            Path folder = Paths.get(vFolder, new String[0]);
            while (zipEntry != null) {
                File newFile = this.newFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            return folder.getParent();
        }
        try (ZipInputStream zis = new ZipInputStream(inputStream);){
            ZipEntry zipEntry = zis.getNextEntry();
            String rootName = zipEntry.getName();
            while (zipEntry != null) {
                boolean isDirectory = false;
                if (zipEntry.getName().endsWith(File.separator)) {
                    isDirectory = true;
                }
                String vFolder = this.zipSlipProtect(zipEntry, target).toString().replace(rootName, "");
                Path newPath = Paths.get(vFolder, new String[0]);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    System.out.println(zipEntry.getName() + ", " + newPath);
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            Path path = target;
            return path;
        }
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    private Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    public void doMigrate(Neo4jConfigResource neo4jConfig) {
        try (Driver driver = GraphDatabase.driver((String)neo4jConfig.getUrl(), (AuthToken)AuthTokens.basic((String)neo4jConfig.getUsername(), (String)neo4jConfig.getPassword()));
             Session session = driver.session();){
            driver.verifyConnectivity();
            log.info("Connection successfully established to neo4j server with this credentials : [url: {}, username: {}, password: {}]", new Object[]{neo4jConfig.getUrl(), neo4jConfig.getUsername(), neo4jConfig.getPassword().replaceAll(".", "*")});
            try {
                this.mongoClient.listDatabaseNames();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to connect to mongodb");
            }
            List connections = null;
            try {
                connections = this.connectionService.findAllNotCompleted();
            }
            catch (Exception e) {
                log.error("Failed to retrieve connections from neo4j", (Throwable)e);
            }
            if (connections.isEmpty()) {
                log.info("No connections to migrate");
                return;
            }
            for (Connection connection : connections) {
                try {
                    ConnectionMng connectionMng = new ConnectionMng();
                    connectionMng.setConnectionId(connection.getId());
                    Connector from = this.connectorServiceImp.getById(Integer.valueOf(connection.getFromConnector()));
                    Connector to = this.connectorServiceImp.getById(Integer.valueOf(connection.getToConnector()));
                    ConnectorMng fromMng = new ConnectorMng();
                    fromMng.setTitle(from.getTitle());
                    fromMng.setConnectorId(Integer.valueOf(from.getId()));
                    ConnectorMng toMng = new ConnectorMng();
                    toMng.setTitle(to.getTitle());
                    toMng.setConnectorId(Integer.valueOf(to.getId()));
                    connectionMng.setFromConnector(fromMng);
                    connectionMng.setToConnector(toMng);
                    String cypherQuery = "MATCH p=((:Connection{connectionId:%d})-[*]->()) return p".formatted(connection.getId());
                    Result result = session.run(cypherQuery);
                    if (!result.hasNext()) {
                        log.warn("Connection[name: {}, id: {}] is not found in neo4j", (Object)connection.getTitle(), (Object)connection.getId());
                        continue;
                    }
                    try {
                        Neo4jDriverUtility.convertResultToConnection((Result)result, (ConnectionMng)connectionMng);
                    }
                    catch (Exception e) {
                        log.error("Cannot convert Connection[name: {}, id: {}] from neo4j. {}", new Object[]{connection.getTitle(), connection.getId(), e.getMessage()});
                        e.printStackTrace();
                        continue;
                    }
                    this.addHeaderFromInvoker(connectionMng, from.getInvoker(), to.getInvoker());
                    connectionMng.setFieldBindings(this.fieldBindingMngServiceImp.getAllByConnectionId(connection.getId()));
                    this.connectionMngServiceImp.save(connectionMng);
                    log.info("Connection[name: {}, id: {}] successfully migrated", (Object)connection.getTitle(), (Object)connection.getId());
                }
                catch (Exception e) {
                    log.error("Some error occurred during migration of Connection[name: {}, id: {}]", (Object)connection.getTitle(), (Object)connection.getId());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void addHeaderFromInvoker(ConnectionMng connectionMng, String fromInvokerStr, String toInvokerStr) {
        Invoker fromInvoker = this.invokerServiceImp.findByName(fromInvokerStr);
        Invoker toInvoker = this.invokerServiceImp.findByName(toInvokerStr);
        this.addHeaderFromInvokerHelper(connectionMng.getFromConnector().getMethods(), fromInvoker);
        this.addHeaderFromInvokerHelper(connectionMng.getToConnector().getMethods(), toInvoker);
    }

    private void addHeaderFromInvokerHelper(List<MethodMng> methods, Invoker invoker) {
        for (MethodMng method : methods) {
            if (method.getRequest() == null) continue;
            HashMap<String, String> header = method.getRequest().getHeader();
            FunctionInvoker fv = invoker.getOperations().stream().filter(o -> o.getName().equals(method.getName())).findFirst().orElse(null);
            if (fv == null || fv.getRequest() == null || fv.getRequest().getHeader() == null) continue;
            Map header1 = fv.getRequest().getHeader();
            if (header == null) {
                header = new HashMap<String, String>();
            }
            for (Map.Entry entry : header1.entrySet()) {
                if (header.containsKey(entry.getKey())) continue;
                header.put((String)entry.getKey(), (String)entry.getValue());
            }
            method.getRequest().setHeader(header);
        }
    }
}

