/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.api.serviceportal;

import com.becon.opencelium.backend.api.ApiClient;
import com.becon.opencelium.backend.api.ApiType;
import com.becon.opencelium.backend.api.module.InvokerModuleImpl;
import com.becon.opencelium.backend.api.module.ReportModuleImpl;
import com.becon.opencelium.backend.api.module.SubscriptionModuleImpl;
import com.becon.opencelium.backend.api.module.TemplateModuleImpl;
import com.becon.opencelium.backend.api.serviceportal.ServicePortal;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class ServicePortalApi
implements ApiClient<ServicePortal> {
    private final RestTemplate restTemplate;
    private final String BASE_URL;
    private final ServicePortal features;

    public ServicePortalApi(@Qualifier(value="servicePortalRestTemplate") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.BASE_URL = restTemplate.getUriTemplateHandler().expand("", new Object[0]).toString();
        InvokerModuleImpl invoker = new InvokerModuleImpl(restTemplate);
        SubscriptionModuleImpl sub = new SubscriptionModuleImpl(restTemplate);
        ReportModuleImpl report = new ReportModuleImpl(restTemplate);
        TemplateModuleImpl template = new TemplateModuleImpl(restTemplate);
        this.features = new /* Unavailable Anonymous Inner Class!! */;
    }

    public ResponseEntity<String> checkConnection() {
        String endpoint = "/api/opencelium/connection/status";
        try {
            return this.restTemplate.getForEntity(endpoint, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Service Portal " + this.BASE_URL + endpoint + " is not reachable. Please check your settings!");
        }
        catch (HttpClientErrorException.Unauthorized e) {
            e.printStackTrace();
            if (e.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new RuntimeException("Token for Service Portal Auth is not valid. Please check your settings!");
            }
        }
        catch (HttpClientErrorException.Forbidden e) {
            e.printStackTrace();
            throw new RuntimeException("Token for Service Portal Auth is not set. Please check your settings!");
        }
        catch (Exception e) {
            throw e;
        }
        return null;
    }

    public ApiType<ServicePortal> type() {
        return ApiType.SERVICE_PORTAL;
    }

    public ServicePortal features() {
        return this.features;
    }
}

