/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.api.module;

import com.becon.opencelium.backend.api.exception.RemoteApiException;
import com.becon.opencelium.backend.api.module.ReportModule;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class ReportModuleImpl
implements ReportModule {
    private final RestTemplate rt;

    public ReportModuleImpl(RestTemplate rt) {
        this.rt = rt;
    }

    public void sendReport(Object payload) {
        String endpoint = "/api/opencelium/history/save";
        try {
            this.rt.postForEntity(endpoint, payload, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            throw new RemoteApiException("Service is not reachable at " + endpoint, (Throwable)e);
        }
    }

    public ResponseEntity<String> getLastOperationUsageHistory() {
        String endpoint = "/api/opencelium/history/last";
        try {
            return this.rt.getForEntity(endpoint, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            throw new RemoteApiException("Service is not reachable at " + endpoint, (Throwable)e);
        }
    }
}

