/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.api.factory;

import com.becon.opencelium.backend.api.ApiClient;
import com.becon.opencelium.backend.api.ApiType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ApiFactory {
    private final Map<ApiType<?>, ApiClient<?>> byType = new HashMap();

    public ApiFactory(List<ApiClient<?>> clients) {
        for (ApiClient<?> c : clients) {
            if (this.byType.put(c.type(), c) == null) continue;
            throw new IllegalStateException("Duplicate ApiClient for " + c.type());
        }
    }

    public <A> ApiClient<A> get(ApiType<A> type) {
        ApiClient c = (ApiClient)this.byType.get(type);
        if (c == null) {
            throw new IllegalArgumentException("No ApiClient for " + type);
        }
        return c;
    }
}

