/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager.connectionmng;

import com.becon.opencelium.backend.database.mongodb.entity.BodyMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConditionMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.FieldBindingMng;
import com.becon.opencelium.backend.database.mongodb.entity.MethodMng;
import com.becon.opencelium.backend.database.mongodb.entity.OperatorMng;
import com.becon.opencelium.backend.database.mongodb.entity.StatementMng;
import com.becon.opencelium.backend.ocel.OCExpressionHelper;
import com.becon.opencelium.backend.ocel.operator.OperatorEnum;
import com.becon.opencelium.backend.versionmanager.Wrapper;
import com.becon.opencelium.backend.versionmanager.base.Reference;
import com.becon.opencelium.backend.versionmanager.base.UpdaterVersion;
import com.becon.opencelium.backend.versionmanager.base.Utils;
import com.becon.opencelium.backend.versionmanager.base.Version43Utils;
import com.becon.opencelium.backend.versionmanager.connectionmng.ConnectionMngUpdater;
import io.micrometer.common.util.StringUtils;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class Connection44MngUpdater
implements ConnectionMngUpdater {
    private static final UpdaterVersion currentVersion = UpdaterVersion.VERSION_4_4;

    public Wrapper<ConnectionMng> updateToCurrentVersion(ConnectionMng connection) {
        return Objects.isNull(connection) ? Wrapper.notUpdated(null) : this.updateFromInternal(connection, connection.getVersion());
    }

    public Wrapper<ConnectionMng> updateFrom(ConnectionMng connection, String oldVersion) {
        return this.updateFromInternal(connection, oldVersion);
    }

    private Wrapper<ConnectionMng> updateFromInternal(ConnectionMng connection, String oldVersion) {
        if (Objects.isNull(connection) || Utils.compare((String)currentVersion.getVersion(), (String)oldVersion) <= 0) {
            return Wrapper.notUpdated((Object)connection);
        }
        connection.setVersion(currentVersion.getVersion());
        Reference changed = new Reference((Object)false);
        if (!Objects.isNull(connection.getFromConnector().getMethods())) {
            connection.getFromConnector().getMethods().forEach(x -> this.update(x, changed));
        }
        if (!Objects.isNull(connection.getFromConnector().getOperators())) {
            connection.getFromConnector().getOperators().forEach(x -> this.update(x, changed));
        }
        if (!Objects.isNull(connection.getToConnector().getMethods())) {
            connection.getToConnector().getMethods().forEach(x -> this.update(x, changed));
        }
        if (!Objects.isNull(connection.getToConnector().getOperators())) {
            connection.getToConnector().getOperators().forEach(x -> this.update(x, changed));
        }
        if (!Objects.isNull(connection.getFieldBindings())) {
            connection.getFieldBindings().forEach(x -> this.update(x, changed));
        }
        return Wrapper.updated((Object)connection).changed(((Boolean)changed.getValue()).booleanValue()).withOldVersion(oldVersion).withNewVersion(currentVersion.getVersion());
    }

    private void update(OperatorMng operator, Reference<Boolean> changed) {
        if (Objects.nonNull(operator) && Objects.nonNull(operator.getCondition())) {
            String exp;
            ConditionMng condition = operator.getCondition();
            StatementMng leftStatement = condition.getLeftStatement();
            StatementMng rightStatement = condition.getRightStatement();
            if (!Objects.isNull(leftStatement) && !StringUtils.isBlank((String)leftStatement.getType())) {
                leftStatement.setField(Version43Utils.replace((String)leftStatement.getField(), changed, (boolean)true, (boolean)Objects.equals(leftStatement.getType(), "header")));
            }
            if (!Objects.isNull(rightStatement)) {
                if (!StringUtils.isBlank((String)rightStatement.getType())) {
                    rightStatement.setField(Version43Utils.replace((String)rightStatement.getField(), changed, (boolean)true, (boolean)Objects.equals(rightStatement.getType(), "header")));
                }
            } else if (Objects.equals(OperatorEnum.EQUAL_TO.getName(), condition.getRelationalOperator()) || Objects.equals(OperatorEnum.NOT_EQUAL_TO.getName(), condition.getRelationalOperator())) {
                rightStatement = new StatementMng();
                rightStatement.setColor("");
                rightStatement.setField("");
                rightStatement.setType("");
                rightStatement.setRightPropertyValue("");
                condition.setRightStatement(rightStatement);
            }
            if (Objects.nonNull(exp = OCExpressionHelper.buildExp((ConditionMng)operator.getCondition()))) {
                operator.setExpression(exp);
                operator.setCondition(null);
            }
        }
    }

    private void update(MethodMng method, Reference<Boolean> changed) {
        if (!Objects.isNull(method) && !Objects.isNull(method.getRequest())) {
            Map headers = method.getRequest().getHeader();
            BodyMng body = method.getRequest().getBody();
            if (!Objects.isNull(headers)) {
                headers.entrySet().forEach(entry -> entry.setValue(Version43Utils.replace((String)((String)entry.getValue()), (Reference)changed)));
            }
            method.getRequest().setEndpoint(Version43Utils.replace((String)method.getRequest().getEndpoint(), changed));
            if (Objects.nonNull(body) && Objects.nonNull(body.getFields())) {
                body.setFields(Version43Utils.updateMap((Map)body.getFields(), changed));
            }
        }
    }

    private void update(FieldBindingMng fieldBindingMng, Reference<Boolean> changed) {
        if (Objects.nonNull(fieldBindingMng)) {
            if (Objects.nonNull(fieldBindingMng.getFrom())) {
                fieldBindingMng.getFrom().forEach(x -> {
                    if (Objects.nonNull(x) && !StringUtils.isBlank((String)x.getType())) {
                        x.setField(Version43Utils.replace((String)x.getField(), (Reference)changed, (boolean)true, (boolean)Objects.equals(x.getType(), "header")));
                    }
                });
            }
            if (Objects.nonNull(fieldBindingMng.getTo())) {
                fieldBindingMng.getTo().forEach(x -> {
                    if (Objects.nonNull(x) && !StringUtils.isBlank((String)x.getType())) {
                        x.setField(Version43Utils.replace((String)x.getField(), (Reference)changed, (boolean)true, (boolean)Objects.equals(x.getType(), "header")));
                    }
                });
            }
            if (Objects.nonNull(fieldBindingMng.getEnhancement()) && Objects.nonNull(fieldBindingMng.getEnhancement().getArgs())) {
                fieldBindingMng.getEnhancement().setArgs(Version43Utils.replace((String)fieldBindingMng.getEnhancement().getArgs(), changed));
            }
        }
    }
}

