/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.versionmanager.backup;

import com.becon.opencelium.backend.constant.props.OpenceliumProps;
import java.util.Arrays;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class MongoDbBackupService {
    private static final String CONNECTION_COLLECTION = "connection";
    private static final String FIELD_BINDING_COLLECTION = "field_binding";
    private static final String METHOD_COLLECTION = "method";
    private static final String OPERATOR_COLLECTION = "operator";
    private final MongoTemplate mongoTemplate;
    private final OpenceliumProps ocProps;

    public MongoDbBackupService(MongoTemplate mongoTemplate, OpenceliumProps ocProps) {
        this.mongoTemplate = mongoTemplate;
        this.ocProps = ocProps;
    }

    public void backup() {
        String connectionBackupCollection = this.buildBackupName(CONNECTION_COLLECTION);
        String fbBackupCollection = this.buildBackupName(FIELD_BINDING_COLLECTION);
        String methodBackupCollection = this.buildBackupName(METHOD_COLLECTION);
        String operatorBackupCollection = this.buildBackupName(OPERATOR_COLLECTION);
        if (this.mongoTemplate.collectionExists(connectionBackupCollection)) {
            this.mongoTemplate.dropCollection(connectionBackupCollection);
        }
        if (this.mongoTemplate.collectionExists(fbBackupCollection)) {
            this.mongoTemplate.dropCollection(fbBackupCollection);
        }
        if (this.mongoTemplate.collectionExists(methodBackupCollection)) {
            this.mongoTemplate.dropCollection(methodBackupCollection);
        }
        if (this.mongoTemplate.collectionExists(operatorBackupCollection)) {
            this.mongoTemplate.dropCollection(operatorBackupCollection);
        }
        this.copyCollection(CONNECTION_COLLECTION, connectionBackupCollection);
        this.copyCollection(FIELD_BINDING_COLLECTION, fbBackupCollection);
        this.copyCollection(METHOD_COLLECTION, methodBackupCollection);
        this.copyCollection(OPERATOR_COLLECTION, operatorBackupCollection);
    }

    private String buildBackupName(String name) {
        return name + "_backup_v" + this.ocProps.getVersion().replace('.', '_');
    }

    public void restore() {
        this.restoreCollection(CONNECTION_COLLECTION);
        this.restoreCollection(FIELD_BINDING_COLLECTION);
        this.restoreCollection(METHOD_COLLECTION);
        this.restoreCollection(OPERATOR_COLLECTION);
    }

    private void copyCollection(String source, String destination) {
        this.mongoTemplate.getDb().getCollection(source).aggregate(Arrays.asList(new Document("$match", (Object)new Document()), new Document("$out", (Object)destination))).toCollection();
    }

    private void restoreCollection(String collectionName) {
        String backupName = this.buildBackupName(collectionName);
        if (this.mongoTemplate.getDb().getCollection(backupName).countDocuments() == 0L) {
            return;
        }
        this.mongoTemplate.getDb().getCollection(collectionName).deleteMany((Bson)new Document());
        this.copyCollection(backupName, collectionName);
    }
}

