/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility.migrate;

import com.becon.opencelium.backend.utility.migrate.ChangeSet;
import com.becon.opencelium.backend.utility.migrate.ChangeSetDao;
import com.becon.opencelium.backend.utility.migrate.OperationType;
import com.becon.opencelium.backend.utility.migrate.YAMLMigrator;
import com.becon.opencelium.backend.utility.patch.PatchHelper;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.fge.jsonpatch.JsonPatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class YAMLMigrator {
    private static final JdbcTemplate JDBC_TEMPLATE;
    private static final ChangeSetDao DAO;
    private static final YAMLMapper YAML_MAPPER;
    private static final ObjectMapper OBJECT_MAPPER;
    private static final PatchHelper PATCH_HELPER;
    private static final File CHANGELOG_FILE;
    private static final File APP_YML_FILE;
    private static final File BACKUP_YML_FILE;
    private static final Logger log;
    private static List<ChangeSet> changeSetsToSave;

    public static List<ChangeSet> getChangeSetsToSave() {
        List list = changeSetsToSave;
        changeSetsToSave = null;
        return list;
    }

    public static void run() {
        if (!CHANGELOG_FILE.exists()) {
            return;
        }
        if (!APP_YML_FILE.exists()) {
            log.warn("A file 'application.yml' does not exist");
            return;
        }
        if (!YAMLMigrator.prepare()) {
            return;
        }
        try {
            YAMLMigrator.runInternally();
        }
        finally {
            BACKUP_YML_FILE.delete();
        }
    }

    private static boolean prepare() {
        StringBuilder sb;
        try {
            if (!BACKUP_YML_FILE.exists() && !BACKUP_YML_FILE.createNewFile()) {
                return false;
            }
            FileCopyUtils.copy((File)APP_YML_FILE, (File)BACKUP_YML_FILE);
        }
        catch (IOException e) {
            log.warn("An error occurred to copy application.yml file");
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(APP_YML_FILE));){
            Object line;
            sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                String val;
                if (((String)line).contains("{") && ((String)line).contains("}") && !YAMLMigrator.isCommentLine((String)line) && (val = ((String)line).substring(((String)line).indexOf(":") + 1).trim()).startsWith("{") && val.endsWith("}")) {
                    val = val.replaceFirst("\\{", "#").substring(0, val.length() - 1);
                    line = ((String)line).substring(0, ((String)line).indexOf(":") + 2) + val;
                }
                sb.append((String)line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            BACKUP_YML_FILE.delete();
            throw new RuntimeException(e);
        }
        try (FileOutputStream fos = new FileOutputStream(APP_YML_FILE);){
            fos.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            try {
                FileCopyUtils.copy((File)BACKUP_YML_FILE, (File)APP_YML_FILE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private static void runInternally() {
        Map appYamlMap = YAMLMigrator.readYAMLFile((File)APP_YML_FILE);
        if (appYamlMap == null) {
            return;
        }
        if (!YAMLMigrator.setDataSource((Map)appYamlMap)) {
            return;
        }
        Map changelog = YAMLMigrator.readYAMLFile((File)CHANGELOG_FILE);
        if (CollectionUtils.isEmpty((Map)changelog)) {
            return;
        }
        List changeSetList = YAMLMigrator.validateAndConvert((Map)changelog);
        if (changeSetList.isEmpty()) {
            return;
        }
        String fullVersionOfLastChangeSetInFile = ((ChangeSet)changeSetList.get(changeSetList.size() - 1)).getVersion();
        ChangeSet lastSavedSet = YAMLMigrator.getLastChangeSet();
        if (lastSavedSet == null) {
            String ocVersion = YAMLMigrator.getOcVersion((Map)appYamlMap);
            lastSavedSet = new ChangeSet();
            lastSavedSet.setVersion(ocVersion);
        }
        if (YAMLMigrator.isGreaterThanOrEqual((String)lastSavedSet.getVersion(), (String)fullVersionOfLastChangeSetInFile)) {
            return;
        }
        ArrayList<ChangeSet> newChangeSets = new ArrayList<ChangeSet>();
        for (ChangeSet changeSet : changeSetList) {
            if (YAMLMigrator.isGreaterThanOrEqual((String)lastSavedSet.getVersion(), (String)changeSet.getVersion())) continue;
            newChangeSets.add(changeSet);
        }
        if (newChangeSets.isEmpty()) {
            return;
        }
        Object patched = appYamlMap;
        for (int i = 0; i < newChangeSets.size(); ++i) {
            ChangeSet changeSet = (ChangeSet)newChangeSets.get(i);
            JsonPatch singleJsonPatch = YAMLMigrator.convertToJsonPatch((ChangeSet)changeSet);
            if (singleJsonPatch == null) {
                changeSet.setSuccess(false);
                continue;
            }
            try {
                patched = PATCH_HELPER.patch(singleJsonPatch, patched, Object.class);
                changeSet.setSuccess(true);
                continue;
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && (e.getCause().getMessage().equals("parent of node to add does not exist") || e.getCause().getMessage().equals("parent of path to add to is not a container"))) {
                    if (PATCH_HELPER.size(singleJsonPatch) == 2) {
                        JsonPatch firstOp = PATCH_HELPER.delete(singleJsonPatch, 1, 2);
                        patched = YAMLMigrator.fillUp((String)changeSet.getPath().replaceAll("\\.", "/"), (JsonPatch)firstOp, (Object)patched);
                    } else {
                        patched = YAMLMigrator.fillUp((String)changeSet.getPath().replaceAll("\\.", "/"), (JsonPatch)singleJsonPatch, (Object)patched);
                    }
                    --i;
                    continue;
                }
                if (e.getCause() != null && e.getCause().getMessage().equals("value cannot be null") || changeSet.getOperation() == OperationType.DELETE && e.getCause() != null && e.getCause().getMessage().equals("no such path in target JSON document")) {
                    changeSet.setSuccess(false);
                    continue;
                }
                log.warn("An error occurred while applying {} - changeset : {}", (Object)changeSet.getVersion(), (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
                YAMLMigrator.finish((Object)patched, newChangeSets.subList(0, i));
                return;
            }
        }
        YAMLMigrator.finish((Object)patched, newChangeSets);
    }

    private static String getOcVersion(Map<String, Object> map) {
        Map oc = (Map)map.get("opencelium");
        return oc.getOrDefault("version", "0.0").toString() + ":-1";
    }

    private static void finish(Object yaml, List<ChangeSet> changeSetsForSave) {
        if (changeSetsForSave.isEmpty()) {
            return;
        }
        List commentLines = YAMLMigrator.readComments();
        YAMLMigrator.changeRenamedPaths((List)commentLines, changeSetsForSave);
        try {
            YAML_MAPPER.writeValue(APP_YML_FILE, yaml);
            YAMLMigrator.writeComments((List)commentLines);
        }
        catch (IOException e) {
            try {
                FileCopyUtils.copy((File)BACKUP_YML_FILE, (File)APP_YML_FILE);
            }
            catch (IOException ex) {
                log.warn("Failed to write application.yml file. Please check application.yml and rerun");
                BACKUP_YML_FILE.delete();
                throw new RuntimeException(ex);
            }
            log.warn("Failed to write YAML file");
            return;
        }
        try {
            DAO.getLast();
        }
        catch (BadSqlGrammarException e) {
            changeSetsToSave = changeSetsForSave;
            return;
        }
        DAO.createAll(changeSetsForSave);
    }

    private static void changeRenamedPaths(List<Comment> commentLines, List<ChangeSet> changeSets) {
        for (ChangeSet changeSet : changeSets) {
            if (changeSet.getOperation() != OperationType.RENAME) continue;
            for (Comment cl : commentLines) {
                if (cl.prev.isEmpty() || !cl.prev.equals(changeSet.getPath())) continue;
                cl.prev = (String)changeSet.getValue();
            }
        }
    }

    private static Object fillUp(String path, JsonPatch jsonPatch, Object obj) {
        JsonPatch parent = PATCH_HELPER.changeEachPath(jsonPatch, x -> x.substring(0, x.lastIndexOf("/")));
        parent = PATCH_HELPER.changeEachValue(parent);
        try {
            return PATCH_HELPER.patch(parent, obj, Object.class);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && (e.getCause().getMessage().equals("parent of node to add does not exist") || e.getCause().getMessage().equals("parent of path to add to is not a container"))) {
                return YAMLMigrator.fillUp((String)path.substring(0, path.lastIndexOf("/")), (JsonPatch)parent, (Object)obj);
            }
            throw e;
        }
    }

    private static boolean isCommentLine(String line) {
        return line.trim().startsWith("#") || line.isEmpty();
    }

    private static JsonPatch convertToJsonPatch(ChangeSet changeSet) {
        ArrayList opList = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (2.$SwitchMap$com$becon$opencelium$backend$utility$migrate$OperationType[changeSet.getOperation().ordinal()]) {
            case 1: {
                map.put("op", "add");
                map.put("path", "/" + changeSet.getPath().replaceAll("\\.", "/"));
                map.put("value", changeSet.getValue());
                opList.add(map);
                break;
            }
            case 2: {
                map.put("op", "replace");
                map.put("path", "/" + changeSet.getPath().replaceAll("\\.", "/"));
                map.put("value", changeSet.getValue());
                opList.add(map);
                break;
            }
            case 3: {
                map.put("op", "remove");
                map.put("path", "/" + changeSet.getPath().replaceAll("\\.", "/"));
                changeSet.setValue(null);
                opList.add(map);
                break;
            }
            case 4: {
                HashMap<String, Object> prev = new HashMap<String, Object>();
                String toPath = "/" + ((String)changeSet.getValue()).replaceAll("\\.", "/");
                prev.put("op", "add");
                prev.put("path", toPath);
                prev.put("value", "");
                opList.add(prev);
                String fromPath = "/" + changeSet.getPath().replaceAll("\\.", "/");
                map.put("op", "move");
                map.put("from", fromPath);
                map.put("path", toPath);
                opList.add(map);
                break;
            }
            case 5: {
                String fromPath = "/" + changeSet.getPath().replaceAll("\\.", "/");
                String newName = (String)changeSet.getValue();
                String newPath = fromPath.substring(0, fromPath.lastIndexOf("/") + 1) + newName;
                HashMap<String, Object> prev = new HashMap<String, Object>();
                prev.put("op", "add");
                prev.put("path", newPath);
                prev.put("value", "");
                opList.add(prev);
                map.put("op", "move");
                map.put("from", fromPath);
                map.put("path", newPath);
                opList.add(map);
                break;
            }
            default: {
                log.warn("Unsupported operation: {}", (Object)changeSet.getOperation().getValue());
                return null;
            }
        }
        return (JsonPatch)OBJECT_MAPPER.convertValue(opList, JsonPatch.class);
    }

    private static List<ChangeSet> validateAndConvert(Map<String, Object> changelog) {
        if (changelog == null || !changelog.containsKey("versions")) {
            throw new RuntimeException("Syntax error: Missing root property 'versions'");
        }
        List versions = YAMLMigrator.getAsList(changelog, (String)"versions", (String)"Syntax error: 'versions' should be a list");
        String versionRgx = "^[0-9]+(?:\\.[0-9]+)*$";
        ArrayList<ChangeSet> result = new ArrayList<ChangeSet>();
        for (int versionIndex = 0; versionIndex < versions.size(); ++versionIndex) {
            Map version = (Map)versions.get(versionIndex);
            String versionVal = YAMLMigrator.getAsString((Map)version, (String)"version", (String)"Syntax error: 'version' property is required. Location: versions[%d]".formatted(versionIndex));
            if (!versionVal.matches(versionRgx)) {
                throw new RuntimeException("Syntax error: Invalid version format '%s'. Location: versions[%d]".formatted(versionVal, versionIndex));
            }
            List changes = YAMLMigrator.getAsList((Map)version, (String)"changes", (String)"Syntax error: 'changes' array is required. Location: versions[%d]".formatted(versionIndex));
            if (changes.isEmpty()) continue;
            for (int changeIndex = 0; changeIndex < changes.size(); ++changeIndex) {
                Map change = (Map)changes.get(changeIndex);
                ChangeSet changeSet = new ChangeSet();
                String changeSetVersion = YAMLMigrator.getAsString((Map)change, (String)"changeset", (String)"Syntax error: 'changeset' property is required. Location: versions[%s] -> changes[%d]".formatted(versionVal, changeIndex));
                changeSet.setVersion(versionVal + ":" + changeSetVersion);
                changeSet.setPath(YAMLMigrator.getAsString((Map)change, (String)"path", (String)"Syntax error: 'path' property is required. Location: versions[%s] -> changeset[%s]".formatted(versionVal, changeSetVersion)));
                String operation = YAMLMigrator.getAsString((Map)change, (String)"operation", (String)"Syntax error: 'operation' property is required. Location: versions[%s] -> changeset[%s]".formatted(versionVal, changeSetVersion));
                OperationType op = OperationType.getFromNameOrElseNull((String)operation);
                if (op == null) {
                    throw new RuntimeException("Syntax error: Invalid operation '%s'. Location: versions[%s] -> changeset[%s]".formatted(operation, versionVal, changeSetVersion));
                }
                changeSet.setOperation(op);
                if (op != OperationType.DELETE) {
                    changeSet.setValue((Object)YAMLMigrator.getAsString((Map)change, (String)"value", (String)"Syntax error: 'value' property is required for '%s' operations. Location: versions[%s] -> changeset[%s]".formatted(versionVal, op.getValue(), changeSetVersion)));
                }
                result.add(changeSet);
            }
        }
        return result;
    }

    private static List<Map<String, Object>> getAsList(Map<String, Object> map, String key, String errorMessage) {
        List list;
        Object value = map.get(key);
        if (!(value instanceof List) || (list = (List)value).isEmpty() || !(list.get(0) instanceof Map)) {
            throw new RuntimeException(errorMessage);
        }
        return list;
    }

    private static String getAsString(Map<String, Object> map, String key, String errorMessage) {
        Object value = map.get(key);
        if (Objects.isNull(value) || value instanceof Map || value instanceof List) {
            throw new RuntimeException(errorMessage);
        }
        return value.toString();
    }

    private static boolean setDataSource(Map<String, Object> yaml) {
        Map spring = yaml.getOrDefault("spring", new HashMap());
        Map datasource = spring.getOrDefault("datasource", new HashMap());
        String url = datasource.getOrDefault("url", "").toString();
        String username = datasource.getOrDefault("username", "").toString();
        String password = datasource.getOrDefault("password", "").toString();
        String driver = datasource.getOrDefault("driver-class-name", "").toString();
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setDriverClassName(driver);
        try {
            dataSource.getConnection();
        }
        catch (SQLException e) {
            log.warn("An error is occurred while connecting to the database");
            return false;
        }
        JDBC_TEMPLATE.setDataSource((DataSource)dataSource);
        return true;
    }

    private static boolean isGreaterThanOrEqual(String v1, String v2) {
        String[] split2;
        String[] split1 = v1.split(":");
        int result = YAMLMigrator.compareVersions((String)split1[0], (String)(split2 = v2.split(":"))[0]);
        if (result == 1) {
            return true;
        }
        if (result == 0) {
            return Integer.parseInt(split1[1]) >= Integer.parseInt(split2[1]);
        }
        return false;
    }

    private static int compareVersions(String v1, String v2) {
        String[] v1Parts = v1.split("\\.");
        String[] v2Parts = v2.split("\\.");
        int length = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < length; ++i) {
            int v2Part;
            int v1Part = i < v1Parts.length ? Integer.parseInt(v1Parts[i]) : 0;
            int n = v2Part = i < v2Parts.length ? Integer.parseInt(v2Parts[i]) : 0;
            if (v1Part > v2Part) {
                return 1;
            }
            if (v1Part >= v2Part) continue;
            return -1;
        }
        return 0;
    }

    private static ChangeSet getLastChangeSet() {
        try {
            return DAO.getLast();
        }
        catch (BadSqlGrammarException e) {
            return null;
        }
    }

    private static Map<String, Object> readYAMLFile(File file) {
        try {
            return (Map)YAML_MAPPER.readValue(file, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            log.warn("Failed to parse '{}' file", (Object)file.getName());
            return null;
        }
    }

    private static LinkedList<String> readFile(File file) {
        LinkedList<String> lines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            lines = new LinkedList();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            log.warn("Unable to read application.yaml file. Comments may be ignored");
        }
        return lines;
    }

    private static List<Comment> readComments() {
        ArrayList<Comment> arrayList;
        ArrayList<Comment> comments = new ArrayList<Comment>();
        BufferedReader reader = new BufferedReader(new FileReader(APP_YML_FILE));
        try {
            String line;
            boolean hasPrev = false;
            Stack<Object> stack = new Stack<Object>();
            while ((line = reader.readLine()) != null) {
                int currHeadTabs;
                if (YAMLMigrator.isCommentLine((String)line)) {
                    if (!hasPrev) {
                        comment = new Comment();
                        comment.lines.add(line);
                        comment.prev = YAMLMigrator.getFullPath(stack);
                        comments.add(comment);
                    } else {
                        comment = comments.get(comments.size() - 1);
                        comment.lines.add(line);
                    }
                    hasPrev = true;
                    continue;
                }
                if (!line.trim().startsWith("-")) {
                    hasPrev = false;
                    if (!stack.isEmpty()) {
                        int prev = Integer.parseInt((String)stack.peek());
                        String tabs = YAMLMigrator.headingTabs((String)line);
                        int tabsInt = Integer.parseInt(tabs);
                        while (prev == tabsInt) {
                            stack.pop();
                            stack.pop();
                            prev = Integer.parseInt((String)stack.peek());
                        }
                        if (prev > tabsInt) {
                            for (int diff = (prev - tabsInt) / 2 + 1; diff > 0; --diff) {
                                stack.pop();
                                stack.pop();
                            }
                        }
                    }
                    String trim = line.trim();
                    String name = trim.substring(0, trim.indexOf(":"));
                    stack.push(name);
                    stack.push(YAMLMigrator.headingTabs((String)line));
                    continue;
                }
                hasPrev = false;
                String tabs = YAMLMigrator.headingTabs((String)line);
                int prevHeadTabs = Integer.parseInt((String)stack.peek());
                if (prevHeadTabs == (currHeadTabs = Integer.parseInt(tabs))) {
                    String pop = (String)stack.pop();
                    String prevName = (String)stack.pop();
                    prevIndex = -1;
                    if (prevName.matches("\\d+")) {
                        prevIndex = Integer.parseInt(prevName);
                    } else {
                        stack.push(prevName);
                        stack.push(pop);
                    }
                    currIndex = prevIndex + 1;
                    stack.push(String.valueOf(currIndex));
                    stack.push(tabs);
                } else if (currHeadTabs - prevHeadTabs == 2) {
                    stack.push("0");
                    stack.push(tabs);
                } else if (prevHeadTabs > currHeadTabs) {
                    String prevIndexStr = "-1";
                    for (int diff = (prevHeadTabs - currHeadTabs) / 2 + 1; diff > 0; --diff) {
                        stack.pop();
                        prevIndexStr = (String)stack.pop();
                    }
                    prevIndex = Integer.parseInt(prevIndexStr);
                    currIndex = prevIndex + 1;
                    stack.push(String.valueOf(currIndex));
                    stack.push(tabs);
                }
                if ((line = line.trim().substring(1)).trim().startsWith("'") || !line.contains(":")) continue;
                String name = line.substring(0, line.indexOf(":")).trim();
                stack.push(name);
                stack.push("" + (currHeadTabs + 2));
            }
            arrayList = comments;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.warn("Unable to read comments from application.yaml file. Some comments may be ignored");
                return comments;
            }
        }
        reader.close();
        return arrayList;
    }

    private static void writeComments(List<Comment> commentLines) throws IOException {
        LinkedList lines = YAMLMigrator.readFile((File)APP_YML_FILE);
        for (int i = 0; i < lines.size(); ++i) {
            if (YAMLMigrator.isCommentLine((String)((String)lines.get(i))) || !((String)lines.get(i)).endsWith(" null")) continue;
            lines.set(i, ((String)lines.get(i)).substring(0, ((String)lines.get(i)).lastIndexOf("null")));
        }
        commentLines.stream().filter(c -> c.prev.isEmpty()).findAny().ifPresent(cc -> lines.addAll(0, cc.lines));
        try {
            block10: for (Comment comment : commentLines) {
                if (comment.prev.isEmpty()) continue;
                Stack<Object> stack = new Stack<Object>();
                boolean is = false;
                for (int i = 0; i < lines.size(); ++i) {
                    if (YAMLMigrator.isCommentLine((String)((String)lines.get(i)))) continue;
                    String line2 = (String)lines.get(i);
                    if (!line2.trim().startsWith("-")) {
                        if (!stack.isEmpty()) {
                            int prev = Integer.parseInt((String)stack.peek());
                            String tabs = YAMLMigrator.headingTabs((String)line2);
                            int tabsInt = Integer.parseInt(tabs);
                            while (prev == tabsInt) {
                                stack.pop();
                                stack.pop();
                                prev = Integer.parseInt((String)stack.peek());
                            }
                            if (prev > tabsInt) {
                                for (int diff = (prev - tabsInt) / 2 + 1; diff > 0; --diff) {
                                    stack.pop();
                                    stack.pop();
                                }
                            }
                        }
                        String trim = line2.trim();
                        String name = trim.substring(0, trim.indexOf(":"));
                        stack.push(name);
                        stack.push(YAMLMigrator.headingTabs((String)line2));
                    } else {
                        int currHeadTabs;
                        String tabs = YAMLMigrator.headingTabs((String)line2);
                        int prevHeadTabs = Integer.parseInt((String)stack.peek());
                        if (prevHeadTabs == (currHeadTabs = Integer.parseInt(tabs))) {
                            String pop = (String)stack.pop();
                            String prevName = (String)stack.pop();
                            prevIndex = -1;
                            if (prevName.matches("\\d+")) {
                                prevIndex = Integer.parseInt(prevName);
                            } else {
                                stack.push(prevName);
                                stack.push(pop);
                            }
                            currIndex = prevIndex + 1;
                            stack.push(String.valueOf(currIndex));
                            stack.push(tabs);
                        } else if (currHeadTabs - prevHeadTabs == 2) {
                            stack.push("0");
                            stack.push(tabs);
                        } else if (prevHeadTabs > currHeadTabs) {
                            String prevIndexStr = "-1";
                            for (int diff = (prevHeadTabs - currHeadTabs) / 2 + 1; diff > 0; --diff) {
                                stack.pop();
                                prevIndexStr = (String)stack.pop();
                            }
                            prevIndex = Integer.parseInt(prevIndexStr);
                            currIndex = prevIndex + 1;
                            stack.push(String.valueOf(currIndex));
                            stack.push(tabs);
                        }
                        line2 = line2.trim().substring(1);
                        if (!line2.trim().startsWith("'") && line2.contains(":")) {
                            String name = line2.substring(0, line2.indexOf(":")).trim();
                            stack.push(name);
                            stack.push("" + (currHeadTabs + 2));
                        }
                    }
                    String path = YAMLMigrator.getFullPath(stack);
                    String root = path.split("\\.")[0];
                    if (is && comment.prev.equals(path)) {
                        lines.addAll(i + 1, comment.lines);
                        continue block10;
                    }
                    if (comment.prev.startsWith(root)) {
                        is = true;
                    } else if (is) {
                        lines.addAll(i, comment.lines);
                        continue block10;
                    }
                    if (lines.size() - 1 != i) continue;
                    log.error("Cannot find this comment section's place to move:\n{}", (Object)StringUtils.join((Iterable)comment.lines, (String)"\n"));
                }
            }
        }
        catch (Exception e) {
            log.warn("Some exception occurred during writing comments. Some comments may be ignored");
        }
        StringBuilder sb = new StringBuilder();
        lines.forEach(line -> sb.append((String)line).append("\n"));
        try (FileWriter fw = new FileWriter(APP_YML_FILE);){
            fw.write(sb.toString());
        }
        catch (IOException e) {
            log.warn("Cannot move comments into application.yaml file. Comments may be ignored");
        }
    }

    private static String getFullPath(Stack<String> stack) {
        if (stack.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator iterator = stack.elements().asIterator();
        while (iterator.hasNext()) {
            if (!(i & true)) {
                sb.append((String)iterator.next());
                sb.append(".");
            } else {
                iterator.next();
            }
            ++i;
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static String headingTabs(String line) {
        if (!line.startsWith(" ")) {
            return "0";
        }
        int i = -1;
        for (char c : line.toCharArray()) {
            ++i;
            if (c == ' ') continue;
            if ((i & 1) == 0) {
                return "" + i;
            }
            return "" + (i + 1);
        }
        return "" + i;
    }

    static {
        YAML_MAPPER = new YAMLMapper();
        OBJECT_MAPPER = new ObjectMapper();
        log = LoggerFactory.getLogger(YAMLMigrator.class);
        YAML_MAPPER.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        YAML_MAPPER.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_YAML_COMMENTS});
        YAML_MAPPER.disable(YAMLGenerator.Feature.SPLIT_LINES);
        YAML_MAPPER.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        JDBC_TEMPLATE = new JdbcTemplate();
        DAO = new ChangeSetDao(JDBC_TEMPLATE);
        PATCH_HELPER = new PatchHelper(OBJECT_MAPPER);
        Path root = Paths.get(new File("").toURI());
        APP_YML_FILE = new File(root.resolve("src/main/resources/application.yml").toString());
        CHANGELOG_FILE = new File(root.resolve("src/main/resources/db/changelog/springboot/application_changelog.yml").toString());
        BACKUP_YML_FILE = new File(root.resolve("src/main/resources/application_copy.yml").toString());
    }
}

