/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility.migrate;

import com.becon.opencelium.backend.utility.migrate.ChangeSet;
import com.becon.opencelium.backend.utility.migrate.ChangeSetRowMapper;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ChangeSetDao {
    private static final Logger log = LoggerFactory.getLogger(ChangeSetDao.class);
    private final JdbcTemplate template;

    public ChangeSetDao(DataSource dataSource) {
        this.template = new JdbcTemplate(dataSource);
    }

    public ChangeSetDao(JdbcTemplate template) {
        this.template = template;
    }

    public void create(ChangeSet changeSet) {
        this.template.update("INSERT INTO change_set_yml (version, path, op, timestamp, success, value) VALUES(?,?,?,?,?,?)", new Object[]{changeSet.getVersion(), changeSet.getPath(), changeSet.getOperation().getValue(), System.currentTimeMillis(), changeSet.isSuccess(), changeSet.getValue()});
    }

    public ChangeSet get(int id) {
        List list = this.template.query("select * from change_set_yml where id = ? limit 1", new Object[]{id}, (RowMapper)new ChangeSetRowMapper());
        if (list.isEmpty()) {
            return null;
        }
        return (ChangeSet)list.get(0);
    }

    public ChangeSet getLast() {
        List list = this.template.query("select * from change_set_yml ORDER BY timestamp DESC limit 1", (RowMapper)new ChangeSetRowMapper());
        if (list.isEmpty()) {
            return null;
        }
        return (ChangeSet)list.get(0);
    }

    public void createAll(List<ChangeSet> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ChangeSet changeSet : list) {
            this.create(changeSet);
            if (changeSet.isSuccess()) {
                log.info("YAML changelog: {} successfully applied", (Object)changeSet.getVersion());
                continue;
            }
            log.warn("YAML changelog: {} is ignored", (Object)changeSet.getVersion());
        }
    }
}

