/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReferenceUtility {
    public static final String IS_FOR_IN_KEY_TYPE = "\\['(.*?)\\']~";
    public static final String IS_FOR_IN_VALUE_TYPE = "\\['(.*?)\\']";
    public static final String IS_SPLIT_STRING_TYPE = "\\[([a-z0-9*]+)\\]~";
    public static final String ARRAY_LETTER_INDEX = "\\[([a-z])\\]";

    public static boolean containsRef(String value) {
        if (value == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+|\\{%#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+\\%}|#\\{%[0-9a-fA-F]{24}%\\}|\\$\\{(.*?)\\}|@\\{([^}]+)\\}|\\{(?!%)(.*?)(?<!%)\\}");
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static List<String> extractRefs(String value) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{%#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+\\%}|#\\{%[0-9a-fA-F]{24}%\\}|\\$\\{(.*?)\\}|@\\{([^}]+)\\}|\\{(?!%)(.*?)(?<!%)\\}");
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static String extractRef(String value, String type) {
        Pattern pattern = Pattern.compile(type);
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String extractDirectRef(String ref) {
        if (ref.startsWith("{%") && ref.endsWith("%}")) {
            ref = ref.substring(2, ref.length() - 2);
        }
        return ref;
    }

    public static String extractExchangeType(String ref) {
        return ref.charAt(11) == 's' ? "response" : "request";
    }

    public static String getResult(String ref) {
        String exchange = ReferenceUtility.extractExchangeType((String)ref);
        String res = "";
        if (exchange.equals("response")) {
            res = ref.split("\\.")[2];
        }
        return res;
    }

    public static String[] splitPaths(String paths) {
        if (((String)paths).isEmpty()) {
            return new String[]{""};
        }
        paths = (String)paths + ".";
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder holder = new StringBuilder();
        Stack<Character> braces = new Stack<Character>();
        for (char current : ((String)paths).toCharArray()) {
            if (current == '.' && braces.isEmpty()) {
                parts.add(holder.toString());
                holder = new StringBuilder();
                continue;
            }
            if (current == '[') {
                braces.push(Character.valueOf(current));
                holder.append(current);
                continue;
            }
            if (current == ']') {
                if (braces.isEmpty() || ((Character)braces.pop()).charValue() != '[') {
                    throw new RuntimeException("Wrong value is supplied to reference");
                }
                holder.append(current);
                continue;
            }
            holder.append(current);
        }
        String[] result = new String[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            result[i] = ReferenceUtility.wrapSpacesIfNecessary((String)((String)parts.get(i)));
        }
        return result;
    }

    public static String getPointerToBody(String ref, int partCount, String remove) {
        String[] refParts = ReferenceUtility.splitPaths((String)ref);
        Object result = "";
        for (int i = 0; i < partCount - 1; ++i) {
            result = (String)result + refParts[i] + ".";
        }
        result = (String)result + refParts[partCount - 1].replace(remove, "");
        return result;
    }

    public static boolean equals(String ref1, String ref2) {
        String[] potentialRefParts;
        String[] actualRefParts = ref1.split("\\.");
        if (actualRefParts.length > (potentialRefParts = ref2.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < actualRefParts.length; ++i) {
            String part = actualRefParts[i].contains("[") ? actualRefParts[i].substring(0, actualRefParts[i].indexOf(91)) : actualRefParts[i];
            if (potentialRefParts[i].contains(part)) continue;
            return false;
        }
        return true;
    }

    private static String wrapSpacesIfNecessary(String part) {
        if (!part.contains(" ")) {
            return part;
        }
        StringBuilder result = new StringBuilder();
        StringBuilder holder = new StringBuilder();
        Stack<Character> braces = new Stack<Character>();
        for (int i = 0; i < part.length(); ++i) {
            char current = part.charAt(i);
            if (current == '[') {
                ReferenceUtility.appendNonEmptyHolder((StringBuilder)result, (StringBuilder)holder);
                braces.push(Character.valueOf(current));
                result.append(current);
                continue;
            }
            if (current == ']') {
                if (braces.isEmpty() || ((Character)braces.pop()).charValue() != '[') {
                    throw new RuntimeException("Wrong value is supplied to reference");
                }
                result.append(current);
                continue;
            }
            if (braces.isEmpty()) {
                holder.append(current);
                continue;
            }
            result.append(current);
        }
        ReferenceUtility.appendNonEmptyHolder((StringBuilder)result, (StringBuilder)holder);
        return result.toString();
    }

    private static void appendNonEmptyHolder(StringBuilder result, StringBuilder holder) {
        if (!holder.isEmpty()) {
            if (holder.indexOf(" ") != -1) {
                result.append("['").append((CharSequence)holder).append("']");
            } else {
                result.append((CharSequence)holder);
            }
            holder.setLength(0);
        }
    }
}

