/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import com.becon.opencelium.backend.utility.PathAndReferenceUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class PathAndReferenceUtility {
    private static final String PRE_DIRECT_REF = "{%#";
    private static final String SUF_DIRECT_REF = "%}";
    private static final String PRE_WEBHOOK = "${";
    private static final String SUF_WEBHOOK = "}";
    private static final String PRE_BRACKET = "['";
    private static final String SUF_BRACKET = "']";
    private static final EmptyQueryValuePolicy EMPTY_QUERY_VALUE_POLICY = EmptyQueryValuePolicy.SET_EMPTY;
    private static final Logger log = LogManager.getLogger(PathAndReferenceUtility.class);

    public static int indexOf(String path, char ch, boolean hasWebHook, boolean hasDirectRef) {
        return PathAndReferenceUtility.indexOf((String)path, (char)ch, (boolean)true, (boolean)hasWebHook, (boolean)hasDirectRef);
    }

    public static int indexOf(String path, char ch, boolean hasBracket, boolean hasWebhook, boolean hasDirectRef) {
        if (path == null) {
            return -1;
        }
        int idx = path.indexOf(ch);
        if (idx == -1) {
            return idx;
        }
        int pre1 = path.indexOf("{%#");
        int pre2 = path.indexOf("${");
        int pre3 = path.indexOf("['");
        if (!((hasDirectRef && pre1 != -1 || hasWebhook && pre2 != -1 || hasBracket && pre3 != -1) && (hasDirectRef && pre1 <= idx || hasWebhook && pre2 <= idx || hasBracket && pre3 <= idx))) {
            return idx;
        }
        Stack<String> stack = new Stack<String>();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            if (stack.empty() && path.charAt(i) == ch) {
                return i;
            }
            if (hasDirectRef && i + "{%#".length() < n && path.startsWith("{%#", i)) {
                stack.push("%}");
                i += "{%#".length() - 1;
                continue;
            }
            if (hasWebhook && i + "${".length() < n && path.startsWith("${", i)) {
                stack.push("}");
                i += "${".length() - 1;
                continue;
            }
            if (hasBracket && i + "['".length() < n && path.startsWith("['", i)) {
                stack.push("']");
                i += "['".length() - 1;
                continue;
            }
            if (hasDirectRef && i + "%}".length() < n && path.startsWith("%}", i)) {
                if (stack.empty() || !((String)stack.peek()).equals("%}")) continue;
                stack.pop();
                i += "%}".length() - 1;
                continue;
            }
            if (hasWebhook && i + "}".length() < n && path.startsWith("}", i)) {
                if (stack.empty() || !((String)stack.peek()).equals("}")) continue;
                stack.pop();
                i += "}".length() - 1;
                continue;
            }
            if (!hasBracket || i + "']".length() >= n || !path.startsWith("']", i) || stack.empty() || !((String)stack.peek()).equals("']")) continue;
            stack.pop();
            i += "']".length() - 1;
        }
        return -1;
    }

    public static int findIndexOfQuesSign(String endpoint) {
        return PathAndReferenceUtility.indexOf((String)endpoint, (char)'?', (boolean)false, (boolean)true, (boolean)true);
    }

    public static List<String[]> getQueryVariables(String query) {
        if (query == null || query.isEmpty()) {
            return Collections.emptyList();
        }
        int pre1 = query.indexOf("{%#");
        int pre2 = query.indexOf("${");
        if (pre1 == -1 && pre2 == -1) {
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (String part : query.split("&")) {
                String[] pair = part.split("=");
                if (pair.length == 1 || StringUtils.isBlank((CharSequence)pair[0])) {
                    throw new RuntimeException("Invalid query parameter: " + part);
                }
                if (StringUtils.isBlank((CharSequence)pair[1])) {
                    pair[1] = EMPTY_QUERY_VALUE_POLICY.apply(pair[0]);
                }
                result.add(pair);
            }
            return result;
        }
        ArrayList<String[]> res = new ArrayList<String[]>();
        Stack<String> stack = new Stack<String>();
        int pointer = -1;
        int n = query.length();
        int start = 0;
        for (int i = 0; i < n; ++i) {
            String queryValue;
            String[] pair;
            if (stack.empty() && query.charAt(i) == '=') {
                pair = new String[2];
                pair[0] = query.substring(start, i);
                res.add(pair);
                ++pointer;
                start = i + 1;
                continue;
            }
            if (stack.empty() && query.charAt(i) == '&') {
                pair = (String[])res.get(pointer);
                queryValue = query.substring(start, i);
                pair[1] = StringUtils.isBlank((CharSequence)queryValue) ? EMPTY_QUERY_VALUE_POLICY.apply(pair[0]) : queryValue;
                start = i + 1;
                continue;
            }
            if (i + "{%#".length() < n && query.startsWith("{%#", i)) {
                stack.push("%}");
                i += "{%#".length() - 1;
                continue;
            }
            if (i + "${".length() < n && query.startsWith("${", i)) {
                stack.push("}");
                i += "${".length() - 1;
                continue;
            }
            if (i + "%}".length() < n && query.startsWith("%}", i)) {
                if (stack.empty() || !((String)stack.peek()).equals("%}")) continue;
                stack.pop();
                i += "%}".length() - 1;
                continue;
            }
            if (i + "}".length() < n && query.startsWith("}", i)) {
                if (stack.empty() || !((String)stack.peek()).equals("}")) continue;
                stack.pop();
                i += "}".length() - 1;
                continue;
            }
            if (i != n - 1) continue;
            pair = (String[])res.get(pointer);
            queryValue = query.substring(start);
            pair[1] = StringUtils.isBlank((CharSequence)queryValue) ? EMPTY_QUERY_VALUE_POLICY.apply(pair[0]) : queryValue;
            return res;
        }
        return res;
    }

    public static String bindExactlyPlace(String str, List<String> refs, String id) {
        int length = str.length();
        block0: for (int i = 0; i < length; ++i) {
            if (!str.startsWith("{%#", i)) continue;
            int sufIdx = str.indexOf("%}", i);
            if (sufIdx == -1) {
                return str;
            }
            int idx = str.indexOf("{%#", i);
            String part = str.substring(idx + "{%#".length() - 1, sufIdx);
            for (String ref : refs) {
                if (part.contains(ref)) continue;
                i = sufIdx + "%}".length() - 1;
                continue block0;
            }
            return str.substring(0, idx) + "{%" + id + "%}" + str.substring(sufIdx + "%}".length());
        }
        return str;
    }

    public static List<String> splitByDelimiter(String path, char delim) {
        return PathAndReferenceUtility.splitByDelimiter((String)path, (char)delim, (boolean)false, (boolean)false);
    }

    public static List<String> splitByDelimiter(String path, char delim, boolean hasBracket, boolean returnOpenedBracket) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        if (path.indexOf(delim) == -1) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        int pre1 = path.indexOf("{%#");
        int pre2 = path.indexOf("${");
        int pre3 = path.indexOf("['");
        if (pre1 == -1 && pre2 == -1 && pre3 == -1) {
            String[] split = path.split((PathAndReferenceUtility.isSpecialRegexChar((char)delim) ? "\\" : "") + delim);
            ArrayList<String> res = new ArrayList<String>();
            for (int i = 0; i < split.length; ++i) {
                String s = split[i];
                if (s.matches("\\[.*]")) {
                    if (res.isEmpty()) {
                        res.add(s);
                        continue;
                    }
                    res.set(i - 1, res.get(i - 1) + s);
                    continue;
                }
                res.add(s);
            }
            return res;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        int start = 0;
        Stack<String> stack = new Stack<String>();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            String val;
            List subParts;
            if (stack.empty() && path.charAt(i) == delim) {
                if (hasBracket) {
                    subParts = PathAndReferenceUtility.parseBracketNotationPath((String)path.substring(start, i));
                    if (subParts.size() > 1) {
                        res.addAll(subParts);
                    } else if (((String)subParts.get(0)).matches("\\[.*]")) {
                        if (!res.isEmpty()) {
                            res.set(res.size() - 1, (String)res.get(res.size() - 1) + (String)subParts.get(0));
                        } else {
                            res.add((String)subParts.get(0));
                        }
                    } else {
                        res.add((String)subParts.get(0));
                    }
                } else {
                    val = path.substring(start, i);
                    if (val.matches("\\[.*]")) {
                        if (!res.isEmpty()) {
                            res.set(res.size() - 1, (String)res.get(res.size() - 1) + val);
                        } else {
                            res.add(val);
                        }
                    } else {
                        res.add(val);
                    }
                }
                start = i + 1;
                continue;
            }
            if (i + "{%#".length() < n && path.startsWith("{%#", i)) {
                stack.push("%}");
                i += "{%#".length() - 1;
                continue;
            }
            if (i + "${".length() < n && path.startsWith("${", i)) {
                stack.push("}");
                i += "${".length() - 1;
                continue;
            }
            if (i + "['".length() < n && path.startsWith("['", i)) {
                stack.push("']");
                i += "['".length() - 1;
                continue;
            }
            if (i + "%}".length() < n && path.startsWith("%}", i)) {
                if (stack.empty() || !((String)stack.peek()).equals("%}")) continue;
                stack.pop();
                i += "%}".length() - 1;
                continue;
            }
            if (i + "}".length() < n && path.startsWith("}", i)) {
                if (stack.empty() || !((String)stack.peek()).equals("}")) continue;
                stack.pop();
                i += "}".length() - 1;
                continue;
            }
            if (i + "']".length() < n && path.startsWith("']", i)) {
                if (stack.isEmpty() || !((String)stack.peek()).equals("']")) continue;
                stack.pop();
                i += "']".length() - 1;
                continue;
            }
            if (i != n - 1) continue;
            if (hasBracket) {
                subParts = PathAndReferenceUtility.parseBracketNotationPath((String)path.substring(start));
                if (subParts.size() > 1) {
                    res.addAll(subParts);
                    continue;
                }
                if (((String)subParts.get(0)).matches("\\[.*]")) {
                    if (!res.isEmpty()) {
                        res.set(res.size() - 1, (String)res.get(res.size() - 1) + (String)subParts.get(0));
                        continue;
                    }
                    res.add((String)subParts.get(0));
                    continue;
                }
                res.add((String)subParts.get(0));
                continue;
            }
            val = path.substring(start);
            if (val.matches("\\[.*]")) {
                if (!res.isEmpty()) {
                    res.set(res.size() - 1, (String)res.get(res.size() - 1) + val);
                    continue;
                }
                res.add(val);
                continue;
            }
            res.add(val);
        }
        return returnOpenedBracket ? PathAndReferenceUtility.openWrappedBrackets(res) : res;
    }

    public static List<String> parseBracketNotationPath(String path) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        if (!path.contains("['")) {
            return Collections.singletonList(path);
        }
        int len = path.length();
        ArrayList<String> res = new ArrayList<String>();
        int start = -1;
        for (int i = 0; i < len; ++i) {
            if (i + "['".length() < len && path.startsWith("['", i)) {
                start = i;
                i += "['".length() - 1;
                continue;
            }
            if (i + "']".length() < len && path.startsWith("']", i) && start != -1) {
                res.add(path.substring(start, i + "']".length()));
                start = -1;
                i += "']".length() - 1;
                continue;
            }
            if (i != len - 1) continue;
            res.add(path.substring(start));
        }
        return res;
    }

    public static boolean startsWith(String path, String prefix) {
        if (path.startsWith("['") && path.endsWith("']")) {
            return path.startsWith("['" + prefix);
        }
        return path.startsWith(prefix);
    }

    private static boolean isSpecialRegexChar(char delim) {
        String specialChars = ".^$*+?()[]{}\\|/";
        return specialChars.indexOf(delim) != -1;
    }

    public static boolean isBody(String path) {
        return path != null && path.startsWith("body.$.");
    }

    public static boolean isHeader(String path) {
        return path != null && path.startsWith("header.$.");
    }

    public static String getActualPathOfBody(String path) {
        return path.substring(7);
    }

    public static String getHeaderParameterName(String path) {
        return path.substring(9);
    }

    public static String getPlaceTypeOfRef(String field) {
        return field == null ? null : (!field.matches("(body\\.\\$\\..+)|(header\\.\\$\\..+)|(path)") ? null : (field.equals("path") ? field : (PathAndReferenceUtility.isBody((String)field) ? "body" : (PathAndReferenceUtility.isHeader((String)field) ? "header" : null))));
    }

    public static String rebuildReference(String color, String type, String field) {
        return color + ".(" + type + ")" + (String)(field == null ? "" : "." + field);
    }

    private static List<String> openWrappedBrackets(List<String> parts) {
        return parts.stream().map(PathAndReferenceUtility::openWrappedBracket).toList();
    }

    private static String openWrappedBracket(String path) {
        return path.startsWith("['") && path.endsWith("']") ? path.substring("['".length(), path.length() - "']".length()) : path;
    }
}

