/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import com.becon.opencelium.backend.application.entity.AvailableUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PackageVersionManager {
    public static List<AvailableUpdate> getPackageVersions(Set<String> packageVersions, String currentVersion) {
        List<String> versions = packageVersions.stream().map(name -> name.replace("oc_", "").replace(".zip", "")).sorted(PackageVersionManager::compareVersions).toList();
        ArrayList<AvailableUpdate> packageVersionResources = new ArrayList<AvailableUpdate>();
        boolean foundHigherVersion = false;
        for (String version : versions) {
            String status;
            if (PackageVersionManager.compareVersions((String)version, (String)currentVersion) < 0) {
                status = "old";
            } else if (PackageVersionManager.compareVersions((String)version, (String)currentVersion) == 0) {
                status = "current";
            } else if (!foundHigherVersion) {
                status = "available";
                foundHigherVersion = true;
            } else {
                status = "not available";
            }
            packageVersionResources.add(new AvailableUpdate(version, status));
        }
        return packageVersionResources;
    }

    public static int compareVersions(String version1, String version2) {
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int v2;
            int v1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = v2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (v1 < v2) {
                return -1;
            }
            if (v1 <= v2) continue;
            return 1;
        }
        return 0;
    }

    public static List<Integer> parseVersion(String version) {
        return Arrays.stream(version.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
    }
}

