/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import org.springframework.http.MediaType;

public class MediaTypeUtility {
    public static boolean isJsonCompatible(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        return "application".equals(mediaType.getType()) && mediaType.getSubtype().contains("json");
    }

    public static boolean isXmlCompatible(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        return ("application".equals(mediaType.getType()) || "text".equals(mediaType.getType())) && mediaType.getSubtype().contains("xml");
    }

    public static boolean isTextPlainCompatible(MediaType mediaType) {
        return MediaType.TEXT_PLAIN.isCompatibleWith(mediaType);
    }

    public static boolean isFormUrlencodedCompatible(MediaType mediaType) {
        return MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType);
    }

    public static boolean isBinaryCompatible(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        String type = mediaType.getType();
        String subtype = mediaType.getSubtype();
        return MediaType.APPLICATION_OCTET_STREAM.includes(mediaType) || "image".equalsIgnoreCase(type) || "video".equalsIgnoreCase(type) || "audio".equalsIgnoreCase(type) || subtype.contains("pdf") || subtype.contains("zip") || subtype.contains("msword") || subtype.contains("officedocument");
    }
}

