/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.utility;

import com.becon.opencelium.backend.commons.FileDescriptor;
import com.becon.opencelium.backend.constant.LogConstant;
import com.becon.opencelium.backend.exception.GeneralServiceException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogFileUtility {
    private static final Logger logger = LoggerFactory.getLogger(LogFileUtility.class);

    public static Path toPath(String base, String ... sub) {
        Path path = Paths.get(base, sub);
        return path.isAbsolute() ? path : Paths.get(System.getProperty("user.dir"), new String[0]).resolve(path).normalize();
    }

    public static String toFilename(String timestamp, long connectionId, String type, long executionId, String extension) {
        return timestamp + "_" + connectionId + "_" + type + "_" + executionId + "." + extension;
    }

    public static void create(String base) throws IOException {
        Path directory = LogFileUtility.toPath((String)base, (String[])new String[0]);
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    public static void enforceLimit(String base, Long connectionId, String type, int limit) {
        Path connectionFilesFolder = LogFileUtility.toPath((String)base, (String[])new String[]{connectionId.toString()});
        try (Stream<Path> stream = Files.list(connectionFilesFolder);){
            List<Path> matchingDirs = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().contains(connectionId + "_" + type)).sorted((p1, p2) -> {
                LocalDateTime time1 = LogFileUtility.extractTime((Path)p1);
                LocalDateTime time2 = LogFileUtility.extractTime((Path)p2);
                return time1.compareTo(time2);
            }).toList();
            for (int i = 0; i < matchingDirs.size() - limit; ++i) {
                LogFileUtility.delete((Path)matchingDirs.get(i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void move(Long connectionId, long executionId, String timestamp, String type, int fileLimit) {
        Path sourcePath = LogFileUtility.toPath((String)"./logs", (String[])new String[]{LogFileUtility.toFilename((String)timestamp, (long)connectionId, (String)"u", (long)executionId, (String)"log")});
        Path destinationPath = LogFileUtility.toPath((String)"./logs", (String[])new String[]{connectionId.toString(), LogFileUtility.toFilename((String)timestamp, (long)connectionId, (String)type, (long)executionId, (String)"log")});
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
            Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            LogFileUtility.enforceLimit((String)"./logs", (Long)connectionId, (String)type, (int)fileLimit);
        }
    }

    public static void delete(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public static void deleteByExecutionId(long executionId) {
        Path logFolder = LogFileUtility.toPath((String)"./logs", (String[])new String[0]);
        try (Stream<Path> stream = Files.walk(logFolder, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                int end;
                String filename = p.getFileName().toString();
                if (!filename.matches(".+_.+_.+_.+_\\d+\\.log")) {
                    return false;
                }
                int start = filename.lastIndexOf(95);
                long fileExecutionId = Long.parseLong(filename.substring(start + 1, end = filename.lastIndexOf(46)));
                return fileExecutionId == executionId;
            }).forEach(p -> {
                try {
                    Files.deleteIfExists(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            logger.warn("Failed to delete old log files by executionId", (Throwable)e);
        }
    }

    public static FileDescriptor getLogFile(Long executionId) {
        FileDescriptor fileDescriptor;
        block8: {
            Path logFolder = LogFileUtility.toPath((String)"./logs", (String[])new String[0]);
            Stream<Path> stream = Files.walk(logFolder, FileVisitOption.FOLLOW_LINKS);
            try {
                fileDescriptor = stream.filter(x -> x.getFileName().toString().matches(".+_.+_.+_.+_\\d+\\.log") && x.getFileName().toString().endsWith("%d.log".formatted(executionId))).findFirst().map(LogFileUtility::readFile).orElseThrow(() -> new GeneralServiceException("LOG_NOT_FOUND", "Log not found for execution: %d".formatted(executionId)));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GeneralServiceException(HttpStatus.INTERNAL_SERVER_ERROR, "INTERNAL_ERROR", "Unknown error");
                }
            }
            stream.close();
        }
        return fileDescriptor;
    }

    public static List<String> getLogFileNameList(Long connectionId) {
        List<String> list;
        block8: {
            Path logFolder = LogFileUtility.toPath((String)("./logs/" + connectionId), (String[])new String[0]);
            Stream<Path> stream = Files.list(logFolder);
            try {
                list = stream.map(path -> path.getFileName().toString()).filter(name -> name.matches(".+_.+_.+_.+_\\d+\\.log")).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error while reading log files from folder: {}", (Object)logFolder, (Object)e);
                    throw new GeneralServiceException(HttpStatus.INTERNAL_SERVER_ERROR, "INTERNAL_ERROR", "Unknown error");
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<String> getLogFileNameList(Long connectionId, int schedulerId, String status) {
        List<String> list;
        block8: {
            Path logFolder = LogFileUtility.toPath((String)("./logs/" + connectionId), (String[])new String[0]);
            Stream<Path> stream = Files.list(logFolder);
            try {
                list = stream.filter(path -> path.getFileName().toString().matches(".+_.+_.+_.+_\\d+\\.log")).filter(path -> status == null || path.getFileName().toString().contains(status)).filter(path -> LogFileUtility.executedByScheduler((Path)path, (int)schedulerId)).map(path -> path.getFileName().toString()).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error while reading log files from folder: {}", (Object)logFolder, (Object)e);
                    throw new GeneralServiceException(HttpStatus.INTERNAL_SERVER_ERROR, "INTERNAL_ERROR", "Unknown error");
                }
            }
            stream.close();
        }
        return list;
    }

    private static FileDescriptor readFile(Path path) {
        FileDescriptor fileDescriptor;
        FileInputStream in = new FileInputStream(path.toFile());
        try {
            fileDescriptor = FileDescriptor.of((byte[])((InputStream)in).readAllBytes(), (String)path.getFileName().toString(), (String)"application/octet-stream");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GeneralServiceException(HttpStatus.INTERNAL_SERVER_ERROR, "INTERNAL_ERROR", "Unknown error");
            }
        }
        ((InputStream)in).close();
        return fileDescriptor;
    }

    private static LocalDateTime extractTime(Path path) {
        String filename = path.getFileName().toString();
        try {
            String timestamp = filename.substring(0, 16);
            return LocalDateTime.parse(timestamp, LogConstant.DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return LocalDateTime.MIN;
        }
    }

    public static String extractExecutionId(String fileName) {
        if (fileName == null || !fileName.endsWith(".log")) {
            throw new IllegalArgumentException("Invalid log file name: " + fileName);
        }
        String withoutExt = fileName.substring(0, fileName.length() - 4);
        String[] parts = withoutExt.split("_");
        return parts[parts.length - 1];
    }

    private static boolean executedByScheduler(Path path, int schedulerId) {
        boolean bl;
        block9: {
            if (schedulerId == -1) {
                return true;
            }
            String token = "schedulerId=" + schedulerId;
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                String firstLine = reader.readLine();
                boolean bl2 = bl = firstLine != null && firstLine.contains(token);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }
}

