/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.subscription.quartz;

import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class QuartzCronUpdater {
    private final Scheduler scheduler;

    public QuartzCronUpdater(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void updateCronExpression(String triggerName, String triggerGroup, String newCronExpression) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroup);
            CronTrigger oldTrigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (oldTrigger == null) {
                System.out.println("Trigger not found with key: " + triggerKey);
                return;
            }
            if (oldTrigger.getCronExpression().equals(newCronExpression)) {
                System.out.println("Cron expression is already set to the new value.");
                return;
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)newCronExpression);
            TriggerBuilder triggerBuilder = oldTrigger.getTriggerBuilder();
            CronTrigger newTrigger = (CronTrigger)triggerBuilder.withSchedule((ScheduleBuilder)scheduleBuilder).build();
            Date rescheduledDate = this.scheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
            System.out.println("Cron expression updated to: " + newCronExpression + ", rescheduled at: " + rescheduledDate);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

