/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.subscription.quartz;

import com.becon.opencelium.backend.api.ApiClient;
import com.becon.opencelium.backend.api.ApiType;
import com.becon.opencelium.backend.api.factory.ApiFactory;
import com.becon.opencelium.backend.api.module.ReportModule;
import com.becon.opencelium.backend.api.serviceportal.ServicePortal;
import com.becon.opencelium.backend.database.mysql.service.OperationUsageHistoryService;
import com.becon.opencelium.backend.subscription.dto.UsageHistoryDto;
import java.util.List;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class OperationUsageReportJob
extends QuartzJobBean {
    private final OperationUsageHistoryService operationUsageHistoryService;
    private final ApiFactory apiFactory;

    public OperationUsageReportJob(@Qualifier(value="operationUsageHistoryServiceImpl") OperationUsageHistoryService operationUsageHistoryService, ApiFactory apiFactory) {
        this.operationUsageHistoryService = operationUsageHistoryService;
        this.apiFactory = apiFactory;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        ApiClient servicePortal = this.apiFactory.get(ApiType.SERVICE_PORTAL);
        ReportModule reportModule = ((ServicePortal)servicePortal.features()).operationUsage();
        List<UsageHistoryDto> usageHistoryDtoList = this.operationUsageHistoryService.findAll().stream().map(UsageHistoryDto::new).toList();
        if (usageHistoryDtoList.isEmpty()) {
            return;
        }
        Map<String, List<UsageHistoryDto>> request = Map.of("records", usageHistoryDtoList);
        try {
            reportModule.sendReport(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

