/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.security;

import com.becon.opencelium.backend.database.mysql.entity.Session;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.execution.socket.Event;
import com.becon.opencelium.backend.resource.error.ErrorResource;
import com.becon.opencelium.backend.resource.user.TotpResource;
import com.becon.opencelium.backend.resource.user.UserResource;
import com.becon.opencelium.backend.security.AuthenticationFilter;
import com.becon.opencelium.backend.security.UserPrincipals;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Component
public class TotpAuthenticationFilter
extends AuthenticationFilter {
    private static final String SESSION_ID = "com.becon.opencelium.backend.security.session_id";

    public TotpAuthenticationFilter() {
        this.setFilterProcessesUrl("/totp-validate");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (!request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        try {
            TotpResource dto = (TotpResource)new ObjectMapper().readValue((InputStream)request.getInputStream(), TotpResource.class);
            String sessionId = dto.getSessionId();
            request.setAttribute(SESSION_ID, (Object)sessionId);
            Session session = (Session)this.sessionService.findById(sessionId).orElseThrow(() -> new AuthenticationServiceException("Invalid 'session_id' has been supplied."));
            if (!session.isActive()) {
                throw new AuthenticationServiceException("Inactive 'session_id' has been supplied.");
            }
            User user = session.getUser();
            String code = dto.getCode();
            if (session.getAttempts() < 4 && this.totpService.isValidTotp(user.getTotpSecretKey(), code)) {
                UserPrincipals userDetails = new UserPrincipals(user);
                return new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            }
            throw new AuthenticationServiceException("Invalid TOTP 'code' has been supplied.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication auth) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        User user = ((UserPrincipals)auth.getPrincipal()).getUser();
        UserResource userResource = new UserResource(user);
        if (!user.isTotpProcessCompleted()) {
            user.setTotpProcessCompleted(true);
            this.userService.save(user);
        }
        String payload = mapper.writeValueAsString((Object)userResource);
        String token = this.jwtTokenUtil.generateToken(user);
        response.setContentType("application/json");
        response.getWriter().write(payload);
        response.addHeader("Authorization", "Bearer " + token);
        this.messagingTemplate.convertAndSendToUser(user.getPrincipal(), "/session", (Object)Event.of((String)"FORCE_LOGOUT", (String)"New login detected"));
        this.sendSubscriptionNotification();
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        URI uri = ServletUriComponentsBuilder.fromCurrentRequest().build().toUri();
        ObjectMapper mapper = new ObjectMapper();
        String sessionId = (String)request.getAttribute(SESSION_ID);
        Optional optionalSession = this.sessionService.findById(sessionId);
        response.setContentType("application/json");
        ErrorResource errorResource = new ErrorResource((Exception)failed, HttpStatus.UNAUTHORIZED, uri.getPath());
        if (optionalSession.isEmpty()) {
            errorResource.setMessage("Invalid 'session_id' has been supplied");
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        } else if (((Session)optionalSession.get()).getAttempts() < 4) {
            Session session = (Session)optionalSession.get();
            session.setAttempts(session.getAttempts() + 1);
            this.sessionService.save(session);
            errorResource.setMessage(String.format("'session_id' or 'code' did not match. You have %d attempts remaining.", 5 - session.getAttempts()));
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        } else {
            errorResource.setMessage("Too many failed attempts");
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
        }
        String payload = mapper.writeValueAsString((Object)errorResource);
        response.getWriter().write(payload);
    }
}

