/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.security;

import com.becon.opencelium.backend.database.mysql.entity.Session;
import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.utility.TokenUtility;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Date;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenUtil {
    @Autowired
    private TokenUtility tokenUtility;

    public String extractPrincipal(String token) {
        return (String)this.getClaimFromToken(token, JWTClaimsSet::getSubject);
    }

    public String extractSessionId(String token) {
        return (String)this.getClaimFromToken(token, JWTClaimsSet::getJWTID);
    }

    public int extractUserId(String token) {
        String userId = this.getClaim(token, "userId").toString();
        return Integer.parseInt(userId);
    }

    public Date extractExpirationDate(String token) {
        return (Date)this.getClaimFromToken(token, JWTClaimsSet::getExpirationTime);
    }

    public <T> T getClaimFromToken(String token, Function<JWTClaimsSet, T> claimsResolver) {
        JWTClaimsSet claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    public String generateToken(User user) {
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().claim("userId", (Object)user.getId()).claim("role", (Object)user.getUserRole().getName()).claim("sessionTime", (Object)this.tokenUtility.getActivityTime()).expirationTime(new Date(System.currentTimeMillis() + this.tokenUtility.getExpirationTime() * 1000L)).issueTime(new Date(System.currentTimeMillis())).subject(user.getPrincipal()).jwtID(user.getSession().getId()).build();
        return this.generateToken(claimsSet);
    }

    public Boolean validateToken(String token, User user) throws Exception {
        MACVerifier verifier;
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        if (!signedJWT.verify((JWSVerifier)(verifier = new MACVerifier(this.tokenUtility.getSecret())))) {
            return false;
        }
        Session session = user.getSession();
        if (session == null || !session.isActive()) {
            return false;
        }
        long inactiveTime = new Date().getTime() - session.getLastAccessed().getTime();
        if (inactiveTime > this.tokenUtility.getActivityTime()) {
            return false;
        }
        String sessionId = this.extractSessionId(token);
        return this.isNotExpired(token) != false && sessionId.equals(session.getId());
    }

    public JWTClaimsSet getAllClaimsFromToken(String token) {
        try {
            return SignedJWT.parse((String)token).getJWTClaimsSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String generateToken(JWTClaimsSet claims) {
        try {
            MACSigner signer = new MACSigner(this.tokenUtility.getSecret());
            SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claims);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object getClaim(String token, String name) {
        JWTClaimsSet claims = this.getAllClaimsFromToken(token);
        return claims.getClaim(name);
    }

    private Boolean isNotExpired(String token) {
        Date expiration = this.extractExpirationDate(token);
        return expiration.after(new Date());
    }
}

