/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.security;

import com.becon.opencelium.backend.database.mysql.entity.User;
import com.becon.opencelium.backend.database.mysql.service.SessionServiceImpl;
import com.becon.opencelium.backend.database.mysql.service.UserService;
import com.becon.opencelium.backend.security.JwtTokenUtil;
import com.becon.opencelium.backend.security.UserPrincipals;
import com.becon.opencelium.backend.utility.EmailUtility;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AuthorizationFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtTokenUtil jwtTokenUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private SessionServiceImpl sessionService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url = request.getRequestURI();
        System.out.println(url);
        String token = AuthorizationFilter.extractTokenFromRequest((HttpServletRequest)request);
        if (token == null || !token.startsWith("Bearer")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String jwt = token.substring(7);
        UsernamePasswordAuthenticationToken auth = this.getAuthentication(jwt);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void disableCrosOrigin(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "ACL, CANCELUPLOAD, CHECKIN, CHECKOUT, COPY, DELETE, GET, HEAD, LOCK, MKCALENDAR, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, REPORT, SEARCH, UNCHECKOUT, UNLOCK, UPDATE, VERSION-CONTROL");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Key, Authorization");
        response.setHeader("Content-Type", "application/json");
    }

    private static String extractTokenFromRequest(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token == null) {
            return request.getParameter("token");
        }
        return token;
    }

    private UsernamePasswordAuthenticationToken getAuthentication(String token) {
        String principal = this.jwtTokenUtil.extractPrincipal(token);
        String sessionId = this.jwtTokenUtil.extractSessionId(token);
        Optional optionalUser = EmailUtility.isEmail((String)principal) ? this.userService.findByEmail(principal) : this.userService.findByUsername(principal);
        User user = (User)optionalUser.orElseThrow(() -> new UsernameNotFoundException(principal));
        try {
            if (!this.jwtTokenUtil.validateToken(token, user).booleanValue()) {
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.sessionService.updateLastAccessedTime(sessionId);
        UserPrincipals userDetail = new UserPrincipals(user);
        return new UsernamePasswordAuthenticationToken((Object)userDetail, null, userDetail.getAuthorities());
    }
}

