/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.scriptengine.external.polyglotservice;

import com.becon.opencelium.backend.constant.props.PolyglotProps;
import com.becon.opencelium.backend.proto.ExternalConsumerGrpc;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.health.v1.HealthGrpc;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GrpcClientConnectConfigurer {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientConnectConfigurer.class);
    private volatile ManagedChannel managedChannel;
    private final PolyglotProps polyglotProps;
    private final Object lock = new Object();

    public GrpcClientConnectConfigurer(PolyglotProps polyglotProps) {
        this.polyglotProps = polyglotProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedChannel getOrCreateChannel() {
        if (!this.polyglotProps.isEnabled() || !Objects.equals(this.polyglotProps.getProtocol(), "grpc")) {
            throw new IllegalStateException("Polyglot service is not enabled or not configured for gRPC");
        }
        if (this.shouldRecreateChannel()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shouldRecreateChannel()) {
                    this.closeExistingChannel();
                    try {
                        this.managedChannel = this.createChannel();
                        log.info("Created new gRPC channel to {}:{}", (Object)this.polyglotProps.getHost(), (Object)this.polyglotProps.getPort());
                    }
                    catch (Exception e) {
                        log.error("Failed to create gRPC channel to {}:{}", new Object[]{this.polyglotProps.getHost(), this.polyglotProps.getPort(), e});
                        this.managedChannel = null;
                    }
                }
            }
        }
        return this.managedChannel;
    }

    private boolean shouldRecreateChannel() {
        boolean isUnhealthy;
        if (this.managedChannel == null) {
            return true;
        }
        ConnectivityState state = this.managedChannel.getState(false);
        boolean bl = isUnhealthy = state == ConnectivityState.SHUTDOWN || state == ConnectivityState.TRANSIENT_FAILURE;
        if (isUnhealthy) {
            log.warn("Channel in unhealthy state: {}, will recreate", (Object)state);
        }
        return this.managedChannel.isShutdown() || this.managedChannel.isTerminated() || isUnhealthy;
    }

    private void closeExistingChannel() {
        if (this.managedChannel != null && !this.managedChannel.isShutdown()) {
            try {
                this.managedChannel.shutdown();
                if (!this.managedChannel.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.managedChannel.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.managedChannel.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private ManagedChannel createChannel() {
        return ManagedChannelBuilder.forAddress((String)this.polyglotProps.getHost(), (int)this.polyglotProps.getPort()).usePlaintext().enableRetry().maxRetryAttempts(3).keepAliveTime(2L, TimeUnit.MINUTES).keepAliveTimeout(20L, TimeUnit.SECONDS).keepAliveWithoutCalls(false).idleTimeout(10L, TimeUnit.MINUTES).build();
    }

    public ExternalConsumerGrpc.ExternalConsumerBlockingStub getBlockingStub() {
        return ExternalConsumerGrpc.newBlockingStub((Channel)this.getOrCreateChannel());
    }

    public HealthGrpc.HealthBlockingStub getHealthStub() {
        return HealthGrpc.newBlockingStub((Channel)this.getOrCreateChannel());
    }

    public boolean isEnabled() {
        return this.polyglotProps.isEnabled() && Objects.equals(this.polyglotProps.getProtocol(), "grpc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChannel() {
        Object object = this.lock;
        synchronized (object) {
            log.info("Force resetting gRPC channel");
            this.closeExistingChannel();
            this.managedChannel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.closeExistingChannel();
            log.info("gRPC channel shut down");
        }
    }
}

