/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.scriptengine.engines;

import com.becon.opencelium.backend.scriptengine.Language;
import com.becon.opencelium.backend.scriptengine.LanguageType;
import com.becon.opencelium.backend.scriptengine.ScriptEngine;
import com.becon.opencelium.backend.scriptengine.ScriptEngineType;
import com.becon.opencelium.backend.scriptengine.ex.InvalidScriptException;
import com.becon.opencelium.backend.scriptengine.ex.ScriptExecutionException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Compilable;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openjdk.nashorn.api.scripting.JSObject;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.springframework.stereotype.Component;

@Component
public class NashornEngine
implements ScriptEngine {
    private static final Pattern arrayPattern = Pattern.compile("\\[(.*?)]", 8);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ScriptEngineManager engineManager = new ScriptEngineManager();
    private final Compilable compilable = this.initCompilatorEngine();

    public boolean supports(Language lang) {
        return lang != null && lang.getLanguage() == LanguageType.JS && lang.getEngine() == ScriptEngineType.NASHORN;
    }

    public Object execute(String script) throws ScriptExecutionException, InvalidScriptException {
        return this.execute(script, null);
    }

    public Object execute(String script, Map<String, Object> bindings) throws ScriptExecutionException, InvalidScriptException {
        try {
            javax.script.ScriptEngine engine = this.engineManager.getEngineByName("nashorn");
            this.bindArgs(engine, bindings);
            Object result = this.evaluate(engine, script);
            return this.translateResult(result, engine);
        }
        catch (InvalidScriptException | ScriptExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptExecutionException("Unknown error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object execute(String script, Map<String, String> bindings, Function<String, Object> referenceExtractor) throws ScriptExecutionException, InvalidScriptException {
        try {
            javax.script.ScriptEngine engine = this.engineManager.getEngineByName("nashorn");
            this.bindArgs(engine, bindings, referenceExtractor);
            Object result = this.evaluate(engine, script);
            return this.translateResult(result, engine);
        }
        catch (InvalidScriptException | ScriptExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptExecutionException("Unknown error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void validate(String script) throws InvalidScriptException {
        if (this.compilable == null) {
            return;
        }
        try {
            this.compilable.compile(script);
        }
        catch (ScriptException e) {
            throw new InvalidScriptException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidScriptException("Invalid script '" + script + "'", (Throwable)e);
        }
    }

    public boolean isUp() {
        return true;
    }

    private String stringify(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new ScriptExecutionException("Unknown error", (Throwable)e);
        }
    }

    private Object evaluate(javax.script.ScriptEngine engine, String code) {
        try {
            return engine.eval(code);
        }
        catch (ScriptException e) {
            throw new ScriptExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ScriptExecutionException("Unknown error : " + e.getMessage(), (Throwable)e);
        }
    }

    private void bindArgs(javax.script.ScriptEngine engine, Map<String, String> args, Function<String, Object> referenceExtractor) {
        Map<String, Object> resultMap = args.entrySet().stream().map(entry -> {
            try {
                Object value = referenceExtractor.apply((String)entry.getValue());
                return Map.entry((String)entry.getKey(), value);
            }
            catch (Exception e) {
                throw new ScriptExecutionException("Reference extracting error: " + e.getMessage(), (Throwable)e);
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.bindArgs(engine, resultMap);
    }

    private void bindArgs(javax.script.ScriptEngine engine, Map<String, Object> bindings) {
        if (bindings != null && !bindings.isEmpty()) {
            bindings.forEach((varName, value) -> {
                if (value instanceof Map || value instanceof List) {
                    String stringVal = this.stringify(value);
                    stringVal = stringVal.replace("__oc__attributes.", "@").replace(".__oc__value", "");
                    engine.put("dataModel", stringVal);
                    JSObject obj = (JSObject)this.evaluate(engine, "JSON.parse(dataModel)");
                    engine.put((String)varName, obj);
                } else {
                    engine.put((String)varName, value);
                }
            });
        }
    }

    private Object translateResult(Object result, javax.script.ScriptEngine engine) {
        boolean isPrimitive;
        boolean bl = isPrimitive = result instanceof Number || result instanceof String || result instanceof Boolean;
        if (result == null || isPrimitive) {
            return result;
        }
        boolean isArray = ((ScriptObjectMirror)result).isArray();
        ScriptObjectMirror JSON = (ScriptObjectMirror)this.evaluate(engine, "JSON");
        String stringifiedResult = JSON.callMember("stringify", new Object[]{result}).toString();
        try {
            if (isArray) {
                if (!arrayPattern.matcher(stringifiedResult).matches()) {
                    throw new ScriptExecutionException("Invalid array result: " + stringifiedResult);
                }
                return this.mapper.readValue(stringifiedResult, List.class);
            }
            return this.mapper.readValue(stringifiedResult, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonProcessingException e) {
            throw new ScriptExecutionException("Cannot read a result of nashorn: " + stringifiedResult, (Throwable)e);
        }
    }

    private Compilable initCompilatorEngine() {
        Compilable comp;
        javax.script.ScriptEngine engine = this.engineManager.getEngineByName("nashorn");
        return engine instanceof Compilable ? (comp = (Compilable)((Object)engine)) : null;
    }
}

