/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.scriptengine;

import com.becon.opencelium.backend.scriptengine.Language;
import com.becon.opencelium.backend.scriptengine.ScriptEngine;
import com.becon.opencelium.backend.scriptengine.engines.NashornEngine;
import com.becon.opencelium.backend.scriptengine.engines.PolyglotEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Component;

@Component
public class ScriptEngineProvider {
    private final List<ObjectProvider<? extends ScriptEngine>> engineProviders;

    public ScriptEngineProvider(ObjectProvider<PolyglotEngine> polyglotEngineProvider, ObjectProvider<NashornEngine> nashornEngineProvider) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(polyglotEngineProvider);
        providers.add(nashornEngineProvider);
        this.engineProviders = Collections.unmodifiableList(providers);
    }

    public Optional<ScriptEngine> provide(Language lang) {
        return this.engineProviders.stream().map(ObjectFactory::getObject).filter(engine -> engine.supports(lang)).findFirst().map(engine -> engine);
    }
}

