/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.subs;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;

public class PaginatedDto<T, D> {
    private List<D> content;
    private int currentPage;
    private int totalPages;
    private long totalItems;

    public PaginatedDto(Page<T> page, Function<T, D> converter) {
        this.content = page.getContent().stream().map(converter).collect(Collectors.toList());
        this.currentPage = page.getNumber();
        this.totalPages = page.getTotalPages();
        this.totalItems = page.getTotalElements();
    }

    public List<D> getContent() {
        return this.content;
    }

    public void setContent(List<D> content) {
        this.content = content;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(long totalItems) {
        this.totalItems = totalItems;
    }
}

