/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.notification;

import com.becon.opencelium.backend.database.mysql.entity.EventNotification;
import com.becon.opencelium.backend.database.mysql.entity.EventRecipient;
import com.becon.opencelium.backend.resource.notification.TemplateMessageResource;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Resource
public class NotificationResource {
    private int notificationId;
    private int schedulerId;
    private String name;
    private String eventType;
    private String notificationType;
    private TemplateMessageResource template;
    private List<String> recipients = new ArrayList();
    private String team;
    private String channel;

    public NotificationResource(EventNotification eventNotification) {
        this.notificationId = eventNotification.getId();
        this.name = eventNotification.getName();
        this.eventType = eventNotification.getEventType();
        this.schedulerId = eventNotification.getScheduler().getId();
        this.notificationType = eventNotification.getEventMessage().getType();
        this.template = new TemplateMessageResource(eventNotification.getEventMessage().getId(), eventNotification.getEventMessage().getName());
        this.recipients = eventNotification.getEventRecipients().stream().map(EventRecipient::getDestination).collect(Collectors.toList());
    }

    public NotificationResource() {
    }

    public int getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(int notificationId) {
        this.notificationId = notificationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public int getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(int schedulerId) {
        this.schedulerId = schedulerId;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public TemplateMessageResource getTemplate() {
        return this.template;
    }

    public void setTemplate(int id, String name) {
        this.template = new TemplateMessageResource(id, name);
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }
}

