/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.execution;

import com.becon.opencelium.backend.enums.execution.DataType;
import com.becon.opencelium.backend.enums.execution.ParamLocation;
import com.becon.opencelium.backend.enums.execution.ParamStyle;
import com.becon.opencelium.backend.resource.execution.ParameterDTO;
import com.becon.opencelium.backend.resource.execution.ParameterDTOUtil;
import com.becon.opencelium.backend.resource.execution.SchemaDTO;
import com.becon.opencelium.backend.resource.execution.SchemaDTOUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParameterDTOUtil {
    public static ParameterDTO copy(ParameterDTO parameter) {
        ParameterDTO result = new ParameterDTO();
        result.setName(parameter.getName());
        result.setIn(parameter.getIn());
        result.setStyle(parameter.getStyle());
        result.setExplode(parameter.isExplode());
        result.setContent(parameter.getContent());
        result.setSchema(SchemaDTOUtil.copy((SchemaDTO)parameter.getSchema()));
        return result;
    }

    public static String toString(ParameterDTO parameter) {
        if (parameter == null) {
            return null;
        }
        if (parameter.getStyle() == null) {
            throw new IllegalArgumentException("Param style must be supplied to ParameterDTO, parameter.name = " + parameter.getName());
        }
        return switch (1.$SwitchMap$com$becon$opencelium$backend$enums$execution$ParamStyle[parameter.getStyle().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> ParameterDTOUtil.constructMatrix((ParameterDTO)parameter);
            case 2 -> ParameterDTOUtil.constructLabel((ParameterDTO)parameter);
            case 3 -> ParameterDTOUtil.constructForm((ParameterDTO)parameter);
            case 4 -> ParameterDTOUtil.constructSimple((ParameterDTO)parameter);
            case 5 -> ParameterDTOUtil.constructSpaceDelimited((ParameterDTO)parameter);
            case 6 -> ParameterDTOUtil.constructPipeDelimited((ParameterDTO)parameter);
            case 7 -> ParameterDTOUtil.constructDeepObject((ParameterDTO)parameter);
        };
    }

    private static String constructMatrix(ParameterDTO parameter) {
        ParameterDTOUtil.validateParamStyleAndLocationsPair((String)parameter.getName(), (ParamStyle)ParamStyle.MATRIX, (ParamLocation)parameter.getIn(), List.of(ParamLocation.PATH));
        SchemaDTO schema = parameter.getSchema();
        if (schema.getType() == DataType.OBJECT) {
            Map properties = schema.getProperties();
            if (CollectionUtils.isEmpty((Map)properties)) {
                return ";" + parameter.getName();
            }
            String separator = parameter.isExplode() ? "=" : ",";
            String delimiter = parameter.isExplode() ? ";" : ",";
            String prefix = parameter.isExplode() ? ";" : ";" + parameter.getName() + "=";
            return ParameterDTOUtil.mapToString((Map)properties, (String)prefix, (String)separator, (String)delimiter);
        }
        if (schema.getType() == DataType.ARRAY) {
            List items = schema.getItems();
            if (CollectionUtils.isEmpty((Collection)items)) {
                return ";" + parameter.getName();
            }
            String delimiter = parameter.isExplode() ? ";" + parameter.getName() + "=" : ",";
            String prefix = ";" + parameter.getName() + "=";
            return ParameterDTOUtil.listToString((List)items, (String)prefix, (String)delimiter);
        }
        String value = schema.getValue();
        return ObjectUtils.isEmpty((Object)value) ? ";" + parameter.getName() : ";" + parameter.getName() + "=" + value;
    }

    private static String constructLabel(ParameterDTO parameter) {
        ParameterDTOUtil.validateParamStyleAndLocationsPair((String)parameter.getName(), (ParamStyle)ParamStyle.LABEL, (ParamLocation)parameter.getIn(), List.of(ParamLocation.PATH));
        SchemaDTO schema = parameter.getSchema();
        String prefix = ".";
        if (schema.getType() == DataType.OBJECT) {
            Map properties = schema.getProperties();
            if (CollectionUtils.isEmpty((Map)properties)) {
                return ".";
            }
            String separator = parameter.isExplode() ? "=" : ".";
            return ParameterDTOUtil.mapToString((Map)properties, (String)".", (String)separator, (String)".");
        }
        if (schema.getType() == DataType.ARRAY) {
            List items = schema.getItems();
            if (CollectionUtils.isEmpty((Collection)items)) {
                return ".";
            }
            return ParameterDTOUtil.listToString((List)items, (String)".", (String)".");
        }
        String value = schema.getValue();
        return ObjectUtils.isEmpty((Object)value) ? "." : "." + value;
    }

    private static String constructForm(ParameterDTO parameter) {
        ParameterDTOUtil.validateParamStyleAndLocationsPair((String)parameter.getName(), (ParamStyle)ParamStyle.FORM, (ParamLocation)parameter.getIn(), List.of(ParamLocation.QUERY, ParamLocation.COOKIE));
        SchemaDTO schema = parameter.getSchema();
        if (schema.getType() == DataType.OBJECT) {
            Map properties = schema.getProperties();
            if (CollectionUtils.isEmpty((Map)properties)) {
                return parameter.getName() + "=";
            }
            String separator = parameter.isExplode() ? "=" : ",";
            String delimiter = parameter.isExplode() ? "&" : ",";
            String prefix = parameter.isExplode() ? "" : parameter.getName() + "=";
            return ParameterDTOUtil.mapToString((Map)properties, (String)prefix, (String)separator, (String)delimiter);
        }
        if (schema.getType() == DataType.ARRAY) {
            List items = schema.getItems();
            if (CollectionUtils.isEmpty((Collection)items)) {
                return parameter.getName() + "=";
            }
            String delimiter = parameter.isExplode() ? "&" + parameter.getName() + "=" : ",";
            String prefix = parameter.getName() + "=";
            return ParameterDTOUtil.listToString((List)items, (String)prefix, (String)delimiter);
        }
        String value = schema.getValue();
        return ObjectUtils.isEmpty((Object)value) ? parameter.getName() + "=" : parameter.getName() + "=" + value;
    }

    private static String constructSimple(ParameterDTO parameter) {
        ParameterDTOUtil.validateParamStyleAndLocationsPair((String)parameter.getName(), (ParamStyle)ParamStyle.SIMPLE, (ParamLocation)parameter.getIn(), List.of(ParamLocation.PATH, ParamLocation.HEADER));
        SchemaDTO schema = parameter.getSchema();
        if (schema.getType() == DataType.OBJECT) {
            Map properties = schema.getProperties();
            ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)CollectionUtils.isEmpty((Map)properties), (String)"properties", (Object)properties);
            String separator = parameter.isExplode() ? "=" : ",";
            return ParameterDTOUtil.mapToString((Map)properties, (String)"", (String)separator, (String)",");
        }
        if (schema.getType() == DataType.ARRAY) {
            List items = schema.getItems();
            ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)CollectionUtils.isEmpty((Collection)items), (String)"items", (Object)items);
            return ParameterDTOUtil.listToString((List)items, (String)"", (String)",");
        }
        String value = schema.getValue();
        ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)ObjectUtils.isEmpty((Object)value), (String)"value", (Object)value);
        return value;
    }

    private static String constructSpaceDelimited(ParameterDTO parameter) {
        ParameterDTOUtil.validateParamStyleAndLocationsPair((String)parameter.getName(), (ParamStyle)ParamStyle.SPACE_DELIMITED, (ParamLocation)parameter.getIn(), List.of(ParamLocation.QUERY));
        if (parameter.isExplode()) {
            throw new IllegalArgumentException("For parameter.name = '" + parameter.getName() + "' with type = '" + ParamStyle.SPACE_DELIMITED.getStyle() + "' explode must be false");
        }
        SchemaDTO schema = parameter.getSchema();
        ParameterDTOUtil.validateParamStyleAndDataTypesPair((String)parameter.getName(), (ParamStyle)ParamStyle.SPACE_DELIMITED, (DataType)schema.getType(), List.of(DataType.OBJECT, DataType.ARRAY));
        String SPACE = "%20";
        if (schema.getType() == DataType.ARRAY) {
            List items = schema.getItems();
            ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)CollectionUtils.isEmpty((Collection)items), (String)"items", (Object)items);
            return ParameterDTOUtil.listToString((List)items, (String)"", (String)"%20");
        }
        Map properties = schema.getProperties();
        ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)CollectionUtils.isEmpty((Map)properties), (String)"properties", (Object)properties);
        return ParameterDTOUtil.mapToString((Map)properties, (String)"", (String)"%20", (String)"%20");
    }

    private static String constructPipeDelimited(ParameterDTO parameter) {
        ParameterDTOUtil.validateParamStyleAndLocationsPair((String)parameter.getName(), (ParamStyle)ParamStyle.PIPE_DELIMITED, (ParamLocation)parameter.getIn(), List.of(ParamLocation.QUERY));
        if (parameter.isExplode()) {
            throw new IllegalArgumentException("For parameter.name = '" + parameter.getName() + "' with type = '" + ParamStyle.PIPE_DELIMITED.getStyle() + "' explode must be false");
        }
        SchemaDTO schema = parameter.getSchema();
        ParameterDTOUtil.validateParamStyleAndDataTypesPair((String)parameter.getName(), (ParamStyle)ParamStyle.PIPE_DELIMITED, (DataType)schema.getType(), List.of(DataType.OBJECT, DataType.ARRAY));
        String PIPE = "|";
        if (schema.getType() == DataType.ARRAY) {
            List items = schema.getItems();
            ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)CollectionUtils.isEmpty((Collection)items), (String)"items", (Object)items);
            return ParameterDTOUtil.listToString((List)items, (String)"", (String)"|");
        }
        Map properties = schema.getProperties();
        ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)CollectionUtils.isEmpty((Map)properties), (String)"properties", (Object)properties);
        return ParameterDTOUtil.mapToString((Map)properties, (String)"", (String)"|", (String)"|");
    }

    private static String constructDeepObject(ParameterDTO parameter) {
        ParameterDTOUtil.validateParamStyleAndLocationsPair((String)parameter.getName(), (ParamStyle)ParamStyle.DEEP_OBJECT, (ParamLocation)parameter.getIn(), List.of(ParamLocation.QUERY));
        if (!parameter.isExplode()) {
            throw new IllegalArgumentException("For parameter.name = '" + parameter.getName() + "' with type = '" + ParamStyle.SPACE_DELIMITED.getStyle() + "' explode must be true");
        }
        SchemaDTO schema = parameter.getSchema();
        ParameterDTOUtil.validateParamStyleAndDataTypesPair((String)parameter.getName(), (ParamStyle)ParamStyle.DEEP_OBJECT, (DataType)schema.getType(), List.of(DataType.OBJECT));
        Map properties = schema.getProperties();
        ParameterDTOUtil.validateNotEmptyValue((ParameterDTO)parameter, (boolean)CollectionUtils.isEmpty((Map)properties), (String)"properties", (Object)properties);
        return properties.entrySet().stream().map(entry -> ParameterDTOUtil.deepObjectToString((String)(parameter.getName() + "[" + (String)entry.getKey() + "]"), (SchemaDTO)((SchemaDTO)entry.getValue()))).collect(Collectors.joining("&"));
    }

    private static String deepObjectToString(String pointer, SchemaDTO schema) {
        DataType type = schema.getType();
        if (type == DataType.OBJECT) {
            Map properties = schema.getProperties();
            if (CollectionUtils.isEmpty((Map)properties)) {
                throw new IllegalArgumentException("ParameterDTO could not be converted if ParamStyle is DEEP_OBJECT ans properties is empty/null, pointer = '" + pointer + "'");
            }
            StringJoiner object = new StringJoiner("&");
            for (Map.Entry property : schema.getProperties().entrySet()) {
                object.add(ParameterDTOUtil.deepObjectToString((String)(pointer + "[" + (String)property.getKey() + "]"), (SchemaDTO)((SchemaDTO)property.getValue())));
            }
            return object.toString();
        }
        if (schema.getType() == DataType.ARRAY) {
            List items = schema.getItems();
            if (CollectionUtils.isEmpty((Collection)items)) {
                throw new IllegalArgumentException("ParameterDTO could not be converted if ParamStyle is DEEP_OBJECT ans items is empty/null, pointer = '" + pointer + "'");
            }
            StringJoiner array = new StringJoiner("&");
            int index = 0;
            for (SchemaDTO item : items) {
                array.add(ParameterDTOUtil.deepObjectToString((String)(pointer + "[" + index + "]"), (SchemaDTO)item));
                ++index;
            }
            return array.toString();
        }
        if (schema.getValue() == null) {
            throw new IllegalArgumentException("ParameterDTO could not be converted if ParamStyle is DEEP_OBJECT ans value is null, pointer = '" + pointer + "'");
        }
        return pointer + "=" + schema.getValue();
    }

    private static String listToString(List<SchemaDTO> items, String prefix, String delimiter) {
        return prefix + items.stream().map(SchemaDTO::getValue).collect(Collectors.joining(delimiter));
    }

    private static String mapToString(Map<String, SchemaDTO> properties, String prefix, String separator, String delimiter) {
        return prefix + properties.entrySet().stream().map(entry -> (String)entry.getKey() + separator + ((SchemaDTO)entry.getValue()).getValue()).collect(Collectors.joining(delimiter));
    }

    private static void validateParamStyleAndLocationsPair(String name, ParamStyle currentStyle, ParamLocation currentLocation, List<ParamLocation> validLocations) {
        if (validLocations.contains(currentLocation)) {
            return;
        }
        String locations = validLocations.stream().map(ParamLocation::getLocation).collect(Collectors.joining(", "));
        throw new IllegalArgumentException(String.format("ParamStyle of '%s' is wrong for parameter.name = '%s'. ParamStyle should be in [%s]", currentStyle.getStyle(), name, locations));
    }

    private static void validateParamStyleAndDataTypesPair(String name, ParamStyle currentStyle, DataType currentType, List<DataType> validTypes) {
        if (validTypes.contains(currentType)) {
            return;
        }
        String dataTypes = validTypes.stream().map(DataType::getType).collect(Collectors.joining(", "));
        throw new IllegalArgumentException(String.format("DataType of '%s' is wrong for parameter.name = '%s' and style = '%s'. DataType should be in [%s]", currentType.getType(), name, currentStyle.getStyle(), dataTypes));
    }

    private static void validateNotEmptyValue(ParameterDTO p, boolean invalid, String field, Object value) {
        SchemaDTO schema = p.getSchema();
        String message = "Parameter should have not empty value, parameter = { name = '%s', location = '%s', style = '%s', schema = { type = '%s', %s = %s}}";
        if (invalid) {
            message = String.format(message, p.getName(), p.getIn().getLocation(), p.getStyle().getStyle(), schema.getType().getType(), field, value == null ? "null" : value.toString());
            throw new IllegalArgumentException(message);
        }
    }
}

