/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.resource.error;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.annotation.Resource;
import java.util.Date;
import org.springframework.http.HttpStatus;

@Resource
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorResource {
    private Date timestamp;
    private int status;
    private String error;
    private String message;
    private String path;

    public ErrorResource(Exception e, HttpStatus status, String path) {
        this.error = status.getReasonPhrase().toUpperCase().replace(" ", "_");
        this.message = e.getMessage();
        this.status = status.value();
        this.timestamp = new Date();
        this.path = path;
    }

    public ErrorResource(Exception e, HttpStatus status) {
        this.error = status.getReasonPhrase().toUpperCase().replace(" ", "_");
        this.message = e.getMessage();
        this.status = status.value();
        this.timestamp = new Date();
    }

    public ErrorResource() {
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setStatus(HttpStatus status) {
        this.status = status.value();
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }
}

