/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.mapper.execution;

import com.becon.opencelium.backend.database.mongodb.entity.BodyMng;
import com.becon.opencelium.backend.database.mongodb.entity.ConnectionMng;
import com.becon.opencelium.backend.database.mongodb.entity.MethodMng;
import com.becon.opencelium.backend.database.mongodb.entity.RequestMng;
import com.becon.opencelium.backend.database.mongodb.entity.ResponseMng;
import com.becon.opencelium.backend.database.mongodb.service.ConnectionMngService;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.service.ConnectorService;
import com.becon.opencelium.backend.enums.execution.DataType;
import com.becon.opencelium.backend.enums.execution.ParamLocation;
import com.becon.opencelium.backend.enums.execution.ParamStyle;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.mapper.execution.OperationExMapper;
import com.becon.opencelium.backend.resource.execution.OperationDTO;
import com.becon.opencelium.backend.resource.execution.ParameterDTO;
import com.becon.opencelium.backend.resource.execution.RequestBodyDTO;
import com.becon.opencelium.backend.resource.execution.ResponseDTO;
import com.becon.opencelium.backend.resource.execution.SchemaDTO;
import com.becon.opencelium.backend.resource.execution.XmlObjectDTO;
import com.becon.opencelium.backend.utility.PathAndReferenceUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class OperationExMapper {
    private final InvokerService invokerService;
    private final ConnectionMngService connectionMngService;
    private final ConnectorService connectorService;
    private static final String REGEX_DEEP_OBJECT_IN_QUERY = ".+[\\[.+\\]]";
    private static final String REGEX_ARRAY_PARAMETER_IN_PATH = ".+[&|,\\s]+.*";
    private static final MultipleXmlAttrsStrategy MULTIPLE_XML_ATTRS_STRATEGY = MultipleXmlAttrsStrategy.FAIL;
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String OC_VALUE = "__oc__value";
    private static final String OC_ATTRIBUTES = "__oc__attributes";

    public OperationExMapper(@Qualifier(value="invokerServiceImp") InvokerService invokerService, @Qualifier(value="connectionMngServiceImp") ConnectionMngService connectionMngService, @Qualifier(value="connectorServiceImp") ConnectorService connectorService) {
        this.invokerService = invokerService;
        this.connectionMngService = connectionMngService;
        this.connectorService = connectorService;
    }

    public List<OperationDTO> toOperationAll(List<MethodMng> methods, Long connectionId, String invoker) {
        if (methods == null || methods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OperationDTO> operations = new ArrayList<OperationDTO>();
        for (MethodMng method : methods) {
            operations.add(this.toOperation(method, connectionId, invoker));
        }
        return operations;
    }

    public OperationDTO toOperation(@NonNull MethodMng method, Long connectionId, String invokerStr) {
        Invoker invoker = this.invokerService.findByName(invokerStr);
        List operations = invoker.getOperations();
        FunctionInvoker fiv = operations.stream().filter(o -> o.getName().equals(method.getName())).findAny().orElseThrow(() -> new RuntimeException("No operation found for name: " + method.getName()));
        MediaType mediaType = this.getMediaType(method, fiv);
        OperationDTO operationDTO = new OperationDTO();
        operationDTO.setOperationId(method.getColor());
        operationDTO.setHttpMethod(HttpMethod.valueOf((String)method.getRequest().getMethod()));
        operationDTO.setName(method.getName());
        operationDTO.setAggregatorId(method.getDataAggregator());
        operationDTO.setPath(method.getRequest().getEndpoint());
        operationDTO.setExecOrder(method.getIndex());
        operationDTO.setRequestBody(this.getRequestBody(method.getRequest().getBody(), connectionId, method.getName(), mediaType));
        operationDTO.setResponses(this.getResponses(method.getResponse(), fiv));
        operationDTO.setParameters(this.getParameters(method.getRequest(), mediaType));
        return operationDTO;
    }

    private MediaType getMediaType(MethodMng methodMng, FunctionInvoker fiv) {
        MediaType mediaType = this.getContentTypeFromHeader(methodMng.getRequest().getHeader());
        if (mediaType != null) {
            return mediaType;
        }
        mediaType = this.getContentTypeFromHeader(fiv.getRequest().getHeader());
        if (mediaType != null) {
            return mediaType;
        }
        if (methodMng.getRequest().getBody() != null && methodMng.getRequest().getBody().getFormat() != null && (mediaType = this.getMediaTypeFromBody(methodMng.getRequest().getBody().getFormat())) != null) {
            return mediaType;
        }
        return fiv.getRequest().getBody() == null || fiv.getRequest().getBody().getFormat() == null || (mediaType = this.getMediaTypeFromBody(fiv.getRequest().getBody().getFormat())) == null ? MediaType.APPLICATION_JSON : mediaType;
    }

    private MediaType getContentTypeFromHeader(Map<String, String> header) {
        String contentType;
        if (header != null && header.containsKey("Content-Type") && (contentType = header.get("Content-Type")) != null) {
            try {
                return MediaType.parseMediaType((String)contentType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private MediaType getMediaTypeFromBody(String format) {
        return switch (format) {
            case "xml" -> MediaType.APPLICATION_XML;
            case "json" -> MediaType.APPLICATION_JSON;
            case "text" -> MediaType.TEXT_PLAIN;
            case "x-www-form-urlencoded" -> MediaType.APPLICATION_FORM_URLENCODED;
            case "file" -> MediaType.APPLICATION_PDF;
            case "image" -> MediaType.IMAGE_PNG;
            default -> null;
        };
    }

    private List<ResponseDTO> getResponses(ResponseMng response, FunctionInvoker fiv) {
        MediaType mt;
        ArrayList<ResponseDTO> res = new ArrayList<ResponseDTO>(2);
        if (response == null) {
            return res;
        }
        if (response.getSuccess() != null) {
            ResponseDTO success = new ResponseDTO();
            success.setStatus("success");
            success.setCode(response.getSuccess().getStatus());
            if (response.getSuccess().getBody() != null) {
                success.setFormat(response.getSuccess().getBody().getFormat());
                success.setData(response.getSuccess().getBody().getData());
            }
            res.add(success);
            mt = fiv.getResponse().getSuccess().getBody() != null ? this.getMediaTypeFromBody(fiv.getResponse().getSuccess().getBody().getFormat()) : MediaType.APPLICATION_JSON;
            success.setContent(mt == null ? MediaType.APPLICATION_JSON : mt);
        }
        if (response.getFail() != null) {
            ResponseDTO fail = new ResponseDTO();
            fail.setStatus("fail");
            fail.setCode(response.getFail().getStatus());
            if (response.getFail().getBody() != null) {
                fail.setFormat(response.getFail().getBody().getFormat());
                fail.setData(response.getFail().getBody().getData());
            }
            res.add(fail);
            mt = fiv.getResponse().getFail().getBody() != null ? this.getMediaTypeFromBody(fiv.getResponse().getFail().getBody().getFormat()) : MediaType.APPLICATION_JSON;
            fail.setContent(mt == null ? MediaType.APPLICATION_JSON : mt);
        }
        return res;
    }

    private List<ParameterDTO> getParameters(@NonNull RequestMng request, MediaType mediaType) {
        List parameters = this.getHeaderParameters(request.getHeader(), mediaType);
        int indexOfQuestionSign = PathAndReferenceUtility.findIndexOfQuesSign((String)request.getEndpoint());
        if (indexOfQuestionSign != -1) {
            String query = request.getEndpoint().substring(indexOfQuestionSign + 1);
            parameters.addAll(this.getQueryParameters(query, mediaType));
        }
        if (indexOfQuestionSign != -1) {
            String path = request.getEndpoint().substring(0, indexOfQuestionSign);
            parameters.addAll(this.getPathParameters(path, mediaType));
        } else {
            parameters.addAll(this.getPathParameters(request.getEndpoint(), mediaType));
        }
        return parameters;
    }

    private List<ParameterDTO> getHeaderParameters(Map<String, String> header, MediaType mediaType) {
        ArrayList<ParameterDTO> parameters = new ArrayList<ParameterDTO>();
        if (header == null) {
            return parameters;
        }
        for (Map.Entry<String, String> entry : header.entrySet()) {
            ParameterDTO parameterDTO = new ParameterDTO();
            if (entry.getKey().equals("Cookie")) {
                this.addCookieParams(entry.getValue(), parameters);
                continue;
            }
            parameterDTO.setName(entry.getKey());
            parameterDTO.setIn(ParamLocation.HEADER);
            parameterDTO.setStyle(ParamStyle.SIMPLE);
            parameterDTO.setContent(mediaType);
            boolean explode = false;
            String value = entry.getValue();
            if (value == null || value.isBlank()) continue;
            String[] split = value.split(",");
            if (split.length == 1) {
                parameterDTO.setSchema(this.getSchema(value, DataType.STRING));
            } else if (split[0].contains("=")) {
                explode = true;
                SchemaDTO schemaDTO = new SchemaDTO();
                schemaDTO.setType(DataType.OBJECT);
                HashMap<String, SchemaDTO> propertiesOfObject = new HashMap<String, SchemaDTO>();
                for (String s : split) {
                    String[] pairs = s.split("=");
                    propertiesOfObject.put(pairs[0], this.getSchema(pairs[1], DataType.STRING));
                }
                schemaDTO.setProperties(propertiesOfObject);
                parameterDTO.setSchema(schemaDTO);
            } else {
                parameterDTO.setSchema(this.getSchema(value, DataType.ARRAY));
            }
            parameterDTO.setExplode(explode);
            parameters.add(parameterDTO);
        }
        return parameters;
    }

    private void addCookieParams(String value, List<ParameterDTO> parameters) {
        if (value == null || value.isBlank()) {
            return;
        }
        value = value.trim();
        List pairs = PathAndReferenceUtility.splitByDelimiter((String)value, (char)';');
        for (String kv : pairs) {
            List keyVal = PathAndReferenceUtility.splitByDelimiter((String)kv, (char)'=');
            SchemaDTO schemaDTO = new SchemaDTO();
            schemaDTO.setType(DataType.STRING);
            ParameterDTO parameterDTO = new ParameterDTO();
            if (keyVal.size() == 2) {
                schemaDTO.setValue(((String)keyVal.get(1)).trim());
                parameterDTO.setStyle(ParamStyle.FORM);
                parameterDTO.setIn(ParamLocation.COOKIE);
                parameterDTO.setName(((String)keyVal.get(0)).trim());
            } else {
                if (keyVal.size() != 1) continue;
                schemaDTO.setValue(((String)keyVal.get(0)).trim());
                parameterDTO.setIn(ParamLocation.HEADER);
                parameterDTO.setStyle(ParamStyle.SIMPLE);
                parameterDTO.setName("Cookie");
            }
            parameterDTO.setSchema(schemaDTO);
            parameters.add(parameterDTO);
        }
    }

    private List<ParameterDTO> getPathParameters(String path, MediaType mediaType) {
        if (path == null || path.trim().isBlank()) {
            return Collections.emptyList();
        }
        ArrayList<ParameterDTO> list = new ArrayList<ParameterDTO>();
        List subPaths = PathAndReferenceUtility.splitByDelimiter((String)path, (char)'/');
        for (String subPath : subPaths) {
            if (!subPath.contains("{") || !subPath.contains("}")) continue;
            ArrayList params = this.getSubPathParameters(subPath);
            for (String param : params) {
                String paramName = this.extractNameOfRef(param);
                ParameterDTO parameterDTO = new ParameterDTO();
                parameterDTO.setIn(ParamLocation.PATH);
                parameterDTO.setName(paramName);
                parameterDTO.setStyle(ParamStyle.SIMPLE);
                parameterDTO.setContent(mediaType);
                parameterDTO.setSchema(this.getSchema(param, DataType.STRING));
                list.add(parameterDTO);
            }
        }
        return list;
    }

    private List<ParameterDTO> getQueryParameters(String query, MediaType mediaType) {
        ParameterDTO parameterDTO;
        if (query == null || query.trim().isBlank()) {
            return Collections.emptyList();
        }
        ArrayList<ParameterDTO> parameters = new ArrayList<ParameterDTO>();
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        Tree objectParametersTree = new Tree();
        List pairs = PathAndReferenceUtility.getQueryVariables((String)query);
        for (String[] stringArray : pairs) {
            parametersMap.merge(stringArray[0], stringArray[1] == null ? "" : stringArray[1], (oldV, newV) -> oldV + "&" + newV);
        }
        for (Map.Entry entry : parametersMap.entrySet()) {
            parameterDTO = new ParameterDTO();
            String value = ((String)entry.getValue()).replace("%20", " ");
            if (((String)entry.getKey()).matches(".+[\\[.+\\]]")) {
                objectParametersTree.insert((String)entry.getKey(), value);
                continue;
            }
            if (value.matches(".+[&|,\\s]+.*")) {
                this.dealWithArray(value, parameterDTO);
            } else {
                parameterDTO.setStyle(ParamStyle.FORM);
                parameterDTO.setExplode(true);
                parameterDTO.setSchema(this.getSchema(value, DataType.STRING));
            }
            parameterDTO.setName((String)entry.getKey());
            parameterDTO.setContent(mediaType);
            parameterDTO.setIn(ParamLocation.QUERY);
            parameters.add(parameterDTO);
        }
        for (Node node : objectParametersTree.getNodes()) {
            parameterDTO = new ParameterDTO();
            parameterDTO.setContent(mediaType);
            parameterDTO.setIn(ParamLocation.QUERY);
            parameterDTO.setStyle(ParamStyle.DEEP_OBJECT);
            parameterDTO.setExplode(true);
            parameterDTO.setName(node.getKey());
            parameterDTO.setSchema(this.getSchema(node));
            parameters.add(parameterDTO);
        }
        return parameters;
    }

    private RequestBodyDTO getRequestBody(BodyMng body, Long connectionId, String methodName, MediaType mediaType) {
        if (body == null || body.getFormat() == null || body.getFields() == null) {
            return null;
        }
        RequestBodyDTO requestBodyDTO = new RequestBodyDTO();
        requestBodyDTO.setContent(mediaType);
        requestBodyDTO.setSchema(this.getSchema(body, connectionId, methodName));
        return requestBodyDTO;
    }

    private SchemaDTO getSchema(String source, DataType dataType) {
        return switch (2.$SwitchMap$com$becon$opencelium$backend$enums$execution$DataType[dataType.ordinal()]) {
            case 1 -> new SchemaDTO(DataType.NUMBER, source);
            case 2 -> new SchemaDTO(DataType.INTEGER, source);
            case 3 -> new SchemaDTO(DataType.STRING, source);
            case 4 -> new SchemaDTO(DataType.BOOLEAN, source);
            case 5 -> this.getSchemaFromArray(source);
            default -> null;
        };
    }

    private SchemaDTO getSchema(BodyMng body, Long connectionId, String methodName) {
        Map fields = body.getFields();
        if (fields == null) {
            return null;
        }
        SchemaDTO schemaDTO = new SchemaDTO();
        String type = body.getType();
        if ("array".equals(type)) {
            body.setType("object");
            schemaDTO.setType(DataType.ARRAY);
            schemaDTO.setItems((List)new /* Unavailable Anonymous Inner Class!! */);
            return schemaDTO;
        }
        schemaDTO.setType(DataType.OBJECT);
        LinkedHashMap<String, SchemaDTO> props = new LinkedHashMap<String, SchemaDTO>();
        for (Map.Entry entry : fields.entrySet()) {
            LinkedList<String> hierarchy = new LinkedList<String>();
            hierarchy.add((String)entry.getKey());
            if (body.getData().equals("graphql")) {
                Object v;
                String queryFieldName = "query";
                Map map = body.getFields();
                if (map.containsKey(queryFieldName) && (v = map.get(queryFieldName)) instanceof String) {
                    String query = (String)v;
                    map.put(queryFieldName, query.replace("\n", ""));
                }
            }
            if (body.getFormat().equals("xml")) {
                String name = (String)entry.getKey();
                if (name.matches("^[a-zA-Z ]+:.*$")) {
                    name = name.substring(name.indexOf(":") + 1);
                }
                props.put(name, this.getSchemaFromObjectXML(hierarchy, entry.getValue(), connectionId, methodName));
                continue;
            }
            props.put((String)entry.getKey(), this.getSchemaFromObjectJSON(hierarchy, entry.getValue(), connectionId, methodName));
        }
        if (body.getFormat().equals("xml")) {
            schemaDTO.setXml(new XmlObjectDTO());
        }
        schemaDTO.setProperties(props);
        return schemaDTO;
    }

    private void setXmlAttributes(SchemaDTO currSchema, Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            currSchema.setXml(new XmlObjectDTO());
            return;
        }
        String attrName = MultipleXmlAttrsStrategy.applyStrategy(map, (MultipleXmlAttrsStrategy)MULTIPLE_XML_ATTRS_STRATEGY);
        String value = map.get(attrName);
        int startIndexOfPrefix = attrName.indexOf("xmlns:");
        if (startIndexOfPrefix != -1) {
            attrName = attrName.substring(startIndexOfPrefix + "xmlns:".length());
        }
        XmlObjectDTO xmlObjectDTO = new XmlObjectDTO();
        xmlObjectDTO.setPrefix(attrName);
        xmlObjectDTO.setNamespace(value);
        currSchema.setXml(xmlObjectDTO);
    }

    private SchemaDTO getSchemaFromObjectXML(LinkedList<String> hierarchy, Object value, Long connectionId, String methodName) {
        SchemaDTO schemaDTO = new SchemaDTO();
        DataType type = this.getType(value);
        if (value == null || type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            String stringVal = String.valueOf(value);
            schemaDTO.setType(this.findTypeOfReference(stringVal, connectionId, methodName, hierarchy));
            schemaDTO.setValue(stringVal);
        } else if (type == DataType.OBJECT) {
            Map map = (Map)value;
            if (map.size() == 2 && map.containsKey("__oc__value") && map.containsKey("__oc__attributes") || map.size() == 1 && map.containsKey("__oc__value")) {
                String strVal = String.valueOf(map.get("__oc__value"));
                schemaDTO.setValue(strVal);
                if (map.get("__oc__value") instanceof Boolean) {
                    schemaDTO.setType(DataType.BOOLEAN);
                } else if (map.get("__oc__value") instanceof Integer) {
                    schemaDTO.setType(DataType.INTEGER);
                } else if (map.get("__oc__value") instanceof Number) {
                    schemaDTO.setType(DataType.NUMBER);
                } else {
                    hierarchy.add("__oc__value");
                    schemaDTO.setType(this.findTypeOfReference(strVal, connectionId, methodName, hierarchy));
                    hierarchy.remove("__oc__value");
                }
                Object attr = map.get("__oc__attributes");
                if (attr != null && !attr.equals("")) {
                    Map attrs = (Map)attr;
                    schemaDTO.setProperties(new HashMap());
                    this.setXmlAttributes(schemaDTO, attrs);
                } else {
                    schemaDTO.setXml(new XmlObjectDTO());
                }
            } else {
                schemaDTO.setType(DataType.OBJECT);
                LinkedHashMap<String, SchemaDTO> fields = new LinkedHashMap<String, SchemaDTO>();
                schemaDTO.setProperties(fields);
                for (Map.Entry entry : map.entrySet()) {
                    if (((String)entry.getKey()).equals("__oc__attributes")) {
                        if (entry.getValue() != null && !entry.getValue().equals("")) {
                            Map attrs = (Map)entry.getValue();
                            this.setXmlAttributes(schemaDTO, attrs);
                            continue;
                        }
                        schemaDTO.setXml(new XmlObjectDTO());
                        continue;
                    }
                    String name = (String)entry.getKey();
                    if (name.contains(":")) {
                        name = name.split(":")[1];
                    }
                    hierarchy.add((String)entry.getKey());
                    fields.put(name, this.getSchemaFromObjectXML(hierarchy, entry.getValue(), connectionId, methodName));
                }
            }
        } else if (type == DataType.ARRAY) {
            List items = (List)value;
            schemaDTO.setType(DataType.ARRAY);
            ArrayList<SchemaDTO> elements = new ArrayList<SchemaDTO>();
            schemaDTO.setItems(elements);
            for (int i = 0; i < items.size(); ++i) {
                hierarchy.add("[" + i + "]");
                elements.add(this.getSchemaFromObjectXML(hierarchy, items.get(i), connectionId, methodName));
            }
            XmlObjectDTO xod = new XmlObjectDTO();
            schemaDTO.setXml(xod);
        } else {
            schemaDTO.setType(type);
        }
        hierarchy.removeLast();
        return schemaDTO;
    }

    private SchemaDTO getSchemaFromObjectJSON(LinkedList<String> hierarchy, Object obj, Long connectionId, String methodName) {
        SchemaDTO schemaDTO = new SchemaDTO();
        DataType type = this.getType(obj);
        if (obj == null || type == null) {
            return null;
        }
        if (type == DataType.STRING) {
            String value = String.valueOf(obj);
            schemaDTO.setType(this.findTypeOfReference(value, connectionId, methodName, hierarchy));
            schemaDTO.setValue(value);
        } else if (type != DataType.OBJECT && type != DataType.ARRAY) {
            schemaDTO.setType(type);
            schemaDTO.setValue(String.valueOf(obj));
        } else if (obj instanceof List) {
            List items = (List)obj;
            schemaDTO.setType(DataType.ARRAY);
            ArrayList<SchemaDTO> elements = new ArrayList<SchemaDTO>();
            for (int i = 0; i < items.size(); ++i) {
                hierarchy.add("[" + i + "]");
                elements.add(this.getSchemaFromObjectJSON(hierarchy, items.get(i), connectionId, methodName));
            }
            schemaDTO.setItems(elements);
        } else {
            Map map = (Map)obj;
            schemaDTO.setType(DataType.OBJECT);
            LinkedHashMap<String, SchemaDTO> fields = new LinkedHashMap<String, SchemaDTO>();
            for (Map.Entry entry : map.entrySet()) {
                hierarchy.add((String)entry.getKey());
                fields.put((String)entry.getKey(), this.getSchemaFromObjectJSON(hierarchy, entry.getValue(), connectionId, methodName));
            }
            schemaDTO.setProperties(fields);
        }
        hierarchy.removeLast();
        return schemaDTO;
    }

    private DataType findTypeOfReference(String value, Long connectionId, String methodName, LinkedList<String> hierarchy) {
        if (value.matches("\\{(.*?)\\}") || value.matches("#\\{%[0-9a-fA-F]{24}%\\}") || value.matches("#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+") || value.matches("\\$\\{(.*?)\\}")) {
            ConnectionMng connectionMng = this.connectionMngService.getByConnectionId(connectionId);
            Connector fromConnector = this.connectorService.getById(connectionMng.getFromConnector().getConnectorId());
            Connector toConnector = this.connectorService.getById(connectionMng.getToConnector().getConnectorId());
            DataType dataType = this.invokerService.findFieldType(fromConnector.getInvoker(), methodName, (LinkedList)hierarchy.clone());
            if (dataType == null && (dataType = this.invokerService.findFieldType(toConnector.getInvoker(), methodName, (LinkedList)hierarchy.clone())) == null) {
                throw new RuntimeException("METHOD_NOT_FOUND_IN_INVOKER");
            }
            return dataType;
        }
        return DataType.STRING;
    }

    private SchemaDTO getSchema(Node node) {
        SchemaDTO schemaDTO = new SchemaDTO();
        if (node.getValue() != null) {
            String value = node.getValue();
            schemaDTO.setType(DataType.STRING);
            schemaDTO.setValue(value);
            return schemaDTO;
        }
        String firstKey = ((Node)node.getFields().get(0)).getKey();
        if (firstKey.matches("[\\d+]")) {
            if (schemaDTO.getItems() == null) {
                schemaDTO.setItems(new ArrayList());
            }
            for (Node field : node.getFields()) {
                schemaDTO.getItems().add(this.getSchema(field));
            }
            schemaDTO.setType(DataType.ARRAY);
        } else {
            for (Node field : node.getFields()) {
                if (schemaDTO.getProperties() == null) {
                    schemaDTO.setProperties(new HashMap());
                }
                schemaDTO.setType(DataType.OBJECT);
                schemaDTO.getProperties().put(field.getKey(), this.getSchema(field));
            }
        }
        return schemaDTO;
    }

    private SchemaDTO getSchemaFromArray(String source) {
        String[] split = source.split(",");
        SchemaDTO schemaDTO = new SchemaDTO();
        schemaDTO.setType(DataType.ARRAY);
        ArrayList<SchemaDTO> schemas = new ArrayList<SchemaDTO>();
        for (String s : split) {
            schemas.add(this.getSchema(s, DataType.STRING));
        }
        schemaDTO.setItems(schemas);
        return schemaDTO;
    }

    private void dealWithArray(String value, ParameterDTO parameterDTO) {
        if (value.contains("&")) {
            parameterDTO.setStyle(ParamStyle.FORM);
            parameterDTO.setExplode(true);
            parameterDTO.setSchema(this.getSchema(value.replace('&', ','), DataType.ARRAY));
        } else if (value.contains(",")) {
            parameterDTO.setStyle(ParamStyle.FORM);
            parameterDTO.setExplode(false);
            parameterDTO.setSchema(this.getSchema(value, DataType.ARRAY));
        } else if (value.contains("|")) {
            parameterDTO.setStyle(ParamStyle.PIPE_DELIMITED);
            parameterDTO.setExplode(false);
            parameterDTO.setSchema(this.getSchema(value.replace('|', ','), DataType.ARRAY));
        } else if (value.contains(" ")) {
            parameterDTO.setStyle(ParamStyle.SPACE_DELIMITED);
            parameterDTO.setExplode(false);
            parameterDTO.setSchema(this.getSchema(value.replace(' ', ','), DataType.ARRAY));
        }
    }

    private DataType getType(Object obj) {
        if (obj instanceof Integer) {
            return DataType.INTEGER;
        }
        if (obj instanceof Number) {
            return DataType.NUMBER;
        }
        if (obj instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (obj instanceof String) {
            return DataType.STRING;
        }
        if (obj instanceof List) {
            return DataType.ARRAY;
        }
        if (obj instanceof Map) {
            return DataType.OBJECT;
        }
        return null;
    }

    private ArrayList<String> getSubPathParameters(String subPath) {
        ArrayList<String> params = new ArrayList<String>();
        char[] chars = subPath.toCharArray();
        int startIdx = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{') {
                startIdx = i;
                continue;
            }
            if (chars[i] == '$' && i + 1 < chars.length && chars[i + 1] == '{') {
                startIdx = i++;
                continue;
            }
            if (chars[i] != '}' || startIdx == -1) continue;
            params.add(subPath.substring(startIdx, i + 1));
            startIdx = -1;
        }
        return params;
    }

    private String extractNameOfRef(String param) {
        if (param.matches("\\{%#[a-zA-Z0-9]{6}\\.(\\(response\\)|\\(request\\))\\..+\\%}")) {
            return param.substring(2, param.length() - 2);
        }
        if (("#" + param).matches("#\\{%[0-9a-fA-F]{24}%\\}")) {
            return param.substring(2, param.length() - 2);
        }
        if (param.matches("\\{(?!%)(.*?)(?<!%)\\}")) {
            return param.substring(1, param.length() - 1);
        }
        if (param.matches("\\$\\{(.*?)\\}")) {
            return param.substring(2, param.length() - 1);
        }
        return param;
    }
}

