/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.invoker.service;

import com.becon.opencelium.backend.database.mysql.service.InvokerSyncService;
import com.becon.opencelium.backend.enums.execution.DataType;
import com.becon.opencelium.backend.exception.StorageException;
import com.becon.opencelium.backend.exception.WrongEncode;
import com.becon.opencelium.backend.invoker.InvokerContainer;
import com.becon.opencelium.backend.invoker.entity.FunctionInvoker;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.parser.InvokerParserImp;
import com.becon.opencelium.backend.invoker.service.InvokerService;
import com.becon.opencelium.backend.resource.application.UpdateInvokerResource;
import com.becon.opencelium.backend.storage.StorageService;
import com.becon.opencelium.backend.utility.FileNameUtils;
import com.becon.opencelium.backend.utility.ReferenceUtility;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InvokerServiceImp
implements InvokerService {
    private static final Logger log = LoggerFactory.getLogger(InvokerServiceImp.class);
    @Autowired
    @Lazy
    private InvokerContainer invokerContainer;
    @Autowired
    private StorageService storageService;
    @Lazy
    @Autowired
    private InvokerSyncService invokerSyncService;
    private final Path filePath = Paths.get("runtime/invoker/", new String[0]);

    public FunctionInvoker getTestFunction(String invokerName) {
        return this.invokerContainer.getByName(invokerName).getOperations().stream().filter(f -> f.getType().equals("test")).findFirst().orElse(null);
    }

    public FunctionInvoker getAuthFunction(String invokerName) {
        return this.invokerContainer.getByName(invokerName).getOperations().stream().filter(f -> f.getType().equals("auth")).findFirst().orElse(null);
    }

    public List<FunctionInvoker> getAuthFunctions(String invoker) {
        return this.invokerContainer.getByName(invoker).getOperations().stream().filter(f -> f.getType().contains("auth")).collect(Collectors.toList());
    }

    public Invoker findByName(String name) {
        return this.invokerContainer.getByName(name);
    }

    public boolean existsByName(String name) {
        return this.invokerContainer.existsByName(name);
    }

    public boolean existsByFileName(String fileName) {
        String ext = FileNameUtils.getExtension((String)fileName);
        if (ext == null || ext.isEmpty()) {
            fileName = (String)fileName + ".xml";
        }
        Path path = Path.of("runtime/invoker/" + (String)fileName, new String[0]);
        return this.exists(path);
    }

    public List<Invoker> findAll() {
        return new ArrayList<Invoker>(this.invokerContainer.getInvokers().values());
    }

    public void delete(String name) {
        Objects.requireNonNull(name);
        this.deleteInvoker(name);
        this.invokerSyncService.delete(name);
    }

    public void deleteInvokerFile(String name) {
        try {
            Path file = this.findFileByInvokerName(name).toPath();
            if (this.exists(file)) {
                this.invokerContainer.remove(name);
                Files.delete(file.toAbsolutePath());
                this.invokerSyncService.delete(name);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to delete stored file", (Throwable)e);
        }
    }

    public void refresh() {
        List invokers = this.getAllInvokerDocuments();
        Map container = this.containerize(invokers);
        this.invokerContainer.updateAll(container);
    }

    public List<Invoker> synchronise() {
        this.refresh();
        return this.findAll();
    }

    public void moveInvokersToNewLocation(String oldPath, String newPath) {
        List oldInvokers = this.getAllPaths(oldPath);
        Path targetPath = Paths.get(newPath, new String[0]);
        if (Files.exists(targetPath, new LinkOption[0])) {
            targetPath.toFile().mkdirs();
        }
        oldInvokers.forEach(x -> {
            try {
                Files.move(x, targetPath.resolve(x.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                log.error("Failed to move {} file from {} to {}", new Object[]{x, oldPath, newPath});
                throw new RuntimeException(e);
            }
        });
        try {
            Files.deleteIfExists(Path.of(oldPath, new String[0]));
        }
        catch (IOException e) {
            log.error("Failed to remove folder {}", (Object)oldPath);
        }
    }

    public Map<String, Invoker> containerize(List<Document> invokers) {
        HashMap<String, Invoker> container = new HashMap<String, Invoker>();
        invokers.forEach(document -> {
            if (document == null) {
                return;
            }
            InvokerParserImp parser = new InvokerParserImp(document);
            File f = new File(document.getDocumentURI());
            String invoker = FileNameUtils.removeExtension((String)f.getName());
            invoker = invoker.replace("%20", " ");
            container.put(invoker, parser.parse());
        });
        return container;
    }

    private void deleteInvoker(String name) {
        Objects.requireNonNull(name);
        Invoker backup = this.invokerContainer.getByName(name);
        if (name.isEmpty()) {
            throw new RuntimeException("INVOKER_NOT_FOUND");
        }
        try {
            Path file = this.findFileByInvokerName(name).toPath();
            if (this.exists(file)) {
                this.invokerContainer.remove(name);
                Files.delete(file.toAbsolutePath());
            }
        }
        catch (IOException e) {
            this.invokerContainer.add(backup.getName(), backup);
            throw new StorageException("Failed to delete stored file", (Throwable)e);
        }
    }

    private boolean exists(Path file) {
        File tempFile = new File(file.toString());
        return tempFile.exists();
    }

    public DataType findFieldType(String invokerName, String methodName, LinkedList<String> hierarchy) {
        Invoker invoker = this.findByName(invokerName);
        Optional<FunctionInvoker> functionInvokerOp = invoker.getOperations().stream().filter(o -> o.getName().equals(methodName)).findFirst();
        if (functionInvokerOp.isEmpty()) {
            return null;
        }
        FunctionInvoker functionInvoker = functionInvokerOp.get();
        Map fields = functionInvoker.getRequest().getBody().getFields();
        return this.findFieldType((Object)fields, hierarchy, new ArrayList(hierarchy.size()));
    }

    private DataType findFieldType(Object field, LinkedList<String> hierarchy, List<String> seen) {
        if (field == null) {
            return null;
        }
        if (!(hierarchy.isEmpty() || field instanceof Map || field instanceof List)) {
            return DataType.UNDEFINED;
        }
        if (hierarchy.isEmpty()) {
            if (field instanceof Map) {
                return DataType.OBJECT;
            }
            if (field instanceof List) {
                return DataType.ARRAY;
            }
            if (field instanceof Boolean) {
                return DataType.BOOLEAN;
            }
            if (field instanceof String) {
                return DataType.STRING;
            }
            if (field instanceof Number) {
                if (field instanceof Long || field instanceof Integer || field instanceof Short) {
                    return DataType.INTEGER;
                }
                return DataType.NUMBER;
            }
        }
        if (field instanceof Map) {
            Map map = (Map)field;
            if (!map.containsKey(hierarchy.getFirst())) {
                return DataType.UNDEFINED;
            }
            Object obj = map.get(hierarchy.getFirst());
            seen.add(hierarchy.pollFirst());
            return this.findFieldType(obj, hierarchy, seen);
        }
        if (field instanceof List) {
            List list = (List)field;
            String idx = hierarchy.getFirst();
            idx = idx.replaceAll("[\\[|\\]]", "");
            int index = Integer.parseInt(idx);
            if (list.isEmpty()) {
                throw new RuntimeException(String.format("No such element in list. You tried to reference the %s element of the '%s' array, but this array is empty in the invoker file. Please populate the array with at least %s elements or modify the reference path.", idx, String.join((CharSequence)".", seen), idx));
            }
            if (index >= list.size()) {
                throw new RuntimeException(String.format("No such element in list. You tried to reference the %s element of the '%s' array, but the array's size is %d in the invoker file. Please ensure the array has at least %s elements or modify the reference path.", idx, String.join((CharSequence)".", seen), list.size(), idx));
            }
            Object obj = list.get(index);
            seen.set(seen.size() - 1, seen.get(seen.size() - 1) + hierarchy.pollFirst());
            return this.findFieldType(obj, hierarchy, seen);
        }
        return DataType.OBJECT;
    }

    public String findFieldByPath(String invokerName, String methodName, String path) {
        String fieldValue;
        String lastElem;
        Map fields;
        path = ((String)path).replace("@", "__oc__attributes.");
        String exchangeType = ReferenceUtility.extractExchangeType((String)path);
        String result = ReferenceUtility.getResult((String)path);
        Invoker invoker = this.findByName(invokerName);
        FunctionInvoker functionInvoker = invoker.getOperations().stream().filter(o -> o.getName().equals(methodName)).findFirst().orElseThrow(() -> new RuntimeException("Method not found in invoker"));
        String format = "";
        if (exchangeType.equals("response") && result.equals("success")) {
            fields = functionInvoker.getResponse().getSuccess().getBody().getFields();
            if (functionInvoker.getResponse().getSuccess().getBody() != null) {
                format = functionInvoker.getResponse().getSuccess().getBody().getFormat();
            }
        } else if (exchangeType.equals("response") && result.equals("fail")) {
            fields = functionInvoker.getResponse().getFail().getBody().getFields();
            if (functionInvoker.getResponse().getFail().getBody() != null) {
                format = functionInvoker.getResponse().getFail().getBody().getFormat();
            }
        } else {
            fields = functionInvoker.getRequest().getBody().getFields();
            if (functionInvoker.getRequest().getBody() != null) {
                format = functionInvoker.getRequest().getBody().getFormat();
            }
        }
        String[] valueParts = ReferenceUtility.splitPaths((String)path);
        if (format.equals("xml") && !(lastElem = valueParts[valueParts.length - 1]).contains("@")) {
            path = (String)path + ".__oc__value";
        }
        Object value = new Object();
        for (String part : valueParts) {
            value = fields.get(part);
            if (value instanceof Map) {
                fields = (Map)value;
            }
            if (!(value instanceof ArrayList)) continue;
            fields = (Map)((ArrayList)value).get(0);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            fieldValue = objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return fieldValue;
    }

    public Map<String, String> findAllByPathAsString(String path) {
        return this.getAll(path);
    }

    public UpdateInvokerResource toUpdateInvokerResource(Map.Entry<String, String> entry) {
        UpdateInvokerResource updateInvokerResource = new UpdateInvokerResource();
        XPathFactory xpathfactory = XPathFactory.newInstance();
        String fileName = entry.getKey();
        String inv = entry.getValue();
        updateInvokerResource.setName(fileName);
        updateInvokerResource.setContent(inv);
        return updateInvokerResource;
    }

    public Map<String, Invoker> findAllAsMap() {
        return null;
    }

    public Document getDocument(String name) throws Exception {
        File file = new File(this.filePath + "/" + name);
        if (!FileNameUtils.getExtension((String)file.getName()).equals("xml")) {
            return null;
        }
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return file.exists() ? dBuilder.parse(file) : null;
    }

    public List<Document> getAllInvokerDocuments() {
        try {
            Stream<Path> allInvokers = Files.walk(this.filePath, 1, new FileVisitOption[0]).filter(path -> !path.equals(this.filePath)).map(this.filePath::relativize);
            return allInvokers.map(p -> new File(this.filePath + "/" + p.getFileName())).filter(f -> f.getName().endsWith(".xml")).map(file -> {
                try {
                    DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    return dBuilder.parse((File)file);
                }
                catch (Exception e) {
                    log.error("Failed to parse Invoker[name: {}]", (Object)file.getName());
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException("Failed to read stored files", (Throwable)e);
        }
    }

    public void save(Document document) {
        InvokerParserImp parser = new InvokerParserImp(document);
        File f = new File(document.getDocumentURI());
        String invoker = FileNameUtils.removeExtension((String)f.getName());
        invoker = invoker.replace("%20", " ");
        this.invokerContainer.add(invoker, parser.parse());
    }

    public File findFileByInvokerName(String invokerName) {
        File directory = new File("runtime/invoker/");
        File[] files = directory.listFiles((dir, name) -> name.endsWith(".xml"));
        if (files != null) {
            Optional<File> foundFile = Arrays.stream(files).filter(file -> this.hasInvokerName(file, invokerName)).findFirst();
            if (foundFile.isEmpty()) {
                throw new RuntimeException("Invoker '" + invokerName + "' not found.");
            }
            return foundFile.get();
        }
        throw new RuntimeException("Invokers not found.");
    }

    private Boolean hasInvokerName(File file, String nodeName) {
        try {
            String xPathExpr = "/invoker/name";
            String nodeValue = InvokerServiceImp.getNodeValue((File)file, (String)xPathExpr);
            Objects.requireNonNull(nodeValue);
            return nodeValue.equals(nodeName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getNodeValue(File xmlFile, String xpathExpression) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            XPathExpression expression = xpath.compile(xpathExpression);
            return expression.evaluate(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object findField(String field, Map<String, Object> body) {
        if (body == null) {
            return null;
        }
        HashMap fields = new HashMap();
        Object r = null;
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            String k = entry.getKey();
            Object object = entry.getValue();
            if (k.equals(field)) {
                return object;
            }
            if (object instanceof HashMap) {
                r = this.findField(field, (Map)object);
            } else if (object instanceof ArrayList && !((ArrayList)object).isEmpty() && ((ArrayList)object).get(0) instanceof HashMap) {
                Map subFields = (Map)((ArrayList)object).get(0);
                r = this.findField(field, subFields);
            }
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private Map<String, String> getAll(String folder) throws WrongEncode {
        Map<String, String> map;
        block8: {
            Stream<Path> walk = Files.walk(Paths.get(folder, new String[0]), new FileVisitOption[0]);
            try {
                map = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> FileNameUtils.getExtension((String)path.toString()).equals("xml")).map(path -> {
                    Map.Entry<String, String> entry;
                    block8: {
                        StringBuilder contentBuilder = new StringBuilder();
                        Stream<String> stream = Files.lines(Paths.get(path.toString(), new String[0]), StandardCharsets.UTF_8);
                        try {
                            Map.Entry<String, String> entry2;
                            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
                            entry = entry2 = Collections.singletonMap(Paths.get(path.toString(), new String[0]).getFileName().toString(), contentBuilder.toString()).entrySet().iterator().next();
                            if (stream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new WrongEncode("UTF8");
                            }
                        }
                        stream.close();
                    }
                    return entry;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return map;
    }

    private List<Path> getAllPaths(String folder) {
        List<Path> list;
        block9: {
            if (Files.notExists(Paths.get(folder, new String[0]), new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> walk = Files.walk(Paths.get(folder, new String[0]), new FileVisitOption[0]);
            try {
                list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toAbsolutePath).toList();
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return list;
    }
}

